COMMENT

   **************************************************
   File generated by: neuroConstruct v1.3.8 
   **************************************************

   This file holds the implementation in NEURON of the Cell Mechanism:
   Kdr_ChannelML (Type: Channel mechanism, Model: Template based ChannelML file)

   with parameters: 
   /channelml/@units = Physiological Units 
   /channelml/notes = ChannelML file containing a single Channel description 
   /channelml/ion/@name = k 
   /channelml/ion/@default_erev = -77.0 
   /channelml/ion/@charge = 1 
   /channelml/channel_type/@name = Kdr_ChannelML 
   /channelml/channel_type/@density = yes 
   /channelml/channel_type/status/@value = in_progress 
   /channelml/channel_type/status/comment = Equations adapted from paper for modern convention of external potential being zero 
   /channelml/channel_type/status/contributor/name = Padraig Gleeson 
   /channelml/channel_type/notes = Mitral cell K DR channel 
   /channelml/channel_type/neuronDBref/modelName = K channels 
   /channelml/channel_type/neuronDBref/uri = http://senselab.med.yale.edu/senselab/NeuronDB/channelGene2.htm#table3 
   /channelml/channel_type/current_voltage_relation/ohmic/@ion = k 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/@default_gmax = 36 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/rate_adjustments/q10_settings/@q10_factor = 3 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/rate_adjustments/q10_settings/@experimental_temp = 24 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate/@power = 1 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate/state/@name = m 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate/state/@fraction = 1 
   /channelml/channel_type/hh_gate/@state = m 
   /channelml/channel_type/hh_gate/transition/voltage_gate/alpha/parameterised_hh/@type = exponential 
   /channelml/channel_type/hh_gate/transition/voltage_gate/alpha/parameterised_hh/@expr = A*exp(k*(v-d)) 
   /channelml/channel_type/hh_gate/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@value = 1 
   /channelml/channel_type/hh_gate/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@value = 0.055 
   /channelml/channel_type/hh_gate/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@value = -50 
   /channelml/channel_type/hh_gate/transition/voltage_gate/beta/parameterised_hh/@type = exponential 
   /channelml/channel_type/hh_gate/transition/voltage_gate/beta/parameterised_hh/@expr = A*exp(k*(v-d)) 
   /channelml/channel_type/hh_gate/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@value = 1 
   /channelml/channel_type/hh_gate/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@value = 0.0275 
   /channelml/channel_type/hh_gate/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@value = -50 
   /channelml/channel_type/hh_gate/transition/voltage_gate/tau/generic_equation_hh/@expr = beta/(0.0035 *( 1 +alpha)) 
   /channelml/channel_type/hh_gate/transition/voltage_gate/inf/parameterised_hh/@type = sigmoid 
   /channelml/channel_type/hh_gate/transition/voltage_gate/inf/parameterised_hh/@expr = A/(1 + exp(k*(v-d))) 
   /channelml/channel_type/hh_gate/transition/voltage_gate/inf/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate/transition/voltage_gate/inf/parameterised_hh/parameter[1]/@value = 1 
   /channelml/channel_type/hh_gate/transition/voltage_gate/inf/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate/transition/voltage_gate/inf/parameterised_hh/parameter[2]/@value = -0.1 
   /channelml/channel_type/hh_gate/transition/voltage_gate/inf/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate/transition/voltage_gate/inf/parameterised_hh/parameter[3]/@value = 21 
   /channelml/channel_type/impl_prefs/table_settings/@max_v = 100 
   /channelml/channel_type/impl_prefs/table_settings/@min_v = -100 
   /channelml/channel_type/impl_prefs/table_settings/@table_divisions = 400 

// File from which this was generated: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/Kdr_ChannelML/KChannel.xml

// XSL file with mapping to simulator: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/Kdr_ChannelML/ChannelML_v1.8.0_NEURONmod.xsl

ENDCOMMENT


?  This is a NEURON mod file generated from a ChannelML file

?  Unit system of original ChannelML file: Physiological Units

COMMENT
    ChannelML file containing a single Channel description
ENDCOMMENT

TITLE Channel: Kdr_ChannelML

COMMENT
    Mitral cell K DR channel
ENDCOMMENT


UNITS {
    (mA) = (milliamp)
    (mV) = (millivolt)
    (S) = (siemens)
    (um) = (micrometer)
    (molar) = (1/liter)
    (mM) = (millimolar)
    (l) = (liter)
}


    
NEURON {
      

    SUFFIX Kdr_ChannelML
    USEION k READ ek WRITE ik VALENCE 1 ? reversal potential of ion is read, outgoing current is written
            
    RANGE gmax, gion
    
    RANGE minf, mtau
}

PARAMETER { 
      

    gmax = 0.036 (S/cm2) ? default value, should be overwritten when conductance placed on cell
    
}



ASSIGNED {
      

    v (mV)
    
    celsius (degC)
    
    ? Reversal potential of k
    ek (mV)
    ? The outward flow of ion: k calculated by rate equations...
    ik (mA/cm2)
            
    
    gion (S/cm2)
    minf
    mtau (ms)
    
}

BREAKPOINT { 
                        
    SOLVE states METHOD cnexp
         

    gion = gmax*((1*m)^1)
    ik = gion*(v - ek)
                

}



INITIAL {
    ek = -77.0
        
    rates(v)
    m = minf
                
        
    
    
}
    
STATE {
    m
    
}

DERIVATIVE states {
    rates(v)
    m' = (minf - m)/mtau
    
}

PROCEDURE rates(v(mV)) {  
    
    ? Note: not all of these may be used, depending on the form of rate equations
    LOCAL  alpha, beta, tau, inf, gamma, zeta, temp_adj_m, A_alpha_m, k_alpha_m, d_alpha_m, A_beta_m, k_beta_m, d_beta_m, A_tau_m, k_tau_m, d_tau_m, A_inf_m, k_inf_m, d_inf_m
        
    TABLE minf, mtau
 DEPEND celsius
 FROM -100 TO 100 WITH 400
    
    
    UNITSOFF
    
    ? There is a Q10 factor which will alter the tau of the gates 
                 

    temp_adj_m = 3^((celsius - 24)/10)
        
    ?      ***  Adding rate equations for gate: m  ***
        
    ? Found a parameterised form of rate equation for alpha, using expression: A*exp(k*(v-d))
    A_alpha_m = 1
    k_alpha_m = 0.055
    d_alpha_m = -50
     
    
    alpha = A_alpha_m * exp((v - d_alpha_m) * k_alpha_m)
    
    
    ? Found a parameterised form of rate equation for beta, using expression: A*exp(k*(v-d))
    A_beta_m = 1
    k_beta_m = 0.0275
    d_beta_m = -50
     
    
    beta = A_beta_m * exp((v - d_beta_m) * k_beta_m)
    
         

    ? Found a generic form of the rate equation for tau, using expression: beta/(0.0035 *( 1 +alpha))
                    tau = beta/(0.0035 *( 1 +alpha))
        
    mtau = tau/temp_adj_m
    
    ? Found a parameterised form of rate equation for inf, using expression: A / (1 + exp(k*(v-d)))
    A_inf_m = 1
    k_inf_m = -0.1
    d_inf_m = 21
     
    
    inf = A_inf_m / (exp((v - d_inf_m) * k_inf_m) + 1)
    
    minf = inf
          
       
    
    ?     *** Finished rate equations for gate: m ***
    
             

}


UNITSON


