COMMENT

   **************************************************
   File generated by: neuroConstruct v1.3.8 
   **************************************************

   This file holds the implementation in NEURON of the Cell Mechanism:
   LCa3_mit_usb_ChannelML (Type: Channel mechanism, Model: ChannelML based process)

   with parameters: 
   /channelml/@units = SI Units 
   /channelml/notes = ChannelML file containing a single Channel description 
   /channelml/ion/@name = ca 
   /channelml/ion/@charge = 2 
   /channelml/ion/@default_erev = 0.070 
   /channelml/channel_type/@name = LCa3_mit_usb_ChannelML 
   /channelml/channel_type/@density = yes 
   /channelml/channel_type/status/@value = stable 
   /channelml/channel_type/status/comment = L channel data from: T. Hirano and S. Hagiwara Pflugers A 413(5) pp463-469, 1989 
   /channelml/channel_type/status/contributor/name = Simon O'Connor 
   /channelml/channel_type/notes = L type calcium conductance Hirano and Hagiwara 1989 
   /channelml/channel_type/authorList/modelTranslator/name = Simon O'Connor 
   /channelml/channel_type/authorList/modelTranslator/institution = University of Cardiff 
   /channelml/channel_type/authorList/modelTranslator/email = simon.oconnor@btinternet.com 
   /channelml/channel_type/publication/fullTitle = U. S. Bhalla and J. M. Bower, Exploring parameter space in detailed single neuron models: simulations of the mitral and granule cells of the olfactory ... 
   /channelml/channel_type/publication/pubmedRef = http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?cmd=Retrieve&amp;db=pubmed&amp;dopt=Abstract&amp;list_uids=7688798 
   /channelml/channel_type/neuronDBref/modelName = Na channels 
   /channelml/channel_type/neuronDBref/uri = http://senselab.med.yale.edu/senselab/NeuronDB/channelGene2.htm#table2 
   /channelml/channel_type/current_voltage_relation/ohmic/@ion = ca 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/@default_gmax = 120 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[1]/@power = 1 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[1]/state/@name = m 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[1]/state/@fraction = 1 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[2]/@power = 1 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[2]/state/@name = h 
   /channelml/channel_type/current_voltage_relation/ohmic/conductance/gate[2]/state/@fraction = 1 
   /channelml/channel_type/hh_gate[1]/@state = m 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/@type = sigmoid 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/@expr = A/(1 + exp(k*(v-d))) 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@value = 7500 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@value = -142.85714285714286 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@value = 0.013 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/@type = sigmoid 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/@expr = A/(1 + exp(k*(v-d))) 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@value = 1650 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@value = 250 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[1]/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@value = 0.014 
   /channelml/channel_type/hh_gate[2]/@state = h 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/@type = sigmoid 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/@expr = A/(1 + exp(k*(v-d))) 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[1]/@value = 6.800 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[2]/@value = 83.333333333333 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/alpha/parameterised_hh/parameter[3]/@value = -0.030 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/@type = sigmoid 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/@expr = A/(1 + exp(k*(v-d))) 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@name = A 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[1]/@value = 60 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@name = k 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[2]/@value = -90.90909090909 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@name = d 
   /channelml/channel_type/hh_gate[2]/transition/voltage_gate/beta/parameterised_hh/parameter[3]/@value = 0.0 
   /channelml/channel_type/impl_prefs/table_settings/@max_v = 0.05 
   /channelml/channel_type/impl_prefs/table_settings/@min_v = -0.1 
   /channelml/channel_type/impl_prefs/table_settings/@table_divisions = 3000 

// File from which this was generated: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/LCa3_mit_usb_ChannelML/CaChannel.xml

// XSL file with mapping to simulator: /home/Simon/nC_projects/Rat_Mitral_Cell_Gap_Network_copy4/cellMechanisms/LCa3_mit_usb_ChannelML/ChannelML_v1.8.0_NEURONmod.xsl

ENDCOMMENT


?  This is a NEURON mod file generated from a ChannelML file

?  Unit system of original ChannelML file: SI Units

COMMENT
    ChannelML file containing a single Channel description
ENDCOMMENT

TITLE Channel: LCa3_mit_usb_ChannelML

COMMENT
    L type calcium conductance Hirano and Hagiwara 1989
ENDCOMMENT


UNITS {
    (mA) = (milliamp)
    (mV) = (millivolt)
    (S) = (siemens)
    (um) = (micrometer)
    (molar) = (1/liter)
    (mM) = (millimolar)
    (l) = (liter)
}


    
NEURON {
      

    SUFFIX LCa3_mit_usb_ChannelML
    USEION ca READ eca WRITE ica VALENCE 2 ? reversal potential of ion is read, outgoing current is written
            
    RANGE gmax, gion
    
    RANGE minf, mtau
    RANGE hinf, htau
}

PARAMETER { 
      

    gmax = 0.012 (S/cm2) ? default value, should be overwritten when conductance placed on cell
    
}



ASSIGNED {
      

    v (mV)
    
    celsius (degC)
    
    ? Reversal potential of ca
    eca (mV)
    ? The outward flow of ion: ca calculated by rate equations...
    ica (mA/cm2)
            
    
    gion (S/cm2)
    minf
    mtau (ms)
    hinf
    htau (ms)
    
}

BREAKPOINT { 
                        
    SOLVE states METHOD cnexp
         

    gion = gmax*((1*m)^1)*((1*h)^1)
    ica = gion*(v - eca)
                

}



INITIAL {
    eca = 70
        
    rates(v)
    m = minf
                
        
    h = hinf
                
        
    
    
}
    
STATE {
    m
    h
    
}

DERIVATIVE states {
    rates(v)
    m' = (minf - m)/mtau
    h' = (hinf - h)/htau
    
}

PROCEDURE rates(v(mV)) {  
    
    ? Note: not all of these may be used, depending on the form of rate equations
    LOCAL  alpha, beta, tau, inf, gamma, zeta, temp_adj_m, A_alpha_m, k_alpha_m, d_alpha_m, A_beta_m, k_beta_m, d_beta_m, temp_adj_h, A_alpha_h, k_alpha_h, d_alpha_h, A_beta_h, k_beta_h, d_beta_h
        
    TABLE minf, mtau,hinf, htau
 DEPEND celsius
 FROM -100 TO 50 WITH 3000
    
    
    UNITSOFF
    temp_adj_m = 1
    temp_adj_h = 1
    
        
    ?      ***  Adding rate equations for gate: m  ***
        
    ? Found a parameterised form of rate equation for alpha, using expression: A / (1 + exp(k*(v-d)))
    A_alpha_m = 7500
    k_alpha_m = -142.85714285714286
    d_alpha_m = 0.013
    
    ? Unit system in ChannelML file is SI units, therefore need to 
    ? convert these to NEURON quanities...
                        A_alpha_m = A_alpha_m * 0.0010   ? 1/ms
    k_alpha_m = k_alpha_m * 0.0010   ? mV
    d_alpha_m = d_alpha_m * 1000   ? mV
          
                     
    
    alpha = A_alpha_m / (exp((v - d_alpha_m) * k_alpha_m) + 1)
    
    
    ? Found a parameterised form of rate equation for beta, using expression: A / (1 + exp(k*(v-d)))
    A_beta_m = 1650
    k_beta_m = 250
    d_beta_m = 0.014
    
    ? Unit system in ChannelML file is SI units, therefore need to 
    ? convert these to NEURON quanities...
                        A_beta_m = A_beta_m * 0.0010   ? 1/ms
    k_beta_m = k_beta_m * 0.0010   ? mV
    d_beta_m = d_beta_m * 1000   ? mV
          
                     
    
    beta = A_beta_m / (exp((v - d_beta_m) * k_beta_m) + 1)
    
    mtau = 1/(temp_adj_m*(alpha + beta))
    minf = alpha/(alpha + beta)
          
       
    
    ?     *** Finished rate equations for gate: m ***
    
        
        
    ?      ***  Adding rate equations for gate: h  ***
        
    ? Found a parameterised form of rate equation for alpha, using expression: A / (1 + exp(k*(v-d)))
    A_alpha_h = 6.800
    k_alpha_h = 83.333333333333
    d_alpha_h = -0.030
    
    ? Unit system in ChannelML file is SI units, therefore need to 
    ? convert these to NEURON quanities...
                        A_alpha_h = A_alpha_h * 0.0010   ? 1/ms
    k_alpha_h = k_alpha_h * 0.0010   ? mV
    d_alpha_h = d_alpha_h * 1000   ? mV
          
                     
    
    alpha = A_alpha_h / (exp((v - d_alpha_h) * k_alpha_h) + 1)
    
    
    ? Found a parameterised form of rate equation for beta, using expression: A / (1 + exp(k*(v-d)))
    A_beta_h = 60
    k_beta_h = -90.90909090909
    d_beta_h = 0.0
    
    ? Unit system in ChannelML file is SI units, therefore need to 
    ? convert these to NEURON quanities...
                        A_beta_h = A_beta_h * 0.0010   ? 1/ms
    k_beta_h = k_beta_h * 0.0010   ? mV
    d_beta_h = d_beta_h * 1000   ? mV
          
                     
    
    beta = A_beta_h / (exp((v - d_beta_h) * k_beta_h) + 1)
    
    htau = 1/(temp_adj_h*(alpha + beta))
    hinf = alpha/(alpha + beta)
          
       
    
    ?     *** Finished rate equations for gate: h ***
    
             

}


UNITSON


