#!/usr/bin/env python
# -*- coding: utf-8 -*-

import os
import sys
import math
import pickle

from pylab import *

sys.path.extend(["..","../networks","../generators","../simulations"])
from simset_inhibition import * # has REALRUNTIME
from stimuliConstants import * # has SETTLETIME
from data_utils import *

SETTLETIME = 500e-3 # s, increased as per inhibition_recvslat.py
RUNTIME = REALRUNTIME + SETTLETIME

## data_recvslat.pickle is generated by inhibition_recvslat.py
## USAGE: python2.6 plot_inhibition_recvslat.py data_recvslat.pickle

if __name__ == "__main__":

    mit_responses = pickle.load( open( sys.argv[1], "rb" ) )

    timevec = arange(0.0,RUNTIME+1e-10,SIMDT)*1e3
    tmin,tmax = 400,1200 # ms
    Vrest = -65 # mV
    Vmin,Vmax = -80,40 # mV
    fig = figure(figsize=(columnwidth*1.5,linfig_height*1.5),dpi=300,facecolor='w')

    ## mitral A
    ax1 = fig.add_subplot(2,2,1)
    ax1.plot((tmin,tmax),(Vrest,Vrest),linestyle='dashed',linewidth=plot_linewidth,color=(0.5,0.5,0.5))
    ax1.plot(timevec,mit_responses[1][0]*1e3,color='r',linewidth=plot_linewidth,label='Lateral')
    beautify_plot(ax1,x0min=False,y0min=False,xticksposn='none',yticksposn='left')
    ax1.set_xlim(tmin,tmax)
    ax1.set_ylim(Vmin,Vmax)
    ax1.set_yticks([Vmin,Vmax])
    axes_labels(ax1,'','Vm (mV)',ypad=-2)
    ax2 = fig.add_subplot(2,2,3)
    ax2.plot((tmin,tmax),(Vrest,Vrest),linestyle='dashed',linewidth=plot_linewidth,color=(0.5,0.5,0.5))
    ax2.plot(timevec,mit_responses[0][0]*1e3,color='r',linewidth=plot_linewidth,label='Recurrent')
    beautify_plot(ax2,x0min=False,y0min=False,xticksposn='bottom',yticksposn='left')
    ax2.set_xlim(tmin,tmax)
    ax2.set_xticks([tmin,800,tmax])
    ax2.set_ylim(Vmin,Vmax)
    ax2.set_yticks([Vmin,Vmax])
    axes_labels(ax2,'time (ms)','Vm (mV)',xpad=2,ypad=-2)

    ## inset plot
    from mpl_toolkits.axes_grid.inset_locator import mark_inset
    ## add_axes() takes figure coordinates,
    ## just passing transform=ax.transAxes as an argument to add_axes() does nothing.
    ## So you need to do some complicated jugglery
    ## (from http://matplotlib.1069221.n5.nabble.com/Adding-custom-axes-within-a-subplot-td20316.html)
    Bbox = matplotlib.transforms.Bbox.from_bounds(.75, .6, .5, .5) 
    trans = ax1.transAxes + fig.transFigure.inverted() 
    l, b, w, h = matplotlib.transforms.TransformedBbox(Bbox,trans).bounds
    axinset = fig.add_axes([l, b, w, h])
    axinset.plot(timevec,mit_responses[1][0]*1e3,color='r',linewidth=plot_linewidth,label='Lateral')
    ## thin frame
    for loc, spine in axinset.spines.items(): # items() returns [(key,value),...]
        spine.set_linewidth(axes_linewidth)
    axinset.set_xlim(910,975)
    axinset.set_ylim(-71.5,-70)
    axinset.set_xticks([])
    axinset.set_yticks([])
    mark_inset(ax1, axinset, loc1=2, loc2=4, fc="none", ec="0.5", linewidth=axes_linewidth)
    
    ## mitral B
    ax1 = fig.add_subplot(2,2,2)
    ax1.plot((tmin,tmax),(Vrest,Vrest),linestyle='dashed',linewidth=plot_linewidth,color=(0.5,0.5,0.5))
    ax1.plot(timevec,mit_responses[1][1]*1e3,color='g',linewidth=plot_linewidth,label='Lateral')
    beautify_plot(ax1,x0min=False,y0min=False,xticksposn='none',yticksposn='none')
    ax1.set_xlim(tmin,tmax)
    ax1.set_ylim(Vmin,Vmax)
    ax1.set_yticks([])
    axes_labels(ax1,'','')
    ax2 = fig.add_subplot(2,2,4)
    ax2.plot((tmin,tmax),(Vrest,Vrest),linestyle='dashed',linewidth=plot_linewidth,color=(0.5,0.5,0.5))
    ax2.plot(timevec,mit_responses[0][1]*1e3,color='g',linewidth=plot_linewidth,label='Recurrent')
    beautify_plot(ax2,x0min=False,y0min=False,xticksposn='bottom',yticksposn='none')
    ax2.set_xlim(tmin,tmax)
    ax2.set_xticks([tmin,800,tmax])
    ax2.set_ylim(Vmin,Vmax)
    ax2.set_yticks([])
    axes_labels(ax2,'time (ms)','',xpad=2)

    #fig.tight_layout()
    fig.subplots_adjust(top=0.95,left=0.1,right=0.97, wspace=0.25,hspace=0.25)
    #fig_clip_off(fig)
    fig.savefig('../figures/recvslat.svg',dpi=fig.dpi)
    fig.savefig('../figures/recvslat.png',dpi=fig.dpi)

    show()

