clear all

addpath 'Skuld_2_2' 'Urd_v1_2' 'VerdandiLite_v1_1'

global Network

disp('Preparing simulations')
tic 

% --- Time integration ---

Network.dt = 0.1; % Integration step (in ms)
Network.nStep = 10000; % Number of time steps

Network.OutputVm = 1; % 1=Output membrane potentials to Vm.txt, 0=no such output
Network.OutputSp = 1; % 1=Output spike times to Spikes.txt, 0=no such output

fInit = fopen('Inits.txt','w');
fprintf(fInit,'%u\t%g\n%u\t%u',Network.nStep,Network.dt,Network.OutputVm,Network.OutputSp);
fclose(fInit);


% A simple model in which 50 Izhikevich neurons receive a partial common
% input from 5 poisson neurons

% --- Populations ---
AddPopulation(...
    'Name','Cells',...
    'nCell', 100, ...
    'Type','Izhikevich',... 
    'I',0,...
    'a','Normal',[0.05 0.01],...
    'b',0.25,...
    'c',-50,...
    'd',8,...
    'V','Normal', [-65 5],...
    'w',0,...
    'Position',rand(100,3));

AddPopulation(...
    'Name','Inputs',...
    'nCell', 25, ...
    'Type','Poisson',... 
    'Lambda',50,...
    'Position',rand(25,3));

% --- Connections ---    
AddConnectivity(...
    'From','Inputs',...
    'To','Cells',...
    'Type','Exponential',...
    'Tau',4,'E',0,'g',0.02,...
    'Connections','Generate','Probability',0.5, 'Weight', @(r) 1+rand(size(r)), ...
    'Delay','Function',@(r) r+1);
  
AddConnectivity(...
    'From','Cells',...
    'To','Cells',...
    'Type','Exponential',...
    'Tau',4,'E',0,'g',0.02,...
    'Connections','Generate','Probability',0.05, 'Weight', @(r) 0.1+0.1*rand(size(r)), ...
    'Delay','Function',@(r) r+1);


WriteCells;
WriteConnectivity;

toc
disp('Running simulations')
tic 


if(ismac)
    system('VerdandiLite_v1_1/VerdandiLite_OSX');
elseif(ispc)
    system('VerdandiLite_v1_1\VerdandiLite_WIN32.exe');
else
    error('No binaries available for VerdandiLite. Please compile C++ source files and add modify these Matlab lines.')
end


toc

SkuldOut
Skuld('SkuldSet.mat')