COMMENT

   **************************************************
   File generated by: neuroConstruct v1.5.1 
   **************************************************

   This file holds the implementation in NEURON of the Cell Mechanism:
   H_CA1pyr_prox (Type: Channel mechanism, Model: ChannelML based process)

   with parameters: 
   /channelml/@units = SI Units 
   /channelml/notes = ChannelML file containing a single Channel description 
   /channelml/channel_type/@name = H_CA1pyr_prox 
   /channelml/channel_type/status/@value = stable 
   /channelml/channel_type/status/comment = Equations adapted from Kali 
   /channelml/channel_type/status/contributor/name = Szoke Boglarka 
   /channelml/channel_type/notes = Hiperpolarization activated channel in CA1 pyramid cell 
   /channelml/channel_type/authorList/modelTranslator/name = Szoke Boglarka 
   /channelml/channel_type/authorList/modelTranslator/institution = PPKE-ITK 
   /channelml/channel_type/authorList/modelTranslator/email = szoboce - at - digitus.itk.ppke.hu 
   /channelml/channel_type/current_voltage_relation/@cond_law = ohmic 
   /channelml/channel_type/current_voltage_relation/@default_gmax = 0.35 
   /channelml/channel_type/current_voltage_relation/@default_erev = -0.030 
   /channelml/channel_type/current_voltage_relation/gate/@name = X 
   /channelml/channel_type/current_voltage_relation/gate/@instances = 1 
   /channelml/channel_type/current_voltage_relation/gate/closed_state/@id = X0 
   /channelml/channel_type/current_voltage_relation/gate/open_state/@id = X 
   /channelml/channel_type/current_voltage_relation/gate/time_course/@name = tau 
   /channelml/channel_type/current_voltage_relation/gate/time_course/@from = X0 
   /channelml/channel_type/current_voltage_relation/gate/time_course/@to = X 
   /channelml/channel_type/current_voltage_relation/gate/time_course/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate/time_course/@expr =  (exp (33.0 * (v + 0.075))) / (11.0 * (1 + (exp (83.0* (v + 0.075))))) 
   /channelml/channel_type/current_voltage_relation/gate/steady_state/@name = inf 
   /channelml/channel_type/current_voltage_relation/gate/steady_state/@from = X0 
   /channelml/channel_type/current_voltage_relation/gate/steady_state/@to = X 
   /channelml/channel_type/current_voltage_relation/gate/steady_state/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate/steady_state/@expr =  1 / (1 + (exp (300*(v + 0.083)))) 
   /channelml/channel_type/impl_prefs/table_settings/@max_v = 0.05 
   /channelml/channel_type/impl_prefs/table_settings/@min_v = -0.1 
   /channelml/channel_type/impl_prefs/table_settings/@table_divisions = 3000 

// File from which this was generated: /home/kali/nC_projects/CA1_NEURON/cellMechanisms/H_CA1pyr_prox/H_CA1pyr_prox.xml

// XSL file with mapping to simulator: /home/kali/nC_projects/CA1_NEURON/cellMechanisms/H_CA1pyr_prox/ChannelML_v1.8.1_NEURONmod.xsl

ENDCOMMENT


?  This is a NEURON mod file generated from a ChannelML file

?  Unit system of original ChannelML file: SI Units

COMMENT
    ChannelML file containing a single Channel description
ENDCOMMENT

TITLE Channel: H_2comp_rate

COMMENT
    Hiperpolarization activated channel in CA1 pyramid cell
ENDCOMMENT


UNITS {
    (mA) = (milliamp)
    (mV) = (millivolt)
    (S) = (siemens)
    (um) = (micrometer)
    (molar) = (1/liter)
    (mM) = (millimolar)
    (l) = (liter)
}


    
NEURON {
      

    SUFFIX H_2comp_rate_shift
    RANGE e
    NONSPECIFIC_CURRENT i

    RANGE gmax, gion, fastRate, shift
    
    RANGE Xinf, Xtau1, Xtau2
    
}

PARAMETER { 
      

    gmax = 0.000035 (S/cm2)  ? default value, should be overwritten when conductance placed on cell
    e = -30 (mV) ? default value, should be overwritten when conductance placed on cell
    fastRate = 0.6 ()
    shift = 0
}



ASSIGNED {
      

    v (mV)

    i (mA/cm2)
    
    celsius (degC)
    
    
    gion (S/cm2)
    Xinf
    Xtau1 (ms)
    Xtau2 (ms)
    
}

BREAKPOINT { 
                        
    SOLVE states METHOD cnexp
         

    gion = fastRate*gmax*((X1)^1 ) + (1-fastRate)*gmax*((X2)^1 )
    i = gion*(v - e)

}



INITIAL {
    
    rates(v)
    X1 = Xinf
    X2 = Xinf
        
    
}
    
STATE {
    X1
    X2
    
}

DERIVATIVE states {
    rates(v)
    X1' = (Xinf - X1)/Xtau1
    X2' = (Xinf - X2)/Xtau2
    
}

PROCEDURE rates(v(mV)) {  
    
    ? Note: not all of these may be used, depending on the form of rate equations
    LOCAL  alpha, beta, tau1, tau2, inf, gamma, zeta, temp_adj_X, A_tau_X, B_tau_X, Vhalf_tau_X, A_inf_X, B_inf_X, Vhalf_inf_X
        
    TABLE Xinf, Xtau1, Xtau2
 DEPEND celsius, shift
 FROM -100 TO 50 WITH 3000
    
    
    UNITSOFF
    temp_adj_X = 1
    
            
                
           

        
    ?      ***  Adding rate equations for gate: X  ***
         
    ? Found a generic form of the rate equation for tau, using expression:  (exp (33.0 * (v + 0.075))) / (11.0 * (1 + (exp (83.0* (v + 0.075)))))
    
    ? Note: Equation (and all ChannelML file values) in SI Units so need to convert v first...
    
    v = v * 0.0010   ? temporarily set v to units of equation...
    shift = shift* 0.0010
            
    ? tau = 1 / ( (3.259 * (exp (0.1617 * (v + 0.0977) / 0.0089))) + (3.259 * (exp ((0.1617 - 1)  * (v + 0.0977) / 0.0089)))) + 0.05621
    tau1 = 1 / ( (11.93 * (exp (0.6056 * (v + 0.0977+shift) / 0.0089))) + (11.93 * (exp ((0.6056 - 1)  * (v + 0.0977+shift) / 0.0089))))
    tau2 = 1 / ( (1.839 * (exp (0.2069 * (v + 0.0977+shift) / 0.0089))) + (1.839 * (exp ((0.2069 - 1)  * (v + 0.0977+shift) / 0.0089)))) +0.09549
      
    ? Set correct units of tau for NEURON
    tau1 = tau1 * 1000 
    tau2 = tau2 * 1000 
    v = v * 1000   ? reset v
    shift = shift * 1000
        
    Xtau1 = tau1/temp_adj_X
    Xtau2 = tau2/temp_adj_X
     
    ? Found a generic form of the rate equation for inf, using expression:  1 / (1 + (exp (300*(v + 0.083))))
    
    ? Note: Equation (and all ChannelML file values) in SI Units so need to convert v first...
    
    v = v * 0.0010   ? temporarily set v to units of equation...
    shift = shift * 0.0010
            
    inf =  1 / (1 + (exp ((v + 0.0977+shift)/0.0089)))
         
    
    v = v * 1000   ? reset v
    shift = shift *1000
        
    Xinf = inf
          
       
    
    ?     *** Finished rate equations for gate: X ***
    

         

}


UNITSON


