COMMENT

   **************************************************
   File generated by: neuroConstruct v1.7.1 
   **************************************************

   This file holds the implementation in NEURON of the Cell Mechanism:
   BK_IAMC_ChannelML (Type: Channel mechanism, Model: ChannelML based process)

   with parameters: 
   /channelml/@units = SI Units 
   /channelml/notes = A channel from Maex, R and De Schutter, E. Synchronization of Golgi and Granule Cell Firing in a     Detailed Network Model of the Cerebellar Granule  ... 
   /channelml/channel_type/@name = BK_IAMC_ChannelML 
   /channelml/channel_type/status/@value = stable 
   /channelml/channel_type/status/issue = This ChannelML file is intended ONLY to replicate the original GENESIS functionality. A new Granule cell model is being developed based on 	  D'Angelo ... 
   /channelml/channel_type/status/contributor/name = Padraig Gleeson 
   /channelml/channel_type/notes = Calcium dependent K+ channel 
   /channelml/channel_type/authorList/modelAuthor[1]/name = Maex, R. 
   /channelml/channel_type/authorList/modelAuthor[2]/name = De Schutter, E. 
   /channelml/channel_type/authorList/modelTranslator/name = Padraig Gleeson 
   /channelml/channel_type/authorList/modelTranslator/institution = UCL 
   /channelml/channel_type/authorList/modelTranslator/email = p.gleeson - at - ucl.ac.uk 
   /channelml/channel_type/publication/fullTitle = Maex, R and De Schutter, E. 	Synchronization of Golgi and Granule Cell Firing in a Detailed Network Model of the 	cerebellar Granule Cell Layer. J Neu ... 
   /channelml/channel_type/publication/pubmedRef = http://www.ncbi.nlm.nih.gov/pubmed/9819260 
   /channelml/channel_type/neuronDBref/modelName = K channels 
   /channelml/channel_type/neuronDBref/uri = http://senselab.med.yale.edu/senselab/NeuronDB/channelGene2.htm#table3 
   /channelml/channel_type/current_voltage_relation/@cond_law = ohmic 
   /channelml/channel_type/current_voltage_relation/@ion = k 
   /channelml/channel_type/current_voltage_relation/@default_gmax = 0.15 
   /channelml/channel_type/current_voltage_relation/@default_erev = -0.0865 
   /channelml/channel_type/current_voltage_relation/conc_dependence/@name = Calcium 
   /channelml/channel_type/current_voltage_relation/conc_dependence/@ion = ca 
   /channelml/channel_type/current_voltage_relation/conc_dependence/@charge = 2 
   /channelml/channel_type/current_voltage_relation/conc_dependence/@variable_name = ca_conc 
   /channelml/channel_type/current_voltage_relation/conc_dependence/@min_conc = 7.55e-7 
   /channelml/channel_type/current_voltage_relation/conc_dependence/@max_conc = 0.050 
   /channelml/channel_type/current_voltage_relation/q10_settings/@q10_factor = 3 
   /channelml/channel_type/current_voltage_relation/q10_settings/@experimental_temp = 17.350264793 
   /channelml/channel_type/current_voltage_relation/offset/@value = 0.010 
   /channelml/channel_type/current_voltage_relation/gate[1]/@name = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/@instances = 1 
   /channelml/channel_type/current_voltage_relation/gate[1]/closed_state/@id = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/open_state/@id = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@name = alpha 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@from = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@to = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[1]/@expr = 2500/(1 + ( (1.5e-3 *(exp (-85*v))) / ca_conc)) 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@name = beta 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@from = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@to = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[1]/transition[2]/@expr = 1500/(1 + (ca_conc / (1.5e-4 * (exp (-77*v))))) 
   /channelml/channel_type/current_voltage_relation/gate[2]/@name = n 
   /channelml/channel_type/current_voltage_relation/gate[2]/@instances = 1 
   /channelml/channel_type/current_voltage_relation/gate[2]/closed_state/@id = n0 
   /channelml/channel_type/current_voltage_relation/gate[2]/open_state/@id = n 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@name = tau 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@from = n0 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@to = n 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@expr = 0.005 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@name = inf 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@from = n0 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@to = n 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@expr = 1 

// File from which this was generated: /home/Simon/NML2_Test/AOB_MC_neuroConstruct/cellMechanisms/BK_IAMC_ChannelML/KCa_chan.xml

// XSL file with mapping to simulator: /home/Simon/NML2_Test/AOB_MC_neuroConstruct/cellMechanisms/BK_IAMC_ChannelML/ChannelML_v1.8.1_NEURONmod.xsl

ENDCOMMENT


?  This is a NEURON mod file generated from a ChannelML file

?  Unit system of original ChannelML file: SI Units

COMMENT
    A channel from Maex, R and De Schutter, E. Synchronization of Golgi and Granule Cell Firing in a
    Detailed Network Model of the Cerebellar Granule Cell Layer
ENDCOMMENT

TITLE Channel: BK_IAMC_ChannelML

COMMENT
    Calcium dependent K+ channel
ENDCOMMENT


UNITS {
    (mA) = (milliamp)
    (mV) = (millivolt)
    (S) = (siemens)
    (um) = (micrometer)
    (molar) = (1/liter)
    (mM) = (millimolar)
    (l) = (liter)
}


    
NEURON {
      

    SUFFIX BK_IAMC_ChannelML
    USEION k READ ek WRITE ik VALENCE 1  ? reversal potential of ion is read, outgoing current is written
           
        
    USEION ca READ cai VALENCE 2 ? internal concentration of ion is read

    
    RANGE gmax, gion
    
    RANGE minf, mtau
    
    RANGE ninf, ntau
    
}

PARAMETER { 
      

    gmax = 0.000014999999999999999 (S/cm2)  ? default value, should be overwritten when conductance placed on cell
    
}



ASSIGNED {
      

    v (mV)
    
    celsius (degC)
          

    ? Reversal potential of k
    ek (mV)
    ? The outward flow of ion: k calculated by rate equations...
    ik (mA/cm2)
          

    ? The internal concentration of ion: ca is used in the rate equations...
    cai (mM)   
    
    
    gion (S/cm2)
    minf
    mtau (ms)
    ninf
    ntau (ms)
    
}

BREAKPOINT { 
    SOLVE states METHOD derivimplicit
    gion = gmax * (m
^1) * (n
^1)      

    ik = gion*(v - ek)
            

}



INITIAL {
    
    ek = -86.5
        
    settables(v,cai)
    m = minf
        n = ninf
        
    
}
    
STATE {
    m
    n
    
}



DERIVATIVE states {
    settables(v,cai)
    m' = (minf - m)/mtau
            n' = (ninf - n)/ntau
            

}

PROCEDURE settables(v(mV), cai(mM)) {  
    
    ? Note: not all of these may be used, depending on the form of rate equations
    LOCAL  alpha, beta, tau, inf, gamma, zeta, ca_conc
, temp_adj_m
, temp_adj_n
    
    UNITSOFF
    
    ? There is a Q10 factor which will alter the tau of the gates 
                 

    temp_adj_m = 3^((celsius - 17.350264793)/10)     

    temp_adj_n = 3^((celsius - 17.350264793)/10)
    
    ? There is a voltage offset of 0.010. This will shift the dependency of the rate equations 
    v = v - (10)
    
    ? Gate depends on the concentration of ca
    ca_conc = cai ? In NEURON, the variable for the concentration  of ca is cai
    
            
                
           

        
    ?      ***  Adding rate equations for gate: m  ***
         
    ? Found a generic form of the rate equation for alpha, using expression: 2500/(1 + ( (1.5e-3 *(exp (-85*v))) / ca_conc))
    
    ? Note: Equation (and all ChannelML file values) in SI Units so need to convert v first...
    
    v = v * 0.001   ? temporarily set v to units of equation...
            
    alpha = 2500/(1 + ( (1.5e-3 *(exp (-85*v))) / ca_conc))
        
    ? Set correct units of alpha for NEURON
    alpha = alpha * 0.001 
    
    v = v * 1000   ? reset v
        
     
    ? Found a generic form of the rate equation for beta, using expression: 1500/(1 + (ca_conc / (1.5e-4 * (exp (-77*v)))))
    
    ? Note: Equation (and all ChannelML file values) in SI Units so need to convert v first...
    
    v = v * 0.001   ? temporarily set v to units of equation...
            
    beta = 1500/(1 + (ca_conc / (1.5e-4 * (exp (-77*v)))))
        
    ? Set correct units of beta for NEURON
    beta = beta * 0.001 
    
    v = v * 1000   ? reset v
        
    mtau = 1/(temp_adj_m*(alpha + beta))
    minf = alpha/(alpha + beta)
    


    ?     *** Finished rate equations for gate: m ***
    

    
            
                
           

        
    ?      ***  Adding rate equations for gate: n  ***
         
    ? Found a generic form of the rate equation for tau, using expression: 0.005
    
    ? Note: Equation (and all ChannelML file values) in SI Units so need to convert v first...
    
    v = v * 0.001   ? temporarily set v to units of equation...
            
    tau = 0.005
        
    ? Set correct units of tau for NEURON
    tau = tau * 1000 
    
    v = v * 1000   ? reset v
        
    ntau = tau/temp_adj_n
     
    ? Found a generic form of the rate equation for inf, using expression: 1
    
    ? Note: Equation (and all ChannelML file values) in SI Units so need to convert v first...
    
    v = v * 0.001   ? temporarily set v to units of equation...
            
    inf = 1
         
    
    v = v * 1000   ? reset v
        
    ninf = inf
    


    ?     *** Finished rate equations for gate: n ***
    

         

}


UNITSON


