COMMENT

   **************************************************
   File generated by: neuroConstruct v1.7.1 
   **************************************************

   This file holds the implementation in NEURON of the Cell Mechanism:
   KA_iAMC_ChannelML (Type: Channel mechanism, Model: ChannelML based process)

   with parameters: 
   /channelml/@units = Physiological Units 
   /channelml/notes = AOB A Type Potassium Ion Channel 
   /channelml/channel_type/@name = KA_iAMC_ChannelML 
   /channelml/channel_type/status/@value = stable 
   /channelml/channel_type/status/comment = A Type Potassium Ion Channel from an intrinsically oscillating AOB mitral cell from parameters recorded in the lab of M. Spehr RWTH Aachen 
   /channelml/channel_type/status/contributor/name = Simon O'Connor 
   /channelml/channel_type/notes = A-type K channel, with rate equations expressed in tau and inf form 
   /channelml/channel_type/authorList/modelTranslator/name = Simon O'Connor 
   /channelml/channel_type/authorList/modelTranslator/institution = UH 
   /channelml/channel_type/authorList/modelTranslator/email = simon.oconnor - at - btinternet.com 
   /channelml/channel_type/neuronDBref/modelName = K channels 
   /channelml/channel_type/neuronDBref/uri = http://senselab.med.yale.edu/neurondb/channelGene2.aspx#table3 
   /channelml/channel_type/current_voltage_relation/@cond_law = ohmic 
   /channelml/channel_type/current_voltage_relation/@ion = k 
   /channelml/channel_type/current_voltage_relation/@default_gmax = 4 
   /channelml/channel_type/current_voltage_relation/@default_erev = -86.5 
   /channelml/channel_type/current_voltage_relation/gate[1]/@name = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/@instances = 1 
   /channelml/channel_type/current_voltage_relation/gate[1]/closed_state/@id = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/open_state/@id = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/time_course/@name = tau 
   /channelml/channel_type/current_voltage_relation/gate[1]/time_course/@from = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/time_course/@to = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/time_course/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[1]/time_course/@expr = (1+4*exp(-((v-32)/50)^2)) 
   /channelml/channel_type/current_voltage_relation/gate[1]/steady_state/@name = inf 
   /channelml/channel_type/current_voltage_relation/gate[1]/steady_state/@from = m0 
   /channelml/channel_type/current_voltage_relation/gate[1]/steady_state/@to = m 
   /channelml/channel_type/current_voltage_relation/gate[1]/steady_state/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[1]/steady_state/@expr = v &lt; -50 ? 0 : 1 / (1 + exp(0 - (v + 25.7)/4.4)) 
   /channelml/channel_type/current_voltage_relation/gate[2]/@name = h 
   /channelml/channel_type/current_voltage_relation/gate[2]/@instances = 1 
   /channelml/channel_type/current_voltage_relation/gate[2]/closed_state/@id = h0 
   /channelml/channel_type/current_voltage_relation/gate[2]/open_state/@id = h 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@name = tau 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@from = h0 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@to = h 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@expr_form = generic 
   /channelml/channel_type/current_voltage_relation/gate[2]/time_course/@expr = (1+100*exp(-((v-10)/40)^2)) 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@name = inf 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@from = h0 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@to = h 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@expr_form = sigmoid 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@rate = 1 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@scale = 4.4 
   /channelml/channel_type/current_voltage_relation/gate[2]/steady_state/@midpoint = -25 

// File from which this was generated: /home/Simon/NML2_Test/AOB_MC_neuroConstruct/cellMechanisms/KA_iAMC_ChannelML/KA_chan.xml

// XSL file with mapping to simulator: /home/Simon/NML2_Test/AOB_MC_neuroConstruct/cellMechanisms/KA_iAMC_ChannelML/ChannelML_v1.8.1_NEURONmod.xsl

ENDCOMMENT


?  This is a NEURON mod file generated from a ChannelML file

?  Unit system of original ChannelML file: Physiological Units

COMMENT
    AOB A Type Potassium Ion Channel
ENDCOMMENT

TITLE Channel: KA_iAMC_ChannelML

COMMENT
    A-type K channel, with rate equations expressed in tau and inf form
ENDCOMMENT


UNITS {
    (mA) = (milliamp)
    (mV) = (millivolt)
    (S) = (siemens)
    (um) = (micrometer)
    (molar) = (1/liter)
    (mM) = (millimolar)
    (l) = (liter)
}


    
NEURON {
      

    SUFFIX KA_iAMC_ChannelML
    USEION k READ ek WRITE ik VALENCE 1  ? reversal potential of ion is read, outgoing current is written
           
        
    RANGE gmax, gion
    
    RANGE minf, mtau
    
    RANGE hinf, htau
    
}

PARAMETER { 
      

    gmax = 0.004 (S/cm2)  ? default value, should be overwritten when conductance placed on cell
    
}



ASSIGNED {
      

    v (mV)
    
    celsius (degC)
          

    ? Reversal potential of k
    ek (mV)
    ? The outward flow of ion: k calculated by rate equations...
    ik (mA/cm2)
    
    
    gion (S/cm2)
    minf
    mtau (ms)
    hinf
    htau (ms)
    
}

BREAKPOINT { 
                        
    SOLVE states METHOD cnexp
        
    gion = gmax * (m
^1) * (h
^1)      

    ik = gion*(v - ek)
            

}



INITIAL {
    
    ek = -86.5
        
    rates(v)
    m = minf
        h = hinf
        
    
}
    
STATE {
    m
    h
    
}



DERIVATIVE states {
    rates(v)
    m' = (minf - m)/mtau
            h' = (hinf - h)/htau
            

}

PROCEDURE rates(v(mV)) {  
    
    ? Note: not all of these may be used, depending on the form of rate equations
    LOCAL  alpha, beta, tau, inf, gamma, zeta
, temp_adj_m
, temp_adj_h,
         A_inf_h, B_inf_h, Vhalf_inf_h
    
    TABLE minf, mtau,hinf, htau
 DEPEND celsius FROM -100 TO 100 WITH 400
    
    UNITSOFF
    temp_adj_m = 1
    temp_adj_h = 1
    
            
                
           

        
    ?      ***  Adding rate equations for gate: m  ***
         
    ? Found a generic form of the rate equation for tau, using expression: (1+4*exp(-((v-32)/50)^2))
    tau = (1+4*exp(-((v-32)/50)^2))
        
    mtau = tau/temp_adj_m
     
    ? Found a generic form of the rate equation for inf, using expression: v < -50 ? 0 : 1 / (1 + exp(0 - (v + 25.7)/4.4))
    
    
    if (v < -50 ) {
        inf =  0 
    } else {
        inf =  1 / (1 + exp(0 - (v + 25.7)/4.4))
    }
    minf = inf
    


    ?     *** Finished rate equations for gate: m ***
    

    
            
                
           

        
    ?      ***  Adding rate equations for gate: h  ***
         
    ? Found a generic form of the rate equation for tau, using expression: (1+100*exp(-((v-10)/40)^2))
    tau = (1+100*exp(-((v-10)/40)^2))
        
    htau = tau/temp_adj_h
    
    ? Found a parameterised form of rate equation for inf, using expression: A / (1 + exp((v-Vhalf)/B))
    A_inf_h = 1
    B_inf_h = 4.4
    Vhalf_inf_h = -25 
    inf = A_inf_h / (exp((v - Vhalf_inf_h) / B_inf_h) + 1)
    
    hinf = inf
    


    ?     *** Finished rate equations for gate: h ***
    

         

}


UNITSON


