// Morphology file for Purkinje cell
// (c) Erik De Schutter, Caltech 1991-1992
// Original data provided by Rapp, Yarom and Segev, Hebrew University Jerusalem
// Active membrane model with 1 spine on every spiny compartment
// References: Rapp, M., Segev, I., and Yarom, Y. (1994) Physiology,
//   morphology and detailed passive models of cerebellar Purkinje cells.
//   J.  Physiol. (London), 471: 87-99.
//             De Schutter, E. and Bower, J. M. (1994) An active membrane
//   model of the cerebellar Purkinje cell: I. Simulation of current
//   clamps in slice. J. Neurophysiol., 71: 375-400.
//   http://www.tnb.ua.ac.be/TNB/TNB_pub8.html
//             De Schutter, E. and Bower, J. M. (1994) An active membrane
//   model of the cerebellar Purkinje cell: II. Simulation of synaptic
//   responses. J. Neurophysiol., 71: 401-419.
//   http://www.tnb.ua.ac.be/TNB/TNB_pub7.html

*relative

*set_compt_param RM	{RMs}
*set_compt_param RA	{RA}
*set_compt_param CM	{CM}
*set_compt_param ELEAK {ELEAK}	
*set_compt_param EREST_ACT {EREST_ACT}
*compt /library/Purk_soma
soma		none		0.000	0.000	0.000	29.80

*set_compt_param RM	{RMd}
// add one spine per compartment with dia <= 3.17 um and 
//  expand membrane for missing spines
*rand_spines 3.17 13 1.33 7.54 1.00 /library/Purk_spine

*compt /library/Purk_maind
main[0]		soma		5.557	9.447	9.447	7.72
main[1]		main[0]		8.426	1.124	21.909	8.22
main[2]		main[1]		1.666	1.111	6.666	8.50
main[3]		main[2]		-2.779	2.223	1.667	9.22
main[4]		main[3]		-1.111	6.109	5.553	8.89
main[5]		main[4]		-1.111	-0.555	4.998	8.44
main[6]		main[5]		-1.749	0.583	3.498	8.61
main[7]		main[6]		-3.890	3.334	6.669	7.78
main[8]		main[7]		-6.665	-1.111	9.441	8.44

*compt /library/Purk_thickd
br1[0]		main[8]		-4.443	1.111	0.000	7.94	
br1[1]		.			-4.440	-0.555	1.110	5.39	
br1[2]		.			-13.334	0.000	1.111	5.06	
br1[3]		.			-3.330	0.555	2.775	4.83	
br1[4]		.			-6.114	3.335	5.558	4.22	
br1[5]		.			-8.330	1.111	3.332	4.22	
br1[6]		.			-3.888	0.000	5.554	4.00	
br1[7]		.			-4.444	0.000	2.777	5.00	
br1[8]		.			-1.666	-2.777	5.555	6.06	
br1[9]		.			0.000	3.888	7.220	5.17	
br1[10]		.			-1.110	1.665	4.440	4.44	
br1[11]		.			-6.668	0.000	13.336	4.33	
br1[12]		.			-3.889	0.000	13.334	5.00	
br1[13]		.			1.113	1.113	3.338	5.78	
br1[14]		.			0.000	0.000	2.220	5.44	
br1[15]		.			-0.556	0.556	13.888	4.33	
br1[16]		.			0.555	-0.555	3.329	3.56	
br1[17]		.			2.222	-0.556	8.890	3.83	
br1[18]		.			-0.555	1.666	7.219	4.17	
br1[19]		.			-1.110	0.000	3.885	4.78	
br1[20]		.			-6.111	-1.667	1.667	4.17	

*compt /library/Purk_thickd
br2[0]		main[8]		6.665	7.776	8.887	8.06
br2[1]		.			2.222	0.556	5.556	5.78	
br2[2]		.			-1.109	0.000	1.664	5.28
br2[3]		.			1.667	0.000	2.778	5.39
br2[4]		.			-0.555	0.000	4.999	5.72
br2[5]		.			2.223	-1.112	6.114	5.72
br2[6]		.			2.779	2.223	11.114	6.17
br2[7]		.			10.554	-0.555	12.775	5.72
br2[8]		.			6.667	-0.556	11.668	5.17
br2[9]		.			13.330	2.777	9.442	4.78
br2[10]		.			7.775	0.555	8.886	4.17
br2[11]		.			2.777	0.000	4.444	4.17	
br2[12]		.			2.777	0.000	6.665	4.17	
br2[13]		.			3.332	0.000	11.663	4.00	
br2[14]		.			6.666	0.556	6.111	3.44	
br2[15]		.			7.222	0.000	10.556	4.44	
br2[16]		.			-0.556	0.000	6.667	5.28	
br2[17]		.			-5.554	0.000	8.887	4.44	
br2[18]		.			-4.444	0.000	7.222	4.78	
br2[19]		.			-6.665	0.555	1.111	5.39	
br2[20]		.			-2.781	-0.556	-0.556	4.83	
br2[21]		.			-2.868	-0.319	0.956	4.50	

*compt /library/Purk_thickd
br3[0]		br2[6]		-7.223	0.556	5.556	5.06	
br3[1]		.			-7.221	0.555	4.999	3.22	
br3[2]		.			-7.775	-0.555	4.998	4.56	
br3[3]		.			-1.111	-1.111	1.666	6.00	
br3[4]		.			0.000	0.555	5.552	6.17	
br3[5]		.			-2.775	-0.555	3.330	5.44	
br3[6]		.			-7.222	3.333	6.111	4.17	
br3[7]		.			-3.887	0.000	3.332	4.89	
br3[8]		.			0.000	-0.556	8.893	4.72	
br3[9]		.			-2.780	-0.556	5.559	4.44	
br3[10]		.			0.000	1.669	1.669	5.61	
br3[11]		.			-2.777	-1.666	9.998	4.78	
br3[12]		.			-1.111	1.111	9.440	5.44	
br3[13]		.			3.334	-2.222	5.556	5.22	
br3[14]		.			10.094	-0.561	11.776	3.44	
br3[15]		.			4.444	1.667	9.444	5.11	
br3[16]		.			3.891	2.779	2.779	6.06	

*compt /library/Purk_thickd
b0s01[0]	main[1]		6.110	0.555	-0.555	5.28
*compt /library/Purk_spinyd
b0s01[1]	b0s01[0]	2.220	0.000	0.000	2.28
b0s01[2]	.			3.892	-1.668	-3.336	1.83
b0s01[3]	.			1.151	0.000	-10.356	1.44
b0s01[4]	.			-1.667	0.000	-2.778	1.44
b0s01[5]	.			-2.432	0.000	-1.824	1.44
b0s01[6]	.			-9.438	1.180	0.590	1.44
b0s01[7]	b0s01[5]	0.907	0.907	-3.630	1.44
b0s01[8]	.			-2.778	0.000	-1.667	1.44
b0s01[9]	b0s01[7]	0.000	0.000	-4.050	1.44
b0s01[10]	.			-16.009	0.000	-9.606	1.44
b0s01[11]	b0s01[9]	0.000	-1.109	-1.664	1.28
b0s01[12]	.			-2.226	0.556	-1.113	1.11
b0s01[13]	.			-1.109	0.000	1.664	1.00
b0s01[14]	b0s01[12]	-3.336	0.556	-1.112	1.00
b0s01[15]	.			-0.555	0.000	-1.109	0.89	
b0s01[16]	.			-8.055	-1.151	-8.055	0.89
b0s01[17]	b0s01[15]	3.890	0.000	0.000	0.89
b0s01[18]	.			2.218	0.000	-1.109	0.94	
b0s01[19]	.			0.680	0.000	-4.762	1.00	
b0s01[20]	b0s01[11]	1.664	0.000	-1.109	1.06	
b0s01[21]	.			1.112	0.556	-3.336	1.11	
b0s01[22]	.			1.111	0.000	-8.336	1.22	
b0s01[23]	b0s01[4]	-1.664	0.000	1.109	1.33	
b0s01[24]	.			-3.334	0.000	0.556	1.22	
b0s01[25]	.			-2.780	0.000	0.000	1.06	
b0s01[26]	.			0.000	0.000	-1.670	0.83
b0s01[27]	.			-3.888	0.000	-1.666	0.78	
b0s01[28]	b0s01[25]	-2.220	0.000	0.000	0.83
b0s01[29]	.			-3.887	0.000	-3.332	0.83	
b0s01[30]	.			-2.777	0.000	-4.444	0.83	
b0s01[31]	b0s01[3]	1.109	0.000	-1.664	1.22	
b0s01[32]	.			6.271	0.000	-6.841	1.00
b0s01[33]	.			-6.155	-0.560	-22.382	1.00
b0s01[34]	b0s01[32]	4.443	-1.111	0.000	1.00
b0s01[35]	.			3.336	0.000	-1.668	1.11	
b0s01[36]	.			2.776	1.110	-2.776	1.28	
b0s01[37]	.			2.224	0.000	-3.337	1.50	
b0s01[38]	.			4.443	-0.555	-4.998	1.67	
b0s01[39]	b0s01[31]	2.778	0.000	-1.667	1.17
b0s01[40]	.			2.775	0.000	-0.555	1.33	
b0s01[41]	.			4.999	0.000	-2.222	1.22	
b0s01[42]	.			4.445	0.000	-0.556	1.06	
b0s01[43]	.			1.669	0.000	-1.669	1.00	
b0s01[44]	.			2.224	0.000	-2.780	1.22	

*compt /library/Purk_thickd
b0s02[0]	main[2]		9.998	-1.111	0.000	6.17
*compt /library/Purk_spinyd
b0s02[1]	b0s02[0]	6.664	-0.555	0.555	3.17	
b0s02[2]	.			0.556	0.556	-3.891	2.39
b0s02[3]	.			1.667	0.000	-2.778	1.89	
b0s02[4]	.			0.555	0.000	-5.552	1.78	
b0s02[5]	.			-0.555	0.555	-6.110	1.78
b0s02[6]	.			-2.220	0.000	-2.220	1.61
b0s02[7]	.			1.125	0.000	-6.189	1.44	
b0s02[8]	b0s02[5]	3.888	0.000	-1.666	1.61
b0s02[9]	.			3.888	0.000	-1.666	1.33	
b0s02[10]	.			4.711	0.000	-6.478	1.22	
b0s02[11]	b0s02[4]	2.224	0.000	1.668	1.44
b0s02[12]	.			12.475	0.000	-1.701	1.11	
b0s02[13]	.			3.886	-0.555	-2.221	1.06	
b0s02[14]	.			11.113	1.235	-12.965	1.00	
b0s02[15]	b0s02[1]	1.664	0.000	1.109	2.50
b0s02[16]	.			-1.110	2.221	1.666	1.89
b0s02[17]	.			2.223	0.000	4.445	1.56	
b0s02[18]	.			2.224	0.000	1.668	1.44	
b0s02[19]	b0s02[15]	0.554	0.554	0.554	2.11
b0s02[20]	.			2.222   -0.555  -2.777  1.67	
b0s02[21]	.			2.220   0.000   -2.220  1.33
b0s02[22]	.			1.669	1.113	-1.669	1.39	
b0s02[23]	.			0.000	0.555	-2.222	1.39
b0s02[24]	.			-2.246	0.000	-10.666	1.3
b0s02[25]	.			-4.445	0.000	-5.000	1.33
b0s02[26]	b0s02[24]	3.330	-0.555	-2.775	1.22
b0s02[27]	.			3.337	0.000	-2.224	1.11
b0s02[28]	b0s02[22]	2.222	-0.555	0.000	1.33
b0s02[29]	.			12.680	-0.576	-5.763	1.22
b0s02[30]	b0s02[19]	5.555	1.666	2.777	1.89
b0s02[31]	.			4.445	0.000	0.556	1.89
b0s02[32]	.			4.445	0.000	-0.556	2.00	
b0s02[33]	.			3.890	0.000	0.000	2.44	
b0s02[34]	.			2.780	0.000	-2.224	2.56	
b0s02[35]	.			3.334	0.000	-2.778	2.11	
b0s02[36]	.			3.330	-0.555	-2.220	2.28	
b0s02[37]	.			0.555	1.111	-6.665	2.06	
b0s02[38]	.			6.225	1.245	3.112	1.56	
b0s02[39]	.			-1.668	0.000	2.224	1.39	
b0s02[40]	b0s02[38]	1.670	0.000	-0.557	1.39	
b0s02[41]	.			3.334	0.556	0.000	1.22	
b0s02[42]	.			2.779	0.000	-2.779	1.22	
b0s02[43]	.			3.890	-1.667	-2.223	1.22	
b0s02[44]	.			8.353	1.671	3.341	1.22	
b0s02[45]	b0s02[43]	27.278	2.098	-9.093	1.22	
b0s02[46]	.			1.110	-1.110	-2.221	1.17	
b0s02[47]	.			-3.332	0.000	-3.887	1.06	
b0s02[48]	b0s02[46]	7.220	0.000	0.000	1.06	
b0s02[49]	b0s02[42]	0.000	0.000	-2.780	1.11	
b0s02[50]	.			2.332	1.166	-11.077	1.00	
b0s02[51]	.			-4.445	0.000	-2.223	1.00	
b0s02[52]	b0s02[50]	0.000	-4.444	-7.222	1.00	
b0s02[53]	.			-2.220	0.000	-2.220	1.17	
b0s02[54]	.			13.991	0.000	-7.276	1.33	
b0s02[55]	b0s02[53]	-2.220	-0.555	-3.330	1.33	
b0s02[56]	.			-1.664	0.000	-1.109	1.28	
b0s02[57]	b0s02[41]	2.224	0.000	1.668	1.22	
b0s02[58]	b0s02[37]	-0.556	0.000	-3.891	1.39	
b0s02[59]	.			4.445	0.000	-0.556	1.39	
b0s02[60]	.			9.003	0.000	-1.688	1.56	
b0s02[61]	.			3.885	0.000	-1.110	1.61	
b0s02[62]	.			6.110	0.000	0.000	1.44	
b0s02[63]	.			19.199	1.694	-6.776	1.22	
b0s02[64]	b0s02[62]	29.097	0.606	-5.456	1.22	
b0s02[65]	b0s02[58]	1.668	0.000	-4.448	1.39	
b0s02[66]	.			0.000	0.000	-2.220	1.67	
b0s02[67]	.			0.000	0.000	-8.890	1.78	
b0s02[68]	.			-5.000	0.000	-1.667	1.67	
b0s02[69]	.			-2.778	0.000	3.890	1.39	
b0s02[70]	.			-1.664	0.000	1.109	1.22	
b0s02[71]	.			-2.776	0.000	1.110	1.17	
b0s02[72]	.			-2.220	0.000	0.000	1.00	
b0s02[73]	b0s02[70]	-1.109	0.000	-1.664	1.06	
b0s02[74]	.			-5.839	0.000	2.595	0.89	
b0s02[75]	b0s02[68]	-2.220	-0.555	-3.330	1.44	
b0s02[76]	.			-2.224	0.000	-1.668	1.33	
b0s02[77]	b0s02[75]	1.666	-0.555	-1.666	1.33	
b0s02[78]	.			-2.779	-1.667	-6.114	1.33	
b0s02[79]	b0s02[77]	2.218	0.000	-1.109	1.33	
b0s02[80]	.			-3.332	0.000	-7.218	1.33	
b0s02[81]	b0s02[79]	1.109	0.000	-1.664	1.33	
b0s02[82]	b0s02[67]	2.224	-1.112	-3.335	2.00	
b0s02[83]	.			-4.445	0.556	-4.445	1.83	
b0s02[84]	.			2.221	0.000	-5.552	1.33	
b0s02[85]	b0s02[82]	3.886	0.555	-2.221	1.72	
b0s02[86]	.			6.110	0.000	0.000	1.22	
b0s02[87]	.			4.445	0.000	0.556	1.11	
b0s02[88]	.			9.180	0.000	0.000	1.00	
b0s02[89]	b0s02[66]	2.775	0.000	-0.555	1.67	
b0s02[90]	.			5.552	0.000	-4.442	2.33	
b0s02[91]	.			-0.555	-1.110	-3.887	2.39	
b0s02[92]	.			1.111	0.000	-4.443	1.67	
b0s02[93]	.			0.000	0.000	-2.220	1.78	
b0s02[94]	.			-2.778	0.000	-3.890	1.56	
b0s02[95]	.			-4.715	0.000	-7.072	1.22	
b0s02[96]	.			-3.334	0.000	-5.001	1.11	
b0s02[97]	b0s02[95]	3.333	0.000	-7.776	1.11	
b0s02[98]	b0s02[93]	1.668	0.000	-3.336	1.56	
b0s02[99]	.			3.337	0.000	-2.224	1.28	
b0s02[100]	.			3.331	-1.666	-1.666	1.17	
b0s02[101]	b0s02[90]	1.669	0.000	1.669	2.33	
b0s02[102]	.			9.440	0.000	0.000	1.56	
b0s02[103]	b0s02[36]	0.540	-0.540	2.159	2.06	
b0s02[104]	.			0.000	1.110	1.110	1.56	
b0s02[105]	.			11.148	0.000	-3.279	1.56	
b0s02[106]	b0s02[104]	7.776	1.666	1.111	1.72
b0s02[107]	.			24.430	1.163	-2.908	1.89	
b0s02[108]	.			6.115	0.000	-0.556	1.61	
b0s02[109]	b0s02[107]	2.778	1.667	4.445	1.61	
b0s02[110]	.			-1.110	-0.555	3.887	1.33	
b0s02[111]	b0s02[106]	5.553	2.221	2.221	1.61	
b0s02[112]	.			10.002	0.000	1.667	1.33	
b0s02[113]	.			3.337	0.000	-2.224	1.17	
b0s02[114]	.			3.336	-1.112	0.556	1.00	
b0s02[115]	b0s02[112]	1.668	0.000	2.224	1.17	
b0s02[116]	.			5.200	0.000	3.900	1.00	
b0s02[117]	b0s02[111]	5.003	-0.556	6.115	1.17	
b0s02[118]	b0s02[33]	0.000	0.000	2.780	2.33	
b0s02[119]	.			1.667	1.667	2.223	1.61	
b0s02[120]	.			8.533	-0.569	2.276	1.44	
b0s02[121]	.			4.445	0.000	-0.556	1.56	
b0s02[122]	.			4.998	0.000	-1.111	1.67	
b0s02[123]	.			7.218	1.666	1.110	1.61	
b0s02[124]	.			9.129	0.000	2.282	1.56	
b0s02[125]	.			3.888	1.666	2.777	1.39	
b0s02[126]	.			1.667	-0.556	6.112	1.17	
b0s02[127]	.			2.879	0.000	7.485	1.11	
b0s02[128]	b0s02[124]	7.225	0.000	-1.112	1.67	
b0s02[129]	.			2.778	0.556	4.444	1.72	
b0s02[130]	.			3.332	0.000	3.887	1.44	
b0s02[131]	.			3.891	0.000	0.556	1.11	
b0s02[132]	.			0.555	0.555	1.664	1.00	
b0s02[133]	b0s02[131]	2.218	0.000	-1.109	1.00	
b0s02[134]	.			0.555	0.555	-1.664	1.00	
b0s02[135]	b0s02[133]	5.552	0.000	2.221	0.94	
b0s02[136]	.			12.372	0.000	-5.302	0.89	
b0s02[137]	b0s02[128]	6.113	1.111	-3.890	1.94	
b0s02[138]	.			5.552	0.000	2.221	2.00	
b0s02[139]	.			1.668	0.556	3.335	1.67	
b0s02[140]	.			3.337	0.000	2.224	1.56	
b0s02[141]	.			0.000	0.555	2.775	1.50	
b0s02[142]	.			2.780	1.112	3.892	1.33	
b0s02[143]	.			3.330	0.000	0.000	1.22	
b0s02[144]	.			3.089	0.618	-5.560	1.11	
b0s02[145]	b0s02[140]	3.336	1.112	0.556	1.39	
b0s02[146]	.			3.330	0.555	2.220	1.11	
b0s02[147]	.			1.110	0.000	1.110	1.00	
b0s02[148]	b0s02[146]	6.110	-0.555	0.555	1.00	
b0s02[149]	b0s02[138]	3.334	1.111	-2.778	1.67	
b0s02[150]	.			11.242	0.562	0.562	1.44	
b0s02[151]	.			2.224	0.000	-3.337	1.28	
b0s02[152]	.			-1.668	0.000	-2.224	1.11	
b0s02[153]	b0s02[151]	4.445	0.556	-1.667	1.11	
b0s02[154]	.			2.776	0.000	-1.110	1.06	
b0s02[155]	.			4.448	0.000	1.668	1.00	
b0s02[156]	b0s02[150]	2.224	0.000	3.337	1.39	
b0s02[157]	.			1.666	-0.555	1.666	1.33	
b0s02[158]	.			-1.109	0.000	1.664	1.28	
b0s02[159]	b0s02[157]	6.112	-0.556	1.667	1.11	
b0s02[160]	b0s02[137]	0.000	0.555	-2.775	1.94	
b0s02[161]	.			2.781	0.000	-6.118	1.78	
b0s02[162]	.			0.000	0.000	-2.220	1.56	
b0s02[163]	.			-7.830	1.119	-6.152	1.33	
b0s02[164]	.			2.223	0.000	-3.890	1.33	
b0s02[165]	b0s02[163]	-5.560	0.000	0.000	1.17	
b0s02[166]	.			-2.780	0.000	-2.224	1.00	
b0s02[167]	b0s02[162]	1.667	0.000	-2.778	1.28	
b0s02[168]	.			-2.222	0.556	-5.556	1.11	
b0s02[169]	.			-2.777	0.555	-3.888	1.00	
b0s02[170]	.			-6.668	0.000	-1.111	0.94	
b0s02[171]	b0s02[169]	1.666	0.000	-3.888	0.94	
b0s02[172]	.			7.392	0.000	-1.848	0.89	
b0s02[173]	b0s02[161]	5.556	0.556	-2.222	1.78	
b0s02[174]	.			8.886	0.000	-3.332	2.06	
b0s02[175]	.			4.442	0.555	3.331	2.00	
b0s02[176]	.			3.335	1.668	-0.556	1.67	
b0s02[177]	.			2.776	0.000	-1.110	1.50	
b0s02[178]	b0s02[174]	2.221	0.555	-2.221	1.83	
b0s02[179]	.			1.668	0.000	-3.336	1.33	
b0s02[180]	.			0.000	0.000	-2.780	1.39	
b0s02[181]	.			-3.892	0.000	-4.448	1.28	
b0s02[182]	.			2.220	0.000	-2.220	1.11	
b0s02[183]	b0s02[181]	1.849	0.000	-22.183	1.11	
b0s02[184]	b0s02[180]	0.555	0.000	-2.775	1.28	
b0s02[185]	.			3.334	0.000	-5.557	1.06	

*compt /library/Purk_thickd
b0s03[0]	main[5]		-5.555	0.000	-1.667	5.94	
b0s03[1]	.			-6.669	0.000	-2.223	3.72	
b0s03[2]	.			0.000	0.000	-2.780	3.44	
*compt /library/Purk_spinyd
b0s03[3]	b0s03[2]	8.332	0.000	0.555	2.11	
b0s03[4]	b0s03[2]	-0.557	0.000	-1.670	2.11	
b0s03[5]	.			-3.334	0.000	0.556	1.56	
b0s03[6]	.			-2.778	0.000	-5.000	1.44	
b0s03[7]	b0s03[4]	0.555	0.000	-2.775	1.83	
b0s03[8]	.			-2.223	0.000	-4.445	2.17	
b0s03[9]	.			1.666	0.555	-6.663	2.11	
b0s03[10]	.			-1.666	0.000	-6.665	2.00	
b0s03[11]	.			-5.000	-2.222	-1.667	1.78	
b0s03[12]	.			-17.021	0.567	-16.453	1.44	
b0s03[13]	.			-4.997	-1.110	-2.221	1.50	
b0s03[14]	.			-1.665	-0.555	-2.220	1.39	
b0s03[15]	.			0.000	0.000	-5.000	1.44	
b0s03[16]	b0s03[13]	-4.998	0.000	1.111	1.50	
b0s03[17]	.			-5.000	0.000	0.000	1.44	
b0s03[18]	.			-8.890	0.000	0.000	1.28	
b0s03[19]	b0s03[10]	0.556	0.000	-3.334	1.89	
b0s03[20]	.			-2.222	-2.777	-6.110	1.67	
b0s03[21]	.			18.003	0.667	4.667	1.67	
b0s03[22]	.			3.336	0.000	-4.448	1.67	
b0s03[23]	b0s03[21]	2.224	0.000	1.668	1.44	
b0s03[24]	.			7.249	0.000	-0.558	1.22	
b0s03[25]	.			1.664	0.000	-1.109	1.11	
b0s03[26]	.			-1.203	0.602	-5.415	1.00	
b0s03[27]	b0s03[23]	2.224	0.000	1.668	1.11	
b0s03[28]	.			7.800	0.000	0.557	1.00	
b0s03[29]	b0s03[20]	-2.224	0.000	-2.780	1.22	
b0s03[30]	.			2.778	0.000	-1.667	0.78	
b0s03[31]	b0s03[29]	-1.109	0.000	-1.664	0.78	
b0s03[32]	.			-6.731	0.000	-12.116	0.78	
b0s03[33]	b0s03[31]	-2.220	0.555	-1.665	0.78	
b0s03[34]	.			-4.412	0.000	-5.042	0.78	
b0s03[35]	b0s03[33]	-11.185	0.000	-3.915	0.78	
b0s03[36]	.			0.000	0.000	-1.670	0.78	
b0s03[37]	b0s03[35]	-1.110	-0.555	0.555	0.78	
b0s03[38]	b0s03[8]	-7.219	0.000	-0.555	1.78	
b0s03[39]	.			-3.890	0.000	0.000	1.33	
b0s03[40]	.			-2.224	0.000	3.337	1.44	
b0s03[41]	.			-2.777	0.000	4.444	1.39	
b0s03[42]	.			2.778	0.000	1.667	1.17	
b0s03[43]	b0s03[39]	-3.887	0.000	-3.332	1.39	
b0s03[44]	.			-11.739	-1.174	-24.652	1.33	
b0s03[45]	.			2.950	0.000	-7.080	1.33	
b0s03[46]	.			2.780	0.556	-2.780	1.22	
b0s03[47]	.			0.678	-4.749	-4.749	1.11	
b0s03[48]	.			2.222	0.555	-2.777	1.11	
b0s03[49]	b0s03[47]	-1.668	0.000	-3.336	1.11	
b0s03[50]	b0s03[44]	-6.107	0.000	-1.666	1.22	
b0s03[51]	.			-12.934	0.000	-3.937	1.11	
b0s03[52]	b0s03[50]	-3.889	0.000	3.889	1.06	
b0s03[53]	.			-7.222	0.000	4.444	1.00	
b0s03[54]	b0s03[1]	-5.002	1.667	1.667	2.72	
b0s03[55]	.			-3.890	0.000	0.000	1.28	
b0s03[56]	.			-17.217	1.722	-5.739	1.44	
b0s03[57]	.			-0.574	-1.722	-11.477	1.44	
b0s03[58]	.			-4.448	0.000	-3.336	1.33	
b0s03[59]	.			-2.778	0.000	-1.667	1.11	
b0s03[60]	.			5.000	0.000	-2.778	1.00	
b0s03[61]	b0s03[59]	-7.220	0.000	-3.888	1.00	
b0s03[62]	.			-2.775	0.000	-0.555	1.00	
b0s03[63]	b0s03[61]	0.000	0.556	-8.893	1.00	
b0s03[64]	b0s03[57]	0.560	0.000	0.000	1.22	
b0s03[65]	b0s03[56]	-3.890	-1.667	2.223	1.22	
b0s03[66]	.			-2.221	0.000	6.109	1.06	
b0s03[67]	.			1.110	0.000	3.885	1.11	
b0s03[68]	b0s03[65]	-4.445	0.000	0.556	1.22	
b0s03[69]	.			-18.501	-0.578	0.000	1.44	

*compt /library/Purk_thickd
b0s04[0]	main[6]		5.000	2.222	1.667	5.72	
*compt /library/Purk_spinyd
b0s04[1]	b0s04[0]	-1.111	-1.111	7.221	2.50	
b0s04[2]	.			-0.555	0.555	6.110	2.00	
b0s04[3]	.			2.226	0.556	1.113	2.00	
b0s04[4]	.			3.334	0.000	0.556	1.67	
b0s04[5]	.			-1.110	0.000	2.776	1.33	
b0s04[6]	b0s04[4]	2.222	0.000	-0.555	1.33	
b0s04[7]	b0s04[2]	-1.109	0.000	1.664	1.67	
b0s04[8]	.			3.333	-1.111	3.888	1.33	
b0s04[9]	.			3.888	0.555	2.777	1.33	
b0s04[10]	b0s04[8]	-5.558	0.000	5.558	1.33	
b0s04[11]	.			-6.720	0.560	6.720	1.33	
b0s04[12]	b0s04[10]	10.136	0.000	5.702	1.33	
b0s04[13]	b0s04[7]	-15.599	1.733	-1.733	1.33	
b0s04[14]	.			-8.522	0.609	-1.217	1.33	
b0s04[15]	.			-16.190	-0.558	0.000	1.33	
b0s04[16]	.			-2.779	0.000	2.779	1.22	
b0s04[17]	b0s04[14]	-2.778	0.556	9.444	1.22	
b0s04[18]	.			-7.842	0.560	5.042	1.11	
b0s04[19]	.			-2.780	0.000	0.000	1.11	
b0s04[20]	b0s04[18]	-1.183	-1.775	10.648	1.11	
b0s04[21]	b0s04[13]	-2.777	0.000	5.554	1.22	
b0s04[22]	.			7.805	0.557	13.380	1.11	
b0s04[23]	.			2.221	0.000	6.109	1.00	
b0s04[24]	.			-10.687	0.000	14.695	0.89	
b0s04[25]	b0s04[22]	-2.779	0.000	2.779	1.00	
b0s04[26]	.			-1.676	0.000	6.146	0.89	
b0s04[27]	.			-4.999	0.000	2.222	1.06	
b0s04[28]	.			-10.006	0.667	19.345	1.22	
b0s04[29]	b0s04[26]	2.224	0.000	3.337	1.06	
b0s04[30]	b0s04[0]	3.891	-0.556	1.668	2.33	
b0s04[31]	.			4.443	-0.555	4.998	2.44	
b0s04[32]	.			-0.556	0.000	3.891	2.28	
b0s04[33]	.			0.000	0.000	5.560	1.33	
b0s04[34]	.			0.000	0.555	2.222	1.50	
b0s04[35]	.			-1.858	0.000	10.527	1.67	
b0s04[36]	.			0.000	0.000	3.330	1.56	
b0s04[37]	.			-3.872	0.000	4.518	1.44	
b0s04[38]	.			-1.667	0.000	2.778	1.22	
b0s04[39]	b0s04[36]	3.337	0.000	2.224	1.22	
b0s04[40]	.			2.283	0.571	13.699	1.00	
b0s04[41]	b0s04[34]	2.779	0.000	2.779	1.61	
b0s04[42]	.			6.667	1.111	4.445	1.33	
b0s04[43]	b0s04[31]	4.998	0.000	1.111	2.44	
b0s04[44]	.			2.778	0.000	-3.890	1.39	
b0s04[45]	.			3.890	0.000	-2.223	1.11	
b0s04[46]	.			1.110	0.000	-3.885	1.28	
b0s04[47]	.			-1.110	0.555	-2.775	1.44	
b0s04[48]	.			-1.275	-0.637	-21.673	1.44	
b0s04[49]	.			-1.701	0.000	-7.940	1.44	
b0s04[50]	.			-2.404	0.000	-5.410	1.44	
b0s04[51]	b0s04[49]	3.890	0.000	-2.223	1.39	
b0s04[52]	.			7.886	0.000	-3.380	1.33	
b0s04[53]	b0s04[48]	6.115	1.112	-0.556	1.39	
b0s04[54]	.			17.363	-3.858	3.858	1.33	
b0s04[55]	b0s04[53]	17.421	-2.323	-5.807	1.33	
b0s04[56]	b0s04[47]	1.113	0.557	1.113	1.39	
b0s04[57]	b0s04[46]	1.110	0.000	0.000	1.39	
b0s04[58]	b0s04[43]	3.332	-2.222	2.222	1.89	
b0s04[59]	.			0.000	2.224	1.668	1.89	
b0s04[60]	.			-1.111	-0.556	10.003	1.50	
b0s04[61]	b0s04[59]	4.443	0.555	3.888	1.50	
b0s04[62]	.			0.000	0.000	0.560	1.22	
b0s04[63]	b0s04[58]	2.222	0.000	-0.555	2.22	
b0s04[64]	.			-3.889	0.000	-10.000	1.78	
b0s04[65]	b0s04[63]	4.440	-1.110	-0.555	3.33	
b0s04[66]	.			1.110	0.000	-3.330	3.39	
b0s04[67]	.			0.000	0.555	-4.999	2.50	
b0s04[68]	.			-2.779	0.000	-2.779	2.11	
b0s04[69]	b0s04[67]	4.998	0.555	-4.443	2.44	
b0s04[70]	.			2.224	0.000	-1.668	1.89	
b0s04[71]	b0s04[69]	5.559	2.224	1.112	1.89	
b0s04[72]	.			0.000	0.000	3.330	1.33	
b0s04[73]	.			1.664	0.000	1.109	1.22	
b0s04[74]	b0s04[71]	4.445	0.000	-0.556	1.33	
b0s04[75]	.			2.218	0.000	1.109	1.06	
b0s04[76]	.			5.555	0.000	1.667	0.83	
b0s04[77]	b0s04[75]	6.109	0.000	6.664	1.11	
b0s04[78]	b0s04[65]	1.667	3.334	1.111	3.33	
b0s04[79]	.			3.336	-0.556	-1.112	1.89	
b0s04[80]	.			3.330	0.000	0.000	1.44	
b0s04[81]	.			15.919	0.000	-2.948	1.44	
b0s04[82]	b0s04[80]	18.408	1.227	1.841	1.44	
b0s04[83]	b0s04[78]	1.667	0.000	5.000	2.00	
b0s04[84]	.			11.480	2.870	7.462	1.67	
b0s04[85]	.			3.334	0.000	0.556	1.89	
b0s04[86]	.			-1.111	-0.555	6.665	1.78	
b0s04[87]	.			0.000	0.000	8.480	1.44	
b0s04[88]	.			2.777	0.000	4.444	1.28	
b0s04[89]	b0s04[85]	3.888	0.000	-1.666	1.78	
b0s04[90]	.			4.440	0.000	0.000	1.78	
b0s04[91]	.			2.224	0.000	-2.780	2.11	
b0s04[92]	.			2.224	0.000	-2.780	1.78	
b0s04[93]	.			2.222	-0.556	-4.444	1.44	
b0s04[94]	.			0.555	0.000	-2.222	1.56	
b0s04[95]	.			-1.112	0.000	-5.560	1.72	
b0s04[96]	.			-2.778	0.000	-5.000	1.67	
b0s04[97]	.			-2.775	0.555	-3.330	1.33	
b0s04[98]	.			-1.670	0.000	-0.557	1.06	
b0s04[99]	b0s04[97]	0.556	0.000	-3.334	1.06	
b0s04[100]	b0s04[94]	6.665	0.555	-1.111	1.33	
b0s04[101]	.			3.336	0.000	-1.668	1.00	
b0s04[102]	.			4.998	0.000	6.664	1.00	
b0s04[103]	b0s04[101]	0.555	0.000	-2.222	1.00	
b0s04[104]	.			1.110	0.000	-3.330	1.11	
b0s04[105]	.			-1.667	0.000	-5.000	1.00	
b0s04[106]	.			0.000	0.000	-2.780	0.83	
b0s04[107]	.			0.556	0.000	-6.667	0.89	
b0s04[108]	b0s04[106]	-13.673	0.000	-7.406	0.89	
b0s04[109]	b0s04[91]	8.332	0.000	-0.555	1.56	
b0s04[110]	.			18.315	0.572	-1.145	1.00	
b0s04[111]	.			3.330	-2.775	-2.220	1.11	
b0s04[112]	.			5.002	1.111	6.669	1.17	
b0s04[113]	b0s04[111]	3.886	0.555	-2.221	1.17	
b0s04[114]	.			26.429	2.349	0.587	1.11	
b0s04[115]	.			2.780	0.000	0.000	1.00	
b0s04[116]	b0s04[109]	2.224	0.000	2.780	0.94	
b0s04[117]	.			8.374	0.000	1.675	0.89	
b0s04[118]	.			0.000	-0.557	1.670	0.89	
b0s04[119]	b0s04[117]	2.218	0.000	-1.109	0.89	
b0s04[120]	b0s04[90]	1.110	0.555	4.440	1.61	
b0s04[121]	.			2.780	0.000	2.224	1.22	
b0s04[122]	.			-1.112	-0.556	3.336	1.22	
b0s04[123]	.			-0.575	1.150	18.405	1.11	
b0s04[124]	b0s04[122]	5.603	1.121	15.127	1.11	
b0s04[125]	b0s04[121]	6.110	0.000	1.111	1.28	
b0s04[126]	.			3.334	0.000	0.556	1.61	
b0s04[127]	.			1.668	0.556	5.559	1.67	
b0s04[128]	.			7.782	0.000	7.226	1.33	
b0s04[129]	.			2.220	0.555	3.330	1.50	
b0s04[130]	.			3.334	0.000	0.556	1.50	
b0s04[131]	.			13.278	0.577	2.886	1.33	
b0s04[132]	.			3.334	0.000	0.556	1.28	
b0s04[133]	.			3.890	0.000	2.778	1.17	
b0s04[134]	.			15.197	0.563	6.754	1.11	
b0s04[135]	b0s04[129]	-0.555	0.000	1.109	1.50	
b0s04[136]	.			-7.224	-0.556	-4.445	1.22	
b0s04[137]	b0s04[135]	-0.627	0.000	9.409	1.33	
b0s04[138]	.			-1.110	-0.555	2.775	1.28	
b0s04[139]	.			-2.780	0.000	2.224	1.22	
b0s04[140]	b0s04[126]	5.555	-2.777	-1.666	1.94	
b0s04[141]	.			12.236	0.556	-8.899	1.89	
b0s04[142]	.			2.220	0.555	-1.665	1.56	
b0s04[143]	b0s04[141]	9.444	0.000	1.667	1.56	
b0s04[144]	.			21.421	4.632	3.474	1.22	
b0s04[145]	b0s04[140]	6.668	3.890	-0.556	1.83	
b0s04[146]	.			9.444	0.000	-6.666	1.78	
b0s04[147]	.			2.778	0.000	-3.334	1.61	
b0s04[148]	.			14.259	0.000	-4.753	1.44	
b0s04[149]	b0s04[145]	3.889	0.000	3.889	1.44	
b0s04[150]	.			5.000	0.556	1.667	1.11	
b0s04[151]	.			6.115	-0.556	1.112	1.17	
b0s04[152]	.			3.330	0.000	3.330	1.22	
b0s04[153]	.			3.334	-0.556	0.000	1.11	
b0s04[154]	.			1.664	0.000	-1.109	1.00	
b0s04[155]	b0s04[153]	3.335	0.556	1.668	1.00	

*compt /library/Purk_thickd
b1s05[0]	br1[0]		-1.667	0.000	-5.000	4.17	
*compt /library/Purk_spinyd
b1s05[1]	b1s05[0]	-11.749	0.000	-8.951	2.22	
b1s05[2]	.			-2.223	0.000	-3.890	2.22	
b1s05[3]	.			-3.336	0.000	-4.448	2.00	
b1s05[4]	b1s05[1]	-7.774	0.000	-1.666	2.06	
b1s05[5]	.			-7.221	0.555	-3.888	1.72	
b1s05[6]	b1s05[4]	-5.000	0.000	2.778	1.67	

*compt /library/Purk_thickd
b1s06[0]	br1[2]		-4.448	0.000	-3.336	3.83	
b1s06[1]	.			-3.334	0.000	-0.556	3.11	
b1s06[2]	.			-1.668	0.000	-4.448	4.00	
*compt /library/Purk_spinyd
b1s06[3]	b1s06[2]	0.555	0.000	-2.775	3.11	
b1s06[4]	.			0.000	-1.110	-2.776	2.22	
b1s06[5]	.			-1.109	0.000	-2.218	2.11	
b1s06[6]	.			0.000	0.000	-3.330	1.83	
b1s06[7]	.			4.752	0.000	-4.752	1.67	
b1s06[8]	.			3.336	0.000	1.668	1.50	
b1s06[9]	b1s06[2]	-3.338	1.113	-1.113	3.06	
b1s06[10]	.			-3.888	0.000	-1.666	2.33	
b1s06[11]	.			-4.445	0.000	-2.223	3.00	
b1s06[12]	.			2.779	0.000	-2.779	2.44	
b1s06[13]	.			3.334	0.000	-2.778	1.44	
b1s06[14]	.			5.552	0.000	2.221	1.22	
b1s06[15]	b1s06[13]	2.780	0.000	-2.224	1.33	
b1s06[16]	.			2.220	0.000	-2.220	1.17	
b1s06[17]	b1s06[11]	-1.664	1.109	0.000	3.39	
b1s06[18]	.			-1.109	0.000	-2.218	2.83	
b1s06[19]	.			1.110	0.000	-3.330	1.89	
b1s06[20]	.			0.000	-1.120	-5.599	1.44	
b1s06[21]	.			-3.633	1.211	-12.716	1.44	
b1s06[22]	.			3.891	0.000	0.556	1.33	
b1s06[23]	.			6.669	0.000	2.223	1.22	
b1s06[24]	.			7.220	0.000	1.666	1.11	
b1s06[25]	b1s06[23]	6.665	-0.555	-4.999	1.11	
b1s06[26]	b1s06[21]	-0.556	0.556	-3.891	1.39	
b1s06[27]	.			0.000	-1.109	-1.664	1.22	
b1s06[28]	.			4.445	0.556	0.000	1.11	
b1s06[29]	.			4.998	0.000	1.111	1.00	
b1s06[30]	.			6.670	0.000	0.000	0.89	
b1s06[31]	b1s06[27]	-2.778	0.000	-5.000	1.00	
b1s06[32]	.			-2.257	-0.564	-6.771	0.89	
b1s06[33]	.			5.000	0.000	-2.778	0.89	
b1s06[34]	b1s06[32]	-1.670	0.000	-0.557	0.89	
b1s06[35]	.			-17.342	-1.196	-13.156	0.89	
b1s06[36]	b1s06[34]	-3.890	-1.112	-7.781	1.00	
b1s06[37]	.			9.460	-1.183	-11.825	1.11	
b1s06[38]	b1s06[36]	-7.458	0.000	-8.031	1.11	
b1s06[39]	b1s06[20]	-1.110	0.000	-3.330	1.28	
b1s06[40]	.			-3.336	0.000	-4.448	1.11	
b1s06[41]	.			2.778	0.000	-5.000	1.11	
b1s06[42]	b1s06[40]	-2.225	0.000	-5.562	1.11	
b1s06[43]	.			-17.535	0.000	-8.485	1.11	
b1s06[44]	b1s06[42]	-1.110	0.000	-3.330	1.28	
b1s06[45]	.			-6.762	0.000	-9.016	1.44	
b1s06[46]	.			-8.893	-0.556	0.000	1.44	
b1s06[47]	.			-5.555	0.555	-0.555	1.39	
b1s06[48]	b1s06[46]	0.000	0.556	-3.334	1.39	
b1s06[49]	b1s06[45]	0.000	0.000	-1.670	1.39	
b1s06[50]	.			-7.840	0.000	-4.480	1.33	
b1s06[51]	.			-4.440	-0.555	1.110	1.22	
b1s06[52]	.			-4.440	0.555	-1.110	1.11	
b1s06[53]	b1s06[50]	-3.888	1.111	-3.333	1.22	
b1s06[54]	.			-12.887	-0.586	-7.615	1.11	
b1s06[55]	b1s06[18]	-5.554	0.000	-3.888	2.00	
b1s06[56]	.			-4.448	0.000	-3.336	1.72	
b1s06[57]	.			-1.667	0.000	-2.778	1.61	
b1s06[58]	.			-1.110	0.000	-3.885	1.61	
b1s06[59]	.			3.887	0.000	-3.332	1.67	
b1s06[60]	.			1.110	0.000	-3.330	1.44	
b1s06[61]	.			-2.222	0.556	-5.000	1.28	
b1s06[62]	.			-1.666	0.000	-3.888	1.22	
b1s06[63]	.			-2.778	0.000	-3.334	1.06	
b1s06[64]	b1s06[58]	-5.556	1.111	-2.778	1.44	
b1s06[65]	.			-12.284	-1.117	-8.376	1.11	
b1s06[66]	.			-2.780	0.000	-2.224	1.11	
b1s06[67]	.			-2.224	0.000	-3.337	1.06	
b1s06[68]	.			-2.954	0.000	-7.089	1.00	
b1s06[69]	.			-2.220	0.000	-2.220	0.94	
b1s06[70]	.			-1.110	0.000	-1.110	0.89	
b1s06[71]	b1s06[69]	1.110	1.110	-2.221	0.89	
b1s06[72]	b1s06[65]	0.556	0.000	-3.334	1.00	
b1s06[73]	.			2.617	0.654	-3.271	0.89	
b1s06[74]	.			5.028	-0.559	-2.234	0.89	
b1s06[75]	b1s06[73]	-1.666	1.666	-4.444	1.17	
b1s06[76]	.			-2.222	-1.666	-4.444	1.39	
b1s06[77]	.			-3.890	0.000	-2.223	1.39	
b1s06[78]	.			-4.997	0.000	-3.886	1.28	
b1s06[79]	.			-1.158	0.000	-5.213	1.11	
b1s06[80]	b1s06[76]	0.556	0.000	-3.891	1.22	
b1s06[81]	.			-2.833	0.000	-8.500	1.11	
b1s06[82]	b1s06[72]	-1.110	0.000	-2.776	1.00	
b1s06[83]	b1s06[56]	-6.666	1.666	-1.666	1.44	
b1s06[84]	.			-4.445	0.556	-1.667	1.11	
b1s06[85]	.			-11.896	-0.595	-12.491	1.11	
b1s06[86]	b1s06[84]	-5.000	0.000	0.000	1.11	
b1s06[87]	.			-5.000	0.556	-1.667	1.17	
b1s06[88]	.			-3.885	-1.110	-1.665	1.44	
b1s06[89]	.			-3.332	0.000	-3.887	1.56	
b1s06[90]	.			0.000	0.000	-5.000	1.28	
b1s06[91]	.			17.277	0.000	-10.942	1.11	
b1s06[92]	b1s06[89]	-5.560	0.000	0.000	1.28	
b1s06[93]	.			-7.419	-1.141	-5.707	1.11	
b1s06[94]	.			-1.110	0.000	-3.330	1.06	
b1s06[95]	.			-0.603	0.000	-21.101	1.00	
b1s06[96]	b1s06[88]	-3.888	0.000	1.666	1.39	
b1s06[97]	.			-8.335	0.000	1.667	1.11	
b1s06[98]	.			-3.333	0.000	7.776	1.22	
b1s06[99]	b1s06[97]	-3.337	0.000	-2.224	1.22	
b1s06[100]	.			-6.668	-0.556	3.890	1.28	
b1s06[101]	.			-8.329	0.000	2.776	1.17	
b1s06[102]	b1s06[99]	-2.220	0.000	-2.220	1.28	
b1s06[103]	.			3.330	0.000	-3.330	1.22	
b1s06[104]	.			-19.763	-2.044	9.541	1.22	
b1s06[105]	b1s06[103]	1.199	0.000	-9.595	1.22	
b1s06[106]	b1s06[102]	-5.560	0.000	0.000	1.22	
b1s06[107]	b1s06[17]	-6.665	2.777	1.666	2.39	
b1s06[108]	.			-6.109	0.000	-2.221	1.44	
b1s06[109]	.			-6.115	-0.556	-2.223	1.56	
b1s06[110]	.			-3.330	0.000	-3.330	1.50	
b1s06[111]	.			-11.840	0.000	-3.947	1.33	
b1s06[112]	.			6.325	0.632	7.590	1.33	
b1s06[113]	b1s06[111]	-3.330	0.000	-1.110	1.33	
b1s06[114]	.			-3.336	0.000	1.668	1.17	
b1s06[115]	.			-2.779	0.000	2.779	1.00	
b1s06[116]	b1s06[114]	-6.667	0.000	0.556	0.89	
b1s06[117]	.			-5.000	0.556	-1.667	0.78	
b1s06[118]	b1s06[109]	-4.998	0.000	1.111	1.33	
b1s06[119]	.			-14.662	0.000	4.511	1.00	
b1s06[120]	.			-1.110	0.000	1.110	1.00	
b1s06[121]	b1s06[119]	-8.623	0.000	1.990	1.00	
b1s06[122]	b1s06[1]	-2.781	0.556	1.668	2.89	
b1s06[123]	.			-3.891	0.000	0.556	1.89	
b1s06[124]	.			-10.557	1.111	0.556	2.11	
b1s06[125]	.			2.221	0.555	3.886	2.22	
b1s06[126]	.			0.000	0.000	1.670	2.11	
b1s06[127]	.			0.000	0.000	6.110	1.83	
b1s06[128]	.			-7.547	0.629	3.145	1.67	
b1s06[129]	b1s06[124]	-1.668	1.112	-0.556	2.61	
b1s06[130]	.			-1.667	0.000	-5.000	2.72	
b1s06[131]	.			-1.109	0.000	-1.664	2.17	
b1s06[132]	.			-4.445	0.000	0.556	1.78	
b1s06[133]	.			-6.114	0.000	5.003	1.50	
b1s06[134]	b1s06[131]	-0.556	-1.113	-2.226	1.61	
b1s06[135]	b1s06[129]	-4.443	-1.111	0.000	2.50	
b1s06[136]	.			-1.111	0.000	4.998	1.78	
b1s06[137]	b1s06[135]	-3.891	1.668	-0.556	2.33	
b1s06[138]	.			-4.443	0.000	-6.665	2.61	
b1s06[139]	.			-1.666	0.000	-3.888	2.56	
b1s06[140]	.			-0.555	0.000	-2.775	2.11	
b1s06[141]	.			-1.110	0.000	-3.885	1.56	
b1s06[142]	b1s06[139]	-3.330	0.000	0.000	1.89	
b1s06[143]	.			-6.669	0.000	-2.223	1.22	
b1s06[144]	.			-5.555	0.555	0.555	1.11	
b1s06[145]	b1s06[143]	-2.781	0.556	-1.668	1.11	
b1s06[146]	b1s06[137]	-4.997	1.110	-2.221	2.11	
b1s06[147]	.			-3.885	0.000	-1.110	1.50	
b1s06[148]	.			-3.885	0.000	-1.110	1.44	
b1s06[149]	.			-5.560	0.000	-1.112	1.50	
b1s06[150]	.			-1.667	0.000	-2.778	1.50	
b1s06[151]	.			-5.745	0.000	-6.319	1.44	
b1s06[152]	.			1.110	0.000	-3.330	1.33	
b1s06[153]	.			12.437	-0.592	-21.321	1.22	
b1s06[154]	b1s06[151]	-4.440	-0.555	-1.110	1.28	
b1s06[155]	.			-4.999	0.000	0.555	1.11	
b1s06[156]	.			-4.443	0.000	1.111	1.17	
b1s06[157]	.			-7.387	-0.568	-2.273	1.22	
b1s06[158]	.			-2.222	0.000	0.555	1.17	
b1s06[159]	.			-2.776	1.110	-6.107	1.00	
b1s06[160]	b1s06[158]	-2.780	0.000	0.000	1.17	
b1s06[161]	.			-2.218	0.000	-1.109	1.11	
b1s06[162]	.			1.109	0.000	-1.664	1.00	
b1s06[163]	b1s06[149]	-4.999	0.000	-0.555	1.33	
b1s06[164]	.			-1.113	0.556	-2.226	1.06	
b1s06[165]	b1s06[163]	-3.890	0.000	0.000	1.06	
b1s06[166]	.			-1.110	0.000	0.000	1.00	
b1s06[167]	.			-11.971	0.000	-3.420	1.00	
b1s06[168]	b1s06[166]	-3.890	0.000	2.223	1.28	
b1s06[169]	.			-3.888	0.000	-1.666	1.56	
b1s06[170]	.			-6.114	0.000	-4.447	1.50	
b1s06[171]	.			0.556	0.000	-3.334	1.39	
b1s06[172]	.			-1.111	0.000	-4.998	1.33	
b1s06[173]	.			0.000	0.000	-2.220	1.22	
b1s06[174]	.			0.556	0.000	-3.334	1.00	
b1s06[175]	b1s06[173]	-4.443	0.000	-1.111	1.00	
b1s06[176]	b1s06[170]	-4.440	0.000	0.000	1.39	
b1s06[177]	.			-5.000	0.000	-1.667	1.33	
b1s06[178]	.			-4.443	0.000	1.111	1.22	
b1s06[179]	b1s06[177]	-1.667	0.000	-2.778	1.22	
b1s06[180]	.			1.111	0.000	-4.998	1.11	
b1s06[181]	b1s06[168]	0.000	1.110	2.776	1.33	
b1s06[182]	.			-0.557	0.000	1.670	1.11	

*compt /library/Purk_spinyd
b1s07[0]	br1[4]		2.779	1.112	4.446	2.94	
b1s07[1]	.			3.891	0.000	7.782	1.67	
b1s07[2]	.			0.000	1.110	3.885	1.56	
b1s07[3]	.			-5.480	0.000	11.568	1.44	
b1s07[4]	.			-4.442	-0.555	3.331	1.33	
b1s07[5]	.			-1.669	0.000	1.669	1.22	

*compt /library/Purk_thickd
b1s08[0]	br1[5]		-4.442	0.555	-3.331	3.72	
*compt /library/Purk_spinyd
b1s08[1]	b1s08[0]	-5.003	0.556	-2.779	3.00	
b1s08[2]	.			-4.998	0.000	-1.111	2.78	
b1s08[3]	.			-5.003	-0.556	-2.779	2.28	
b1s08[4]	.			-4.999	0.000	2.222	1.78	
b1s08[5]	b1s08[3]	-3.888	0.000	-1.666	1.61	
b1s08[6]	.			-3.336	0.000	-1.668	1.61	
b1s08[7]	.			-3.887	0.000	-3.332	1.50	
b1s08[8]	.			-6.110	0.000	0.000	1.22	
b1s08[9]	.			-3.330	0.555	-2.775	1.22	
b1s08[10]	.			0.000	0.000	-1.670	1.06	
b1s08[11]	.			-0.556	0.000	-7.229	0.89	
b1s08[12]	b1s08[10]	-5.000	0.000	-1.667	0.89	
b1s08[13]	b1s08[8]	-4.445	1.667	2.778	1.06	
b1s08[14]	.			-10.621	0.000	-1.118	0.89	
b1s08[15]	b1s08[6]	-10.553	0.555	4.999	1.33	
b1s08[16]	b1s08[2]	-3.330	0.555	2.775	2.00	
b1s08[17]	.			-7.779	0.000	-2.222	1.22	
b1s08[18]	.			-4.448	0.000	-3.336	1.22	
b1s08[19]	.			-1.666	0.000	-3.888	1.11	
b1s08[20]	b1s08[18]	-2.778	0.000	1.667	1.11	
b1s08[21]	b1s08[17]	-3.329	0.555	0.555	1.11	
b1s08[22]	b1s08[16]	-3.335	-1.112	2.224	1.28	
b1s08[23]	.			-16.160	0.557	7.801	1.33	
b1s08[24]	.			-16.712	0.000	5.013	1.33	

*compt /library/Purk_thickd
b1s09[0]	br1[7]		-4.999	1.111	-3.333	5.11	
*compt /library/Purk_spinyd
b1s09[1]	b1s09[0]	-1.666	0.000	-3.888	3.06	
b1s09[2]	.			-6.114	0.000	-5.003	2.06	
b1s09[3]	.			-10.005	0.000	0.556	1.67	
b1s09[4]	.			-3.334	0.000	2.778	1.11	
b1s09[5]	b1s09[3]	-4.448	0.000	-1.668	1.22	
b1s09[6]	.			-6.109	0.000	-2.221	1.00	
b1s09[7]	b1s09[5]	-0.555	0.000	-5.552	1.00	
b1s09[8]	.			0.556	0.000	-3.334	0.89	
b1s09[9]	b1s09[7]	-9.137	-0.571	-2.855	0.89	
b1s09[10]	b1s09[0]	-8.894	1.112	-0.556	3.06	
b1s09[11]	.			-11.669	-1.111	-1.667	2.44	
b1s09[12]	.			-3.886	0.555	-2.221	2.78	
b1s09[13]	.			-3.330	-0.555	2.220	2.28	
b1s09[14]	.			-3.890	0.000	0.000	1.78	
b1s09[15]	.			-2.776	0.000	-1.110	1.67	
b1s09[16]	.			-3.364	0.000	-10.652	1.56	
b1s09[17]	.			2.222	0.000	-4.999	1.33	
b1s09[18]	.			3.336	0.000	-4.448	1.11	
b1s09[19]	b1s09[16]	-3.334	0.000	-2.778	1.33	
b1s09[20]	.			-6.107	-0.555	-3.886	1.11	
b1s09[21]	.			-1.188	0.000	-4.754	1.11	
b1s09[22]	.			-5.555	0.000	-1.667	1.44	
b1s09[23]	.			-7.218	0.000	-3.332	1.56	
b1s09[24]	b1s09[22]	-5.556	-1.111	2.778	1.56	
b1s09[25]	b1s09[20]	-4.998	0.000	1.111	1.22	
b1s09[26]	.			-2.780	0.000	0.000	1.33	
b1s09[27]	.			-15.012	0.000	-8.896	1.33	
b1s09[28]	b1s09[26]	-22.344	-0.621	5.586	1.33	
b1s09[29]	b1s09[12]	-1.110	-1.110	-4.441	2.06	
b1s09[30]	.			0.000	0.000	-4.440	1.22	
b1s09[31]	b1s09[11]	-10.002	0.556	-4.446	2.39	
b1s09[32]	.			-4.998	0.000	-7.219	1.72	
b1s09[33]	.			0.000	0.000	-4.440	1.22	
b1s09[34]	b1s09[31]	-3.336	0.000	1.668	1.72	
b1s09[35]	.			-16.830	0.000	-1.161	1.44	
b1s09[36]	.			-16.163	0.703	-9.136	1.44	
b1s09[37]	b1s09[35]	-7.379	0.000	-2.270	1.44	
b1s09[38]	.			-3.336	0.000	-1.668	1.39	
b1s09[39]	.			-11.672	0.000	1.667	1.33	

*compt /library/Purk_thickd
b1s10[0]	br1[8]		-3.334	0.000	0.556	5.50	
b1s10[1]	.			-3.888	3.333	-3.888	3.72	
*compt /library/Purk_spinyd
b1s10[2]	b1s10[1]	-4.998	0.000	-1.111	2.17	
b1s10[3]	.			-7.780	0.556	0.556	2.00	
b1s10[4]	.			-4.445	0.000	-0.556	1.83	
b1s10[5]	.			-7.465	0.000	-2.297	1.67	
b1s10[6]	.			-2.224	0.000	-2.780	1.39	
b1s10[7]	b1s10[5]	-4.999	-0.555	0.000	1.39	
b1s10[8]	.			-1.112	0.556	-3.336	1.11	
b1s10[9]	.			-1.669	0.000	-1.669	1.00	
b1s10[10]	b1s10[7]	-3.891	0.556	0.000	1.11	
b1s10[11]	.			-2.778	0.000	-3.334	0.94	
b1s10[12]	.			-2.224	0.000	-3.337	0.78	
b1s10[13]	.			2.222	0.000	-4.999	0.89	
b1s10[14]	b1s10[12]	-2.778	0.000	-1.667	0.89	
b1s10[15]	.			-2.780	0.000	-2.224	1.00	
b1s10[16]	b1s10[10]	-6.107	0.000	-1.666	1.06	
b1s10[17]	.			-1.667	0.000	-2.778	1.00	
b1s10[18]	b1s10[16]	-8.333	1.667	-1.667	1.00	
b1s10[19]	.			3.334	0.000	-5.557	0.89	
b1s10[20]	b1s10[18]	-3.891	0.000	-0.556	0.89	
b1s10[21]	b1s10[3]	-3.330	0.000	3.330	1.61	
b1s10[22]	.			-3.887	1.666	6.109	1.22	
b1s10[23]	b1s10[0]	-4.442	3.331	0.555	3.56	
b1s10[24]	.			-8.955	-0.560	3.358	2.00	
b1s10[25]	.			-3.337	0.000	-2.224	1.67	
b1s10[26]	.			-2.220	0.000	-2.220	1.39	
b1s10[27]	.			-6.665	0.000	4.443	1.44	
b1s10[28]	b1s10[26]	-9.444	0.000	0.556	1.33	
b1s10[29]	b1s10[24]	-8.331	1.111	6.109	1.94	
b1s10[30]	.			-7.774	0.000	-1.666	1.67	
b1s10[31]	.			-7.220	0.000	0.000	1.61	
b1s10[32]	.			-3.888	0.555	-2.777	1.67	
b1s10[33]	.			-2.220	0.555	-1.665	1.56	
b1s10[34]	.			2.223	0.000	-4.445	1.50	
b1s10[35]	.			7.779	0.000	-2.222	1.22	
b1s10[36]	.			10.574	0.000	-5.009	1.00	
b1s10[37]	b1s10[34]	-4.999	0.000	-2.222	1.39	
b1s10[38]	.			-2.778	0.000	-3.890	1.17	
b1s10[39]	.			-10.578	0.000	-2.227	1.00	
b1s10[40]	.			-4.448	0.000	-3.892	1.11	
b1s10[41]	.			-4.448	0.000	-4.448	1.22	
b1s10[42]	.			1.666	0.000	-7.774	1.22	
b1s10[43]	b1s10[41]	-3.888	-0.555	-4.443	1.22	
b1s10[44]	b1s10[39]	-2.778	0.000	3.890	1.11	
b1s10[45]	.			-15.951	0.000	10.847	1.22	
b1s10[46]	b1s10[37]	-3.330	0.000	0.000	1.28	
b1s10[47]	.			-13.433	0.000	7.592	1.22	
b1s10[48]	.			-2.224	0.000	-1.668	1.06	
b1s10[49]	b1s10[46]	-6.110	0.000	1.111	1.28	
b1s10[50]	.			-2.778	-1.111	-3.334	1.22	
b1s10[51]	.			-5.001	0.556	-3.890	1.11	
b1s10[52]	.			-2.780	0.556	-2.780	1.17	
b1s10[53]	.			1.667	-0.556	-5.000	1.11	
b1s10[54]	b1s10[52]	-3.337	0.000	-2.224	1.17	
b1s10[55]	.			-5.555	0.000	-1.667	1.11	
b1s10[56]	.			-6.667	0.000	0.556	1.00	
b1s10[57]	b1s10[49]	-5.000	0.000	2.778	1.11	
b1s10[58]	.			-16.086	0.000	4.596	0.89	
b1s10[59]	.			-4.999	0.000	2.222	1.06	
b1s10[60]	.			-7.779	0.000	2.778	1.22	
b1s10[61]	b1s10[33]	-2.222	0.000	-0.555	1.39	
b1s10[62]	.			-4.444	0.556	-2.222	1.06	
b1s10[63]	b1s10[61]	-4.448	0.000	4.448	1.17	
b1s10[64]	.			2.673	0.000	9.356	1.11	
b1s10[65]	b1s10[31]	-6.668	0.000	1.111	1.44	
b1s10[66]	.			-2.780	0.000	0.000	1.11	
b1s10[67]	b1s10[29]	-1.109	0.000	2.218	1.72	
b1s10[68]	.			-1.666	0.000	3.888	1.89	
b1s10[69]	.			1.110	1.664	2.774	1.83	
b1s10[70]	.			-23.421	0.601	3.003	1.44	
b1s10[71]	b1s10[69]	-21.798	0.703	11.954	1.44	
b1s10[72]	b1s10[68]	-5.560	1.668	1.112	1.89	
b1s10[73]	.			-25.146	0.000	-1.796	1.56	
b1s10[74]	.			-2.218	0.000	-1.109	1.50	
b1s10[75]	.			-12.857	1.677	-12.298	1.44	
b1s10[76]	.			-3.887	0.000	-6.108	1.50	
b1s10[77]	.			-5.000	-1.111	-8.890	1.44	
b1s10[78]	b1s10[73]	-7.780	0.556	2.223	1.44	
b1s10[79]	.			-5.555	0.000	1.667	1.39	
b1s10[80]	.			-9.219	-1.152	-1.729	1.44	
b1s10[81]	.			1.668	0.000	-2.224	1.44	
b1s10[82]	b1s10[80]	-18.402	0.000	-2.968	1.44	
b1s10[83]	b1s10[79]	-9.061	-0.566	6.229	1.44	
b1s10[84]	.			-3.890	0.000	-2.778	1.44	
b1s10[85]	b1s10[83]	-6.355	-1.271	13.981	1.44	

*compt /library/Purk_thickd
b1s11[0]	br1[10]		4.445	0.000	2.223	3.28	
*compt /library/Purk_spinyd
b1s11[1]	b1s11[0]	3.888	0.000	5.554	2.11	
b1s11[2]	.			5.000	0.000	0.000	1.72	
b1s11[3]	.			3.330	0.000	0.000	1.33	
b1s11[4]	b1s11[1]	-1.110	0.555	4.440	1.72	
b1s11[5]	.			-6.764	-0.564	16.347	1.33	
b1s11[6]	.			2.226	1.113	0.556	1.17	
b1s11[7]	.			3.885	-1.110	0.000	1.00	
b1s11[8]	b1s11[5]	-3.887	0.555	3.332	1.17	
b1s11[9]	.			-4.078	0.000	13.980	1.00	
b1s11[10]	.			5.822	0.000	15.136	1.00	

*compt /library/Purk_thickd
b1s12[0]	br1[12]		-12.218	0.000	2.777	4.00	
*compt /library/Purk_spinyd
b1s12[1]	b1s12[0]	-5.000	0.000	0.000	2.44	
b1s12[2]	.			0.555	-0.555	3.329	2.06	
b1s12[3]	.			2.306	1.153	21.335	1.44	
b1s12[4]	b1s12[1]	-3.885	0.000	-1.110	2.28	
b1s12[5]	.			-3.330	0.000	-1.110	2.44	
b1s12[6]	.			-2.779	0.000	-2.779	3.00	
b1s12[7]	.			-4.996	0.555	-3.331	2.61	
b1s12[8]	.			-5.552	0.000	-2.221	2.39	
b1s12[9]	.			-3.336	0.000	-4.448	2.28	
b1s12[10]	.			-3.888	0.000	-5.554	1.89	
b1s12[11]	.			2.220	0.000	-2.220	1.67	
b1s12[12]	b1s12[10]	-9.444	0.000	0.556	1.50	
b1s12[13]	b1s12[8]	-6.107	1.110	2.776	2.00	
b1s12[14]	.			-6.669	-2.223	0.000	1.44	
b1s12[15]	.			-4.999	-1.111	-4.444	1.67	
b1s12[16]	.			-3.891	-0.556	-3.891	1.67	
b1s12[17]	b1s12[5]	-6.109	0.000	2.777	3.00	
b1s12[18]	.			-6.114	0.000	-5.003	2.33	
b1s12[19]	.			-6.114	-0.556	4.446	2.22	
b1s12[20]	.			-4.998	0.000	1.111	2.78	
b1s12[21]	.			-3.334	0.000	-2.778	2.44	
b1s12[22]	.			-3.337	0.000	-2.224	1.89	
b1s12[23]	.			-4.445	0.000	0.556	1.72	
b1s12[24]	.			-2.223	0.000	-4.445	1.50	
b1s12[25]	.			-3.885	0.000	-1.110	1.22	
b1s12[26]	.			-1.110	0.000	2.776	1.17	
b1s12[27]	.			-6.761	0.563	3.381	1.11	
b1s12[28]	b1s12[25]	-4.448	0.000	-1.668	1.17	
b1s12[29]	.			-7.224	0.000	-2.778	1.11	
b1s12[30]	b1s12[23]	-6.108	-0.555	3.332	1.83	
b1s12[31]	.			-4.999	0.000	-2.222	1.67	
b1s12[32]	b1s12[30]	-3.331	0.555	4.442	1.67	
b1s12[33]	.			-2.779	0.000	2.779	1.44	
b1s12[34]	b1s12[20]	-2.779	1.112	5.003	2.22	
b1s12[35]	.			-11.510	-0.575	4.604	1.67	
b1s12[36]	.			-3.331	0.555	-4.996	1.50	
b1s12[37]	b1s12[35]	-2.778	0.000	3.334	1.50	
b1s12[38]	.			-1.110	0.000	3.885	1.33	
b1s12[39]	b1s12[19]	-1.111	0.000	4.998	2.22	
b1s12[40]	.			-2.954	1.181	18.903	1.67	
b1s12[41]	.			-6.512	0.592	19.536	1.67	
b1s12[42]	.			-7.218	0.000	3.332	1.44	
b1s12[43]	b1s12[17]	0.555	1.666	6.663	2.11	
b1s12[44]	.			1.110	1.110	3.885	1.22	
b1s12[45]	.			4.998	2.777	7.220	1.17	
b1s12[46]	b1s12[44]	-1.666	-2.222	8.886	1.17	
b1s12[47]	.			0.000	0.000	5.000	1.11	
b1s12[48]	.			6.707	0.000	9.501	1.11	
b1s12[49]	.			0.555	0.000	4.999	1.00	
b1s12[50]	b1s12[47]	-4.998	0.555	4.443	1.00	
b1s12[51]	.			0.555	0.000	2.222	0.89	
b1s12[52]	.			-6.670	0.000	0.000	0.89	
b1s12[53]	b1s12[51]	-1.110	-0.555	4.440	0.89	

*compt /library/Purk_thickd
b1s13[0]	br1[13]		-6.668	0.000	1.111	4.17	
*compt /library/Purk_spinyd
b1s13[1]	b1s13[0]	-3.889	0.000	-3.889	2.22	
b1s13[2]	.			-4.998	-0.555	-4.443	1.89	
b1s13[3]	.			-3.888	1.111	-3.888	1.61	
b1s13[4]	b1s13[0]	-2.780	0.000	2.224	1.94	
b1s13[5]	.			-5.552	0.555	0.000	1.33	
b1s13[6]	.			-6.110	0.000	-1.111	1.39	
b1s13[7]	.			-4.445	0.000	-2.223	1.44	
b1s13[8]	.			-5.000	0.000	-4.445	1.39	

*compt /library/Purk_thickd
b1s14[0]	br1[14]		3.329	0.555	0.555	3.61	
*compt /library/Purk_spinyd
b1s14[1]	b1s14[0]	3.336	0.556	3.336	2.56	
b1s14[2]	.			3.885	-1.110	-1.665	2.50	
b1s14[3]	.			8.511	0.000	1.702	2.00	
b1s14[4]	.			2.223	0.000	4.445	2.11	
b1s14[5]	.			2.221	0.000	5.552	2.11	
b1s14[6]	.			2.778	0.000	3.334	2.00	
b1s14[7]	.			1.667	0.000	5.000	2.89	
b1s14[8]	.			4.440	0.000	0.000	2.83	
b1s14[9]	.			2.777	0.000	4.444	1.72	
b1s14[10]	.			5.028	0.000	12.291	1.56	
b1s14[11]	.			-1.111	0.555	5.553	1.50	
b1s14[12]	.			2.222	0.556	5.556	1.44	
b1s14[13]	b1s14[10]	3.886	0.000	4.997	1.39	
b1s14[14]	.			1.668	0.000	4.448	1.22	
b1s14[15]	.			3.334	1.667	1.111	1.33	
b1s14[16]	b1s14[7]	3.889	0.000	3.889	2.61	
b1s14[17]	b1s14[1]	0.000	-0.556	6.115	2.56	
b1s14[18]	.			1.111	-0.555	5.553	2.28	
b1s14[19]	.			8.394	0.000	16.788	2.44	
b1s14[20]	.			3.329	0.555	0.555	2.22	
b1s14[21]	.			5.041	0.000	6.931	2.00	
b1s14[22]	.			1.110	1.666	7.218	1.61	
b1s14[23]	.			0.555	-1.665	2.220	1.22	
b1s14[24]	b1s14[19]	0.000	0.000	6.110	2.06	
b1s14[25]	.			-1.666	0.000	3.888	1.67	
b1s14[26]	.			-4.447	2.223	4.447	1.78	
b1s14[27]	.			-1.111	0.000	8.891	2.00	
b1s14[28]	.			-9.477	0.000	6.690	2.11	
b1s14[29]	.			2.234	-1.117	10.054	2.11	
b1s14[30]	.			-1.111	0.000	9.998	1.89	
b1s14[31]	.			-6.668	0.000	5.557	1.50	
b1s14[32]	b1s14[30]	3.334	0.000	5.001	1.50	
b1s14[33]	.			-2.221	0.000	5.552	1.33	
b1s14[34]	b1s14[29]	5.557	0.000	6.668	1.72	
b1s14[35]	.			1.146	0.573	15.477	1.33	
b1s14[36]	b1s14[28]	-5.556	1.111	2.778	1.89	
b1s14[37]	.			-3.336	-0.556	3.336	1.67	
b1s14[38]	.			1.667	1.111	10.001	1.72	
b1s14[39]	.			6.664	-0.555	8.885	1.61	
b1s14[40]	b1s14[27]	2.781	-0.556	1.668	1.72	
b1s14[41]	.			6.244	0.568	15.327	1.33	
b1s14[42]	.			5.000	0.000	4.445	1.67	

*compt /library/Purk_spinyd
b1s15[0]	br1[16]		-2.777	1.111	1.111	2.61	
b1s15[1]	.			-10.034	0.000	10.592	1.67	
b1s15[2]	b1s15[0]	-2.220	0.000	0.000	1.44	
b1s15[3]	.			-4.444	0.000	2.777	1.22	
b1s15[4]	.			-3.890	0.000	2.223	1.11	
b1s15[5]	b1s15[2]	-5.001	0.000	-3.334	1.11	
b1s15[6]	.			-9.267	-0.579	2.317	1.00	
b1s15[7]	b1s15[5]	-10.014	0.626	-3.129	1.00	

*compt /library/Purk_thickd
b1s16[0]	br1[17]		-6.112	0.556	1.667	3.28	
*compt /library/Purk_spinyd
b1s16[1]	b1s16[0]	-3.336	0.000	4.448	2.44	
b1s16[2]	.			-4.445	0.000	2.223	2.06	

*compt /library/Purk_spinyd
b1s17[0]	br1[18]		7.220	0.000	-1.666	2.94	
b1s17[1]	.			8.331	0.555	-3.332	1.50	

*compt /library/Purk_spinyd
b1s18[0]	br1[19]		-0.556	0.000	-3.334	3.11	

*compt /library/Purk_spinyd
b1s19[0]	br1[20]		-0.556	0.000	-3.334	2.56	
b1s19[1]	.			0.000	0.555	-4.999	1.83	
b1s19[2]	.			-0.556	0.000	-3.334	1.39	
b1s19[3]	b1s19[0]	-4.446	-0.556	6.114	2.72	
b1s19[4]	.			-6.107	0.555	-3.886	2.78	
b1s19[5]	.			-9.442	-0.555	-4.443	2.17	
b1s19[6]	.			-4.440	0.000	0.000	2.11	
b1s19[7]	.			-3.337	0.000	-2.224	2.00	
b1s19[8]	.			-3.892	0.000	-4.448	1.72	
b1s19[9]	.			-3.333	0.000	-6.110	1.50	
b1s19[10]	.			-1.109	1.109	-1.109	1.44	
b1s19[11]	.			2.775	0.555	-3.330	1.33	
b1s19[12]	.			0.000	0.000	-7.220	1.00	
b1s19[13]	b1s19[10]	-1.664	0.000	-1.109	1.28	
b1s19[14]	.			-2.084	0.695	-7.641	1.11	
b1s19[15]	b1s19[13]	-9.442	0.000	-2.222	1.28	
b1s19[16]	.			-2.222	0.555	-2.777	1.28	
b1s19[17]	b1s19[15]	-4.448	0.000	1.668	1.28	
b1s19[18]	.			-4.999	0.555	-0.555	1.11	
b1s19[19]	.			-10.050	0.558	-5.583	1.11	
b1s19[20]	.			-4.448	0.000	3.336	1.06	
b1s19[21]	b1s19[19]	-4.443	0.000	-6.665	1.06	
b1s19[22]	.			-6.115	0.000	-0.556	1.00	
b1s19[23]	b1s19[18]	-10.000	0.000	3.889	1.06	
b1s19[24]	.			-1.668	0.556	-2.781	1.00	
b1s19[25]	b1s19[7]	-5.003	-0.556	2.779	1.50	
b1s19[26]	.			-5.002	1.111	5.002	1.11	
b1s19[27]	.			-3.888	0.000	5.554	1.22	
b1s19[28]	.			-7.220	0.000	1.666	1.28	
b1s19[29]	.			-4.448	0.000	3.892	1.22	
b1s19[30]	b1s19[3]	-0.555	0.555	4.999	2.50	
b1s19[31]	.			1.111	0.000	6.110	1.67	
b1s19[32]	.			-3.890	0.000	2.778	1.56	
b1s19[33]	.			-11.316	0.000	2.263	1.44	
b1s19[34]	.			-8.329	0.000	-2.221	1.61	
b1s19[35]	.			-8.889	1.111	2.222	1.72	
b1s19[36]	.			-2.778	0.000	3.334	1.67	
b1s19[37]	.			-9.442	0.000	-2.222	1.50	
b1s19[38]	b1s19[36]	-0.555	0.555	10.551	1.50	
b1s19[39]	.			-15.568	0.000	8.896	1.33	
b1s19[40]	b1s19[38]	-4.443	-0.555	3.888	1.33	
b1s19[41]	.			-6.666	-0.555	9.999	1.17	
b1s19[42]	.			-5.555	0.000	1.667	1.00	

*compt /library/Purk_spinyd
b1s20[0]	br1[20]		-1.112	0.556	6.115	2.56	
b1s20[1]	.			-4.445	0.000	-0.556	1.89	
b1s20[2]	.			-3.885	0.000	-1.110	1.78	
b1s20[3]	.			-2.779	1.112	-5.003	1.89	
b1s20[4]	.			-2.222	0.556	-5.556	1.72	
b1s20[5]	.			-8.886	0.000	-3.332	1.50	
b1s20[6]	.			1.109	0.000	2.218	1.44	
b1s20[7]	b1s20[4]	2.222	0.556	-5.556	1.50	
b1s20[8]	.			-2.218	0.000	-1.109	1.44	
b1s20[9]	.			-5.000	0.000	1.667	1.44	
b1s20[10]	b1s20[8]	1.668	0.000	-3.336	1.44	
b1s20[11]	b1s20[2]	-2.779	-0.556	7.224	1.67	
b1s20[12]	.			-7.220	0.000	0.000	1.28	
b1s20[13]	b1s20[11]	1.111	0.000	8.336	1.28	
b1s20[14]	.			1.494	0.000	8.215	1.11	
b1s20[15]	b1s20[0]	1.111	0.000	4.998	1.61	
b1s20[16]	.			-2.221	0.000	6.109	1.33	
b1s20[17]	.			-8.887	0.000	3.888	1.56	
b1s20[18]	.			-3.334	0.000	5.001	1.39	
b1s20[19]	b1s20[15]	4.444	0.556	2.778	1.17	
b1s20[20]	.			6.109	0.000	12.218	1.06	
b1s20[21]	b1s20[19]	5.000	-0.556	1.667	1.06	

*compt /library/Purk_thickd
b2s21[0]	br2[1]		7.219	-0.555	0.000	3.67	
*compt /library/Purk_spinyd
b2s21[1]	b2s21[0]	8.794	0.000	-0.676	2.11	
b2s21[2]	.			-0.556	0.556	-3.891	2.11	
b2s21[3]	.			-0.555	0.000	-2.222	1.94	
b2s21[4]	.			-2.220	0.000	-2.220	1.50	
b2s21[5]	b2s21[3]	3.887	-0.555	-3.332	1.50	
b2s21[6]	b2s21[1]	3.886	0.555	2.221	1.67	
b2s21[7]	.			2.775	0.000	0.555	1.22	
b2s21[8]	.			4.646	0.000	-17.421	1.22	
b2s21[9]	.			2.221	0.000	-8.329	1.11	
b2s21[10]	b2s21[7]	4.443	0.000	1.111	1.22	
b2s21[11]	.			5.560	0.000	1.112	1.61	
b2s21[12]	.			2.222	0.556	-5.000	1.72	
b2s21[13]	.			0.000	0.000	-3.890	1.33	
b2s21[14]	.			-4.444	0.556	-2.778	1.17	
b2s21[15]	.			-7.334	0.000	-9.026	1.11	
b2s21[16]	b2s21[13]	-2.777	0.000	-6.109	1.17	
b2s21[17]	.			-5.859	0.000	-6.445	1.11	
b2s21[18]	b2s21[11]	4.445	0.000	2.223	1.56	
b2s21[19]	.			4.996	0.555	3.331	1.11	
b2s21[20]	.			3.441	0.000	-10.322	1.11	
b2s21[21]	b2s21[19]	1.112	-0.556	1.668	1.11	
b2s21[22]	.			9.445	0.556	3.889	1.11	
b2s21[23]	b2s21[21]	1.111	0.555	6.665	1.11	
b2s21[24]	.			1.667	0.000	8.335	1.06	

*compt /library/Purk_thickd
b2s22[0]	br2[2]		-3.888	0.555	4.443	3.44	
*compt /library/Purk_spinyd
b2s22[1]	b2s22[0]	-20.534	-0.587	15.840	1.56	
b2s22[2]	.			-15.097	-0.559	-1.677	1.56	
b2s22[3]	.			-7.775	1.111	-2.777	1.50	
b2s22[4]	.			-2.779	0.000	-2.779	1.44	
b2s22[5]	b2s22[1]	-2.223	0.000	3.890	1.50	
b2s22[6]	.			1.667	0.000	5.000	1.22	
b2s22[7]	.			1.669	0.000	1.669	0.83	
b2s22[8]	b2s22[6]	-0.555	1.110	0.555	0.83	
b2s22[9]	b2s22[5]	-1.666	0.555	1.666	1.06	
b2s22[10]	.			-16.250	0.000	5.000	0.67	
b2s22[11]	.			-4.360	0.000	9.966	0.67	
b2s22[12]	b2s22[9]	-14.731	1.281	16.653	0.67	

*compt /library/Purk_thickd
b2s23[0]	br2[3]		5.552	0.000	0.555	3.89	
*compt /library/Purk_spinyd
b2s23[1]	b2s23[0]	5.554	0.000	3.888	2.67	
b2s23[2]	.			2.780	0.000	0.000	2.50	
b2s23[3]	.			0.000	0.000	-4.440	2.00	
b2s23[4]	.			0.000	1.110	-2.776	1.61	
b2s23[5]	b2s23[2]	4.445	0.556	1.667	1.78	
b2s23[6]	.			4.444	-0.556	2.222	1.56	
b2s23[7]	.			4.444	0.000	-2.777	1.39	
b2s23[8]	.			3.887	0.555	1.110	1.22	
b2s23[9]	b2s23[6]	0.000	0.000	2.220	1.61	
b2s23[10]	.			4.999	1.111	3.333	1.50	
b2s23[11]	.			5.611	0.561	6.172	1.33	
b2s23[12]	.			-0.555	-0.555	4.999	1.22	
b2s23[13]	.			9.402	0.000	10.655	1.11	
b2s23[14]	b2s23[11]	6.664	0.000	4.998	1.17	
b2s23[15]	.			18.018	0.667	0.000	1.00	
b2s23[16]	b2s23[14]	3.915	1.119	10.068	1.00	
b2s23[17]	b2s23[9]	-1.111	0.000	4.443	1.33	
b2s23[18]	.			-3.889	0.000	3.889	1.17	
b2s23[19]	.			0.556	0.000	4.445	1.33	
b2s23[20]	.			1.667	1.667	8.893	1.22	
b2s23[21]	b2s23[1]	1.111	0.000	4.443	2.33	
b2s23[22]	.			-2.224	0.000	2.780	1.50	
b2s23[23]	.			0.000	0.555	2.775	1.33	
b2s23[24]	.			0.555	0.000	4.999	1.22	
b2s23[25]	.			7.243	0.000	15.601	1.11	
b2s23[26]	b2s23[21]	3.332	-0.555	6.108	1.39	
b2s23[27]	.			1.667	0.556	8.888	1.11	

*compt /library/Purk_thickd
b2s24[0]	br2[4]		-5.552	0.000	4.442	3.83	
*compt /library/Purk_spinyd
b2s24[1]	b2s24[0]	-8.337	0.000	3.891	1.44	
b2s24[2]	.			-6.034	-0.603	9.654	1.22	
b2s24[3]	.			3.890	1.111	6.669	1.22	
b2s24[4]	.			6.111	0.000	7.222	1.11	
b2s24[5]	b2s24[2]	-6.667	0.556	11.111	1.28	
b2s24[6]	.			-2.221	1.111	10.552	1.33	

*compt /library/Purk_thickd
b2s25[0]	br2[8]		-2.222	2.777	7.775	5.17	
b2s25[1]	.			3.336	0.000	4.448	3.39	
*compt /library/Purk_spinyd
b2s25[2]	b2s25[1]	5.557	1.111	8.336	2.22	
b2s25[3]	.			6.670	0.000	0.000	2.11	
b2s25[4]	.			5.556	0.000	6.112	1.72	
b2s25[5]	b2s25[2]	3.889	1.111	14.444	1.94	
b2s25[6]	.			10.642	-2.504	18.780	1.67	
b2s25[7]	.			5.400	3.000	19.200	1.67	
b2s25[8]	.			1.110	0.555	4.440	1.39	
b2s25[9]	b2s25[5]	1.666	1.111	6.110	1.39	
b2s25[10]	.			5.284	-1.761	9.393	1.11	
b2s25[11]	b2s25[0]	-3.331	-0.555	4.442	3.06	
b2s25[12]	.			-2.221	0.000	5.552	1.56	
b2s25[13]	.			5.000	0.000	2.778	1.56	
b2s25[14]	.			6.115	0.556	-1.112	1.28	
b2s25[15]	b2s25[13]	7.777	-0.556	9.999	1.28	
b2s25[16]	.			4.446	1.111	6.113	1.00	
b2s25[17]	b2s25[15]	7.700	2.200	15.400	1.00	
b2s25[18]	.			4.694	0.000	14.081	1.00	
b2s25[19]	b2s25[12]	-1.668	0.556	3.335	1.89	
b2s25[20]	.			-4.999	-0.555	0.000	1.89	
b2s25[21]	.			-4.998	-0.555	4.998	1.56	
b2s25[22]	.			-1.112	1.668	5.560	1.33	
b2s25[23]	b2s25[19]	2.223	0.000	6.669	1.67	
b2s25[24]	.			7.220	0.000	3.888	1.11	
b2s25[25]	.			3.330	0.000	0.000	1.06	
b2s25[26]	b2s25[24]	7.264	0.000	17.881	1.11	
b2s25[27]	.			4.997	0.000	3.886	1.11	
b2s25[28]	b2s25[26]	5.949	0.000	16.064	1.11	
b2s25[29]	b2s25[23]	0.000	0.000	8.330	1.11	
b2s25[30]	.			1.667	0.000	5.000	1.28	
b2s25[31]	.			-8.889	0.000	19.445	1.22	
b2s25[32]	b2s25[30]	5.554	0.000	12.775	1.22	
b2s25[33]	.			-9.445	0.000	6.112	1.00	
b2s25[34]	b2s25[32]	9.446	0.000	14.446	1.00	

*compt /library/Purk_thickd
b2s26[0]	br2[10]		5.558	0.000	-5.558	3.67	
*compt /library/Purk_spinyd
b2s26[1]	b2s26[0]	5.552	0.000	2.221	2.56	
b2s26[2]	.			3.891	0.000	7.782	2.06	
b2s26[3]	.			4.999	0.000	4.999	1.78	
b2s26[4]	b2s26[1]	6.668	0.000	1.111	2.06	
b2s26[5]	.			7.779	0.000	4.445	1.61	
b2s26[6]	.			18.880	0.000	-4.005	1.44	
b2s26[7]	b2s26[4]	11.111	0.000	-3.333	1.61	
b2s26[8]	.			10.552	0.000	-1.111	1.44	
b2s26[9]	.			4.445	0.000	-2.223	1.39	
b2s26[10]	.			9.855	0.000	-8.447	1.33	
b2s26[11]	b2s26[9]	12.217	0.000	-0.555	1.33	
b2s26[12]	b2s26[0]	1.111	0.000	-6.668	2.56	
b2s26[13]	.			5.555	0.000	-1.667	2.22	
b2s26[14]	.			8.337	0.000	3.891	2.11	
b2s26[15]	.			10.005	0.000	0.556	1.94	
b2s26[16]	b2s26[13]	8.890	0.000	-5.001	2.06	
b2s26[17]	.			4.446	0.000	-11.114	2.00	
b2s26[18]	.			0.000	0.000	-10.560	1.67	
b2s26[19]	.			-6.668	0.000	-6.668	1.22	
b2s26[20]	b2s26[18]	4.999	0.000	-0.555	1.28	
b2s26[21]	b2s26[16]	7.219	0.000	4.998	1.61	
b2s26[22]	.			17.495	0.000	-9.997	1.22	
b2s26[23]	.			6.665	0.000	-4.443	1.11	
b2s26[24]	b2s26[22]	4.445	0.000	-12.779	1.11	
b2s26[25]	b2s26[12]	-2.776	0.000	-8.329	1.89	
b2s26[26]	.			-12.096	0.000	3.456	1.44	
b2s26[27]	.			-7.225	0.000	-1.112	1.44	
b2s26[28]	b2s26[26]	-4.997	0.000	-5.552	1.44	
b2s26[29]	.			-8.329	0.000	-2.776	1.11	
b2s26[30]	b2s26[28]	-7.775	0.000	-6.664	1.11	
b2s26[31]	b2s26[25]	0.559	0.000	-0.559	1.33	
b2s26[32]	.			-1.145	0.000	-13.170	1.22	
b2s26[33]	.			1.111	0.000	-4.998	1.22	
b2s26[34]	b2s26[32]	-2.223	0.000	-3.890	1.22	
b2s26[35]	b2s26[31]	7.223	0.000	-12.780	1.11	

*compt /library/Purk_thickd
b2s27[0]	br2[12]		7.779	0.000	2.222	3.78	
*compt /library/Purk_spinyd
b2s27[1]	b2s27[0]	9.444	0.000	-1.667	2.61	
b2s27[2]	.			6.669	0.000	-2.223	2.22	
b2s27[3]	.			3.890	0.000	-2.778	2.06	
b2s27[4]	.			-1.109	0.000	-2.218	1.61	
b2s27[5]	b2s27[3]	7.775	0.555	-3.887	1.61	
b2s27[6]	.			14.054	-0.740	-15.533	1.33	
b2s27[7]	b2s27[5]	24.188	-0.563	-10.688	1.33	
b2s27[8]	b2s27[2]	8.338	-0.556	1.112	1.72	
b2s27[9]	.			10.554	0.000	7.777	1.22	
b2s27[10]	.			5.002	0.000	9.448	1.06	
b2s27[11]	b2s27[8]	9.442	0.555	-4.443	1.06	
b2s27[12]	.			9.447	-0.556	-0.556	1.22	
b2s27[13]	.			13.336	0.000	-6.112	1.39	
b2s27[14]	.			9.444	0.556	3.333	1.06	
b2s27[15]	b2s27[12]	6.110	0.000	3.333	1.50	
b2s27[16]	.			9.444	-0.556	-2.778	1.28	
b2s27[17]	b2s27[1]	16.111	-0.556	12.777	1.83	
b2s27[18]	.			15.555	-0.556	7.778	1.56	
b2s27[19]	.			9.447	0.556	-10.003	1.67	
b2s27[20]	.			5.557	0.000	-6.668	1.67	
b2s27[21]	.			11.109	0.000	-7.221	1.44	
b2s27[22]	.			5.555	0.555	0.555	1.22	
b2s27[23]	b2s27[19]	7.224	0.000	-2.778	1.44	
b2s27[24]	.			16.755	0.762	-7.616	1.22	
b2s27[25]	b2s27[18]	20.560	0.000	-2.223	1.44	
b2s27[26]	.			6.113	1.111	-3.890	1.22	
b2s27[27]	b2s27[0]	6.665	-0.555	4.999	2.33	
b2s27[28]	.			3.888	0.555	7.221	1.83	
b2s27[29]	.			8.886	0.555	4.998	2.00	
b2s27[30]	.			5.000	0.000	-2.778	1.83	
b2s27[31]	.			13.893	-0.556	11.114	1.56	
b2s27[32]	.			15.014	0.000	-3.336	1.44	
b2s27[33]	.			10.553	0.000	4.443	1.33	
b2s27[34]	b2s27[31]	10.003	1.111	0.556	1.22	
b2s27[35]	b2s27[29]	12.779	-0.556	9.445	1.78	
b2s27[36]	.			9.997	0.000	4.443	1.72	
b2s27[37]	.			14.444	0.000	-1.667	1.67	
b2s27[38]	.			9.446	0.556	9.446	1.61	
b2s27[39]	.			11.109	0.000	-5.554	1.44	
b2s27[40]	b2s27[38]	-2.222	0.555	14.996	1.61	
b2s27[41]	.			4.446	0.556	6.114	1.28	
b2s27[42]	b2s27[36]	8.331	0.555	7.776	1.50	
b2s27[43]	.			2.223	0.000	17.227	1.17	
b2s27[44]	.			1.667	0.000	10.559	1.22	
b2s27[45]	.			7.780	0.556	6.113	1.17	
b2s27[46]	b2s27[28]	3.889	-1.111	19.444	1.56	
b2s27[47]	.			11.109	2.222	11.664	1.11	

*compt /library/Purk_thickd
b2s28[0]	br2[15]		10.557	1.111	-0.556	4.22	
*compt /library/Purk_spinyd
b2s28[1]	b2s28[0]	5.552	-2.221	5.552	3.00	
b2s28[2]	b2s28[1]	17.227	-0.556	7.780	3.28	
b2s28[3]	.			8.334	0.556	-6.112	2.83	
b2s28[4]	.			8.331	1.111	3.888	2.11	
b2s28[5]	b2s28[2]	5.556	0.556	13.890	2.83	
b2s28[6]	.			14.442	-1.111	8.332	2.11	
b2s28[7]	.			12.221	0.556	3.333	1.89	
b2s28[8]	b2s28[1]	3.332	0.000	7.218	2.89	
b2s28[9]	.			8.336	1.111	5.557	2.50	
b2s28[10]	.			6.665	0.555	12.219	2.50	
b2s28[11]	.			4.445	0.000	5.000	2.33	
b2s28[12]	.			4.444	0.556	8.333	1.72	
b2s28[13]	.			2.777	0.000	5.554	1.39	
b2s28[14]	.			6.110	0.000	3.333	1.22	
b2s28[15]	b2s28[13]	9.445	0.000	12.778	1.22	
b2s28[16]	b2s28[10]	9.444	0.000	20.554	2.00	
b2s28[17]	.			0.555	0.000	13.328	1.22	
b2s28[18]	b2s28[8]	5.555	1.666	17.220	2.00	
b2s28[19]	.			9.442	0.555	14.996	1.22	
b2s28[20]	.			6.664	0.000	7.775	1.17	

*compt /library/Purk_thickd
b2s29[0]	br2[16]		7.225	1.112	10.004	4.56	
*compt /library/Purk_spinyd
b2s29[1]	b2s29[0]	0.000	0.556	3.891	3.17	
b2s29[2]	.			-3.891	0.556	-0.556	2.06	
b2s29[3]	.			-3.891	0.000	-0.556	1.72	
b2s29[4]	.			0.000	-3.333	9.999	1.67	
b2s29[5]	.			-2.222	-0.555	15.552	1.39	
b2s29[6]	b2s29[1]	1.111	-1.111	6.667	2.06	
b2s29[7]	.			3.889	0.000	3.889	1.61	
b2s29[8]	.			11.711	0.558	22.307	1.44	
b2s29[9]	.			-0.555	0.000	19.442	1.28	
b2s29[10]	b2s29[6]	0.000	-1.667	5.000	2.50	
b2s29[11]	.			-3.334	0.000	2.778	2.72	
b2s29[12]	.			-8.886	0.000	-2.777	1.83	
b2s29[13]	.			-9.444	-0.556	-2.778	1.22	
b2s29[14]	b2s29[11]	-1.111	0.000	6.668	1.89	
b2s29[15]	.			-3.887	0.000	3.332	1.50	
b2s29[16]	.			7.290	0.000	12.337	1.44	
b2s29[17]	.			0.000	1.667	5.555	1.22	
b2s29[18]	b2s29[16]	4.442	0.555	3.331	1.22	
b2s29[19]	b2s29[14]	5.002	1.667	9.448	1.56	
b2s29[20]	.			5.554	0.000	12.775	1.39	
b2s29[21]	b2s29[10]	4.445	1.111	11.112	2.44	
b2s29[22]	.			2.777	1.111	11.663	1.61	
b2s29[23]	.			4.999	0.555	6.665	1.44	
b2s29[24]	.			5.555	0.000	-1.667	1.33	
b2s29[25]	b2s29[21]	3.332	-0.555	6.108	1.61	
b2s29[26]	.			3.334	0.000	5.557	1.44	
b2s29[27]	.			0.000	0.000	10.560	1.33	
b2s29[28]	.			-5.000	0.000	2.778	1.17	
b2s29[29]	b2s29[27]	5.554	0.000	3.888	1.17	
b2s29[30]	b2s29[25]	18.887	1.111	6.666	1.28	
b2s29[31]	.			1.666	1.110	2.221	1.00	
b2s29[32]	.			8.332	0.555	0.000	1.00	
b2s29[33]	.			2.780	0.000	-2.224	0.89	
b2s29[34]	b2s29[31]	1.111	2.222	13.331	1.00	
b2s29[35]	b2s29[0]	6.665	-0.555	4.999	3.11	
b2s29[36]	.			4.448	0.000	3.336	1.89	
b2s29[37]	.			4.444	0.556	11.111	1.44	
b2s29[38]	.			24.673	2.056	6.854	1.33	
b2s29[39]	b2s29[35]	5.000	1.667	15.001	2.06	
b2s29[40]	.			8.334	-2.222	13.890	1.89	
b2s29[41]	.			3.333	0.000	18.888	1.83

*compt /library/Purk_thickd
b2s30[0]	br2[18]		-0.556	0.000	7.780	4.89	
*compt /library/Purk_spinyd
b2s30[1]	b2s30[0]	-4.999	0.000	2.222	3.06	
b2s30[2]	.			-1.667	-0.556	17.221	2.11	
b2s30[3]	.			-4.442	0.000	8.329	2.06	
b2s30[4]	.			1.666	0.555	9.997	2.00	
b2s30[5]	.			2.776	1.110	6.107	1.78	
b2s30[6]	.			-1.111	0.000	6.110	1.56	
b2s30[7]	b2s30[4]	-2.778	0.000	1.667	1.61	
b2s30[8]	b2s30[3]	-8.889	0.000	11.112	1.56	
b2s30[9]	.			-3.335	0.000	9.449	1.00	
b2s30[10]	b2s30[0]	3.332	-0.555	11.108	3.22	
b2s30[11]	.			-3.888	0.000	5.554	2.11	
b2s30[12]	.			0.555	0.555	8.885	2.00	
b2s30[13]	.			-3.332	0.000	14.440	1.72	
b2s30[14]	b2s30[12]	6.109	0.000	6.109	1.61	
b2s30[15]	.			7.778	2.222	5.000	1.00	
b2s30[16]	b2s30[10]	2.223	0.000	6.669	2.78	
b2s30[17]	.			-2.223	0.000	17.227	2.22	
b2s30[18]	.			-4.999	0.000	4.999	1.17	
b2s30[19]	b2s30[16]	3.886	0.000	4.997	2.61	
b2s30[20]	.			1.111	0.000	11.115	1.89	
b2s30[21]	.			-5.557	0.000	6.668	1.39	
b2s30[22]	b2s30[20]	5.555	1.111	8.888	1.39	
b2s30[23]	b2s30[19]	17.778	1.667	19.445	1.61	

*compt /library/Purk_thickd
b2s31[0]	br2[19]		-3.886	0.000	-4.997	3.44	
*compt /library/Purk_spinyd
b2s31[1]	b2s31[0]	-2.220	0.555	-3.330	1.89	
b2s31[2]	.			1.666	0.555	-9.997	1.78	
b2s31[3]	b2s31[1]	-14.440	0.000	-3.332	1.50	

*compt /library/Purk_spinyd
b2s32[0]	br2[20]		-2.224	0.000	-1.668	3.06	
b2s32[1]	.			-5.560	0.000	-1.112	1.28	

*compt /library/Purk_thickd
b2s33[0]	br2[21]		-1.111	-0.556	10.557	3.22	
*compt /library/Purk_spinyd
b2s33[1]	b2s33[0]	0.000	0.556	8.893	2.11	
b2s33[2]	.			-6.109	0.000	2.221	2.06	
b2s33[3]	.			-6.663	0.000	3.332	1.56	
b2s33[4]	b2s33[1]	-1.112	0.000	7.781	1.61	
b2s33[5]	.			-10.253	1.206	10.253	1.11	
b2s33[6]	.			9.447	0.556	12.225	1.06	

*compt /library/Purk_spinyd
b2s34[0]	br2[21]		-3.334	0.000	2.778	3.06	
b2s34[1]	.			-7.222	0.000	15.555	1.78	
b2s34[2]	.			-5.555	0.000	11.665	2.28	
b2s34[3]	.			3.334	1.667	11.669	2.22	
b2s34[4]	.			3.333	0.000	9.999	1.56	
b2s34[5]	.			-6.668	0.000	5.557	1.28	
b2s34[6]	b2s34[2]	-5.553	1.111	-0.555	1.94	
b2s34[7]	.			-1.124	0.562	24.728	1.11	
b2s34[8]	.			4.998	0.000	1.111	1.00	
b2s34[9]	b2s34[7]	-6.664	0.000	10.552	0.94	
	
*compt /library/Purk_thickd
b3s35[0]	br3[2]		-2.222	0.555	-2.777	4.06	
*compt /library/Purk_spinyd
b3s35[1]	b3s35[0]	-2.223	0.000	-3.890	2.06	
b3s35[2]	.			1.666	0.000	-3.888	1.61	
b3s35[3]	.			18.319	-1.182	-17.728	1.33	
b3s35[4]	b3s35[1]	-5.559	-0.556	-1.668	1.61	
b3s35[5]	.			-7.220	0.000	0.000	2.11	
b3s35[6]	.			-4.446	0.556	-6.114	2.33	
b3s35[7]	.			0.000	0.000	-1.670	1.78	
b3s35[8]	.			0.000	0.556	-6.115	1.61	
b3s35[9]	.			1.667	0.000	-2.778	1.44	
b3s35[10]	.			-3.889	0.556	-12.780	1.28	
b3s35[11]	b3s35[7]	3.890	0.556	-5.001	1.44	
b3s35[12]	.			4.149	0.593	-13.632	1.11	
b3s35[13]	.			-11.115	-0.585	-18.135	1.11	
b3s35[14]	b3s35[5]	-1.668	0.556	1.112	2.39	
b3s35[15]	.			-6.665	0.000	1.666	1.72	
b3s35[16]	.			-8.891	0.000	-1.111	1.39	
b3s35[17]	.			-3.336	0.000	1.668	1.00	
b3s35[18]	b3s35[14]	-1.110	0.000	3.885	1.50	
b3s35[19]	.			-8.349	0.557	8.349	1.11	
b3s35[20]	.			1.111	0.000	6.110	1.00	

*compt /library/Purk_thickd
b3s36[0]	br3[3]		-8.332	0.000	0.555	4.33	
*compt /library/Purk_spinyd
b3s36[1]	b3s36[0]	0.000	0.000	-1.670	2.56	
b3s36[2]	.			-5.000	0.000	0.000	2.28	
b3s36[3]	.			-5.003	-0.556	2.779	1.72	
b3s36[4]	.			-17.615	1.761	-1.761	1.44	
b3s36[5]	b3s36[0]	-4.444	0.556	2.778	2.00	
b3s36[6]	.			-17.306	0.000	2.791	1.44	
b3s36[7]	.			-2.220	0.000	0.000	1.33	
b3s36[8]	.			-6.108	0.555	-3.332	1.22	
b3s36[9]	b3s36[7]	-12.782	0.000	-1.111	1.00	

*compt /library/Purk_thickd
b3s37[0]	br3[4]		4.440	1.665	1.110	5.28	
b3s37[1]	.			1.670	0.000	0.000	3.56	
*compt /library/Purk_spinyd
b3s37[2]	b3s37[1]	1.110	0.000	-3.885	2.39	
b3s37[3]	.			2.777	0.000	-4.444	1.83	
b3s37[4]	.			15.478	0.000	-9.745	1.67	
b3s37[5]	.			8.893	0.000	0.556	1.44	
b3s37[6]	b3s37[1]	4.998	1.111	0.555	2.22	
b3s37[7]	.			2.777	-1.111	1.111	1.67	
b3s37[8]	.			4.448	0.000	-1.668	1.67	
b3s37[9]	.			12.244	0.557	4.452	1.67	
b3s37[10]	.			7.225	0.000	-1.112	1.44	
b3s37[11]	b3s37[9]	3.332	-0.555	5.553	1.44	
b3s37[12]	b3s37[8]	10.000	0.000	-3.889	1.44	
b3s37[13]	.			6.669	0.000	2.223	1.22	
b3s37[14]	b3s37[12]	7.220	0.000	-1.666	1.06	
b3s37[15]	b3s37[7]	3.888	0.000	5.554	1.50	
b3s37[16]	.			21.229	-0.559	8.380	1.33	
b3s37[17]	b3s37[15]	-4.134	0.591	30.707	1.33	
b3s37[18]	b3s37[0]	0.000	-0.556	3.334	3.28	
b3s37[19]	.			3.886	0.555	6.107	1.94	
b3s37[20]	.			3.934	-0.562	20.794	1.67	
b3s37[21]	.			4.443	0.000	6.665	1.50	
b3s37[22]	.			8.642	0.617	1.852	1.33	
b3s37[23]	.			2.780	0.556	-2.780	1.17	
b3s37[24]	b3s37[20]	-3.886	0.000	4.997	1.39	
b3s37[25]	.			-16.151	0.000	-5.768	1.11	
b3s37[26]	b3s37[18]	-0.556	0.000	3.334	1.89	
b3s37[27]	.			-3.364	0.000	21.306	1.56	
b3s37[28]	.			-8.887	0.000	7.220	1.33	
b3s37[29]	b3s37[27]	1.666	0.000	6.107	1.33	
b3s37[30]	.			3.335	0.000	8.338	1.22	
b3s37[31]	.			9.610	-0.565	6.218	1.33	
b3s37[32]	.			20.702	0.560	1.119	1.33	
b3s37[33]	b3s37[31]	0.557	0.000	21.733	1.33	
b3s37[34]	b3s37[30]	-1.111	0.000	4.443	1.67	
b3s37[35]	.			-8.894	0.556	-1.112	1.72	
b3s37[36]	b3s37[34]	1.666	0.000	6.665	1.72	
b3s37[37]	.			1.669	0.000	1.669	1.56	
b3s37[38]	.			6.111	0.556	6.111	1.50	
b3s37[39]	.			7.775	0.555	7.775	1.33	
b3s37[40]	b3s37[37]	-2.222	0.000	11.110	1.50	
b3s37[41]	.			-3.336	0.000	1.668	1.33	

*compt /library/Purk_thickd
b3s38[0]	br3[5]		0.000	0.556	6.115	3.67	
*compt /library/Purk_spinyd
b3s38[1]	b3s38[0]	-1.668	-0.556	5.559	2.39	
b3s38[2]	.			0.000	2.328	11.058	2.11	
b3s38[3]	.			1.667	0.000	10.559	1.83	
b3s38[4]	.			-0.556	0.000	6.667	1.44	

*compt /library/Purk_thickd
b3s39[0]	br3[7]		-7.779	0.000	-2.222	4.72	
*compt /library/Purk_spinyd
b3s39[1]	b3s39[0]	-2.218	0.000	-1.109	3.00	
b3s39[2]	.			-1.109	0.000	-2.218	2.39	
b3s39[3]	.			-8.529	0.000	-2.843	2.11	
b3s39[4]	.			-12.220	0.000	0.000	2.00	
b3s39[5]	.			-9.922	0.000	4.085	1.89	
b3s39[6]	b3s39[1]	-6.667	0.000	-0.556	2.28	
b3s39[7]	.			-6.111	-1.111	-1.111	1.89	
b3s39[8]	.			-5.558	-0.556	5.558	1.72	
b3s39[9]	.			-19.680	0.000	0.615	1.56	
b3s39[10]	.			-12.224	0.000	-3.334	1.44	
b3s39[11]	b3s39[0]	-4.998	0.555	4.998	2.33	
b3s39[12]	.			-13.376	0.000	10.032	1.33	
b3s39[13]	.			-2.220	0.555	3.330	1.39	

*compt /library/Purk_thickd
b3s40[0]	br3[9]		-5.559	0.556	-2.780	4.61	
*compt /library/Purk_spinyd
b3s40[1]	b3s40[0]	-1.668	0.556	-3.891	2.83	
b3s40[2]	.			-2.221	1.111	-4.443	2.00	
b3s40[3]	.			-3.335	-2.223	-6.113	1.72	
b3s40[4]	b3s40[0]	-5.000	0.000	0.000	2.56	
b3s40[5]	.			-6.665	0.000	-2.777	1.33	
b3s40[6]	.			-3.330	0.555	-2.775	1.22	
b3s40[7]	b3s40[4]	-6.665	-1.111	6.110	1.22	

*compt /library/Purk_thickd
b3s41[0]	br3[10]		3.885	-1.110	1.665	3.94	
*compt /library/Purk_spinyd
b3s41[1]	b3s41[0]	5.000	0.000	13.333	2.22	
b3s41[2]	.			-0.556	0.000	9.444	2.00	
b3s41[3]	.			2.776	0.000	8.329	1.50	
b3s41[4]	b3s41[1]	8.335	0.556	11.668	1.72	
b3s41[5]	.			16.167	-0.557	-4.460	1.22	
b3s41[6]	.			8.887	0.000	-7.220	1.22	
b3s41[7]	.			5.558	0.556	-4.447	1.06	
b3s41[8]	b3s41[5]	2.778	0.000	1.667	1.06	
b3s41[9]	b3s41[4]	4.999	0.000	13.887	1.06	

*compt /library/Purk_thickd
b3s42[0]	br3[12]		-10.005	0.000	-0.556	4.61	
*compt /library/Purk_spinyd
b3s42[1]	b3s42[0]	-24.695	0.000	4.490	2.22	
b3s42[2]	.			-7.778	0.000	7.778	2.06	
b3s42[3]	.			-9.444	0.556	0.000	1.50	

*compt /library/Purk_spinyd
b3s43[0]	br3[14]		-3.890	0.000	2.778	2.67	
b3s43[1]	.			-3.337	0.000	2.224	1.72	
b3s43[2]	.			-11.837	0.564	-10.146	1.56	
b3s43[3]	.			-14.440	-0.555	-2.221	1.33	
b3s43[4]	b3s43[2]	3.890	0.556	-8.890	1.33	
b3s43[5]	b3s43[1]	-3.889	-0.556	9.445	1.33	

*compt /library/Purk_thickd
b3s44[0]	br3[15]		-5.558	0.556	11.116	5.67	
b3s44[1]	.			2.780	0.000	2.224	3.78	
*compt /library/Purk_spinyd
b3s44[2]	b3s44[1]	6.111	1.111	1.111	2.50	
b3s44[3]	.			6.114	0.000	5.003	2.00	
b3s44[4]	.			3.886	0.000	4.997	1.72	
b3s44[5]	b3s44[1]	0.000	1.111	9.445	2.61	
b3s44[6]	.			8.887	0.000	3.888	1.83	
b3s44[7]	.			9.452	-0.591	10.634	1.44	
b3s44[8]	.			3.333	0.000	7.776	1.44	
b3s44[9]	b3s44[7]	5.560	0.000	1.112	1.44	
b3s44[10]	b3s44[5]	-1.667	0.000	5.000	2.67	
b3s44[11]	.			3.891	0.000	7.782	2.33	
b3s44[12]	.			8.888	1.667	2.778	1.44	
b3s44[13]	.			4.445	-0.556	16.669	1.50	
b3s44[14]	b3s44[11]	1.111	0.555	6.665	1.56	
b3s44[15]	.			4.443	0.000	18.329	1.44	
b3s44[16]	b3s44[10]	-6.113	-0.556	7.224	2.50	
b3s44[17]	.			5.002	0.000	9.448	1.89	
b3s44[18]	.			10.554	0.555	2.222	1.61	
b3s44[19]	.			14.400	3.600	13.800	1.33	
b3s44[20]	.			28.282	-3.463	-5.195	1.33	
b3s44[21]	b3s44[17]	0.555	0.555	5.555	1.61	
b3s44[22]	.			7.339	1.129	28.226	1.33	
b3s44[23]	.			-5.750	-0.575	9.200	1.33	
b3s44[24]	b3s44[16]	7.222	0.000	4.444	1.56	
b3s44[25]	.			6.108	0.000	3.887	1.11	
b3s44[26]	b3s44[0]	-4.440	0.555	1.110	3.28	
b3s44[27]	.			2.221	0.000	5.552	1.67	
b3s44[28]	.			-2.223	0.000	10.559	1.33	
b3s44[29]	.			2.222	0.000	18.890	1.11	
b3s44[30]	b3s44[26]	-1.113	0.557	1.113	2.06	
b3s44[31]	.			-5.001	0.000	-3.334	1.83	
b3s44[32]	.			-2.775	0.000	-0.555	1.56	
b3s44[33]	.			4.999	0.555	-7.221	1.39	
b3s44[34]	.			2.220	0.000	-2.220	1.22	
b3s44[35]	.			0.000	0.000	-2.220	1.22	
b3s44[36]	b3s44[34]	4.445	0.000	2.223	1.22	
b3s44[37]	b3s44[32]	-3.333	0.556	-7.778	1.28	
b3s44[38]	b3s44[30]	-1.664	-0.555	0.555	2.22	
b3s44[39]	.			0.000	0.000	8.330	2.06	
b3s44[40]	.			-1.111	0.000	4.443	1.50	
b3s44[41]	.			-10.000	0.000	8.889	1.22	
b3s44[42]	.			-8.329	0.000	2.221	1.11	
b3s44[43]	b3s44[38]	-3.888	0.000	1.666	2.00	
b3s44[44]	.			-6.114	0.000	5.003	1.67	
b3s44[45]	.			-7.225	-1.111	2.779	2.83	
b3s44[46]	.			-3.334	0.000	-2.778	3.11	
b3s44[47]	.			-8.330	0.000	0.000	2.11	
b3s44[48]	.			-12.222	1.111	6.111	1.67	
b3s44[49]	b3s44[45]	-3.334	2.778	1.111	2.67	

*compt /library/Purk_thickd
b3s45[0]	br3[16]		6.670	0.000	0.000	4.06	
*compt /library/Purk_spinyd
b3s45[1]	b3s45[0]	2.221	1.111	-4.443	2.50	
b3s45[2]	.			-2.221	0.000	-6.109	2.22	
b3s45[3]	.			0.000	-2.224	-1.668	1.78	
b3s45[4]	b3s45[0]	3.336	-1.668	0.000	3.28	
b3s45[5]	.			3.337	0.000	-2.224	3.00	
b3s45[6]	.			2.221	0.555	-3.886	2.22	
b3s45[7]	.			1.668	0.556	-3.891	2.00	
b3s45[8]	.			5.182	0.576	-14.395	1.78	
b3s45[9]	.			12.780	0.556	-2.778	1.50	
b3s45[10]	b3s45[6]	6.665	0.000	-1.666	1.72	
b3s45[11]	.			10.003	-1.111	-3.890	1.22	
b3s45[12]	b3s45[4]	1.113	1.113	0.557	3.78	
b3s45[13]	.			5.000	0.000	0.000	2.94	
b3s45[14]	.			6.663	-0.555	1.666	1.94	
b3s45[15]	.			3.336	0.000	-1.668	1.61	
b3s45[16]	.			3.067	0.613	-8.588	1.44	
b3s45[17]	.			-1.109	0.000	-2.218	1.33	
b3s45[18]	.			20.101	-2.319	-3.866	1.22	
b3s45[19]	b3s45[16]	5.558	-0.556	-4.447	1.33	
b3s45[20]	b3s45[12]	3.335	-2.223	8.337	3.44	
b3s45[21]	.			-2.222	1.666	4.444	2.50	
b3s45[22]	.			2.777	0.000	9.440	1.67	
b3s45[23]	.			4.448	0.000	4.448	1.44	
b3s45[24]	b3s45[20]	4.444	1.666	2.222	2.50	
b3s45[25]	.			8.885	0.555	-0.555	1.89	
b3s45[26]	.			3.332	0.555	-5.553	1.89	
b3s45[27]	.			6.109	0.000	-2.221	1.72	
b3s45[28]	.			5.000	0.000	4.445	1.44	
b3s45[29]	b3s45[25]	6.670	0.000	0.000	1.61	
b3s45[30]	.			9.444	0.000	-0.556	1.33	
b3s45[31]	.			15.731	0.000	-8.157	1.33	
b3s45[32]	b3s45[30]	13.334	0.000	3.889	1.11	
b3s45[33]	b3s45[24]	2.222	0.556	4.444	1.67	
b3s45[34]	.			1.111	-0.556	10.557	1.28	
b3s45[35]	.			3.332	0.555	3.887	1.00	
b3s45[36]	b3s45[33]	2.221	1.110	1.110	1.50	
b3s45[37]	.			4.448	0.000	-3.336	1.56	
b3s45[38]	.			6.114	-1.667	2.779	1.33	
b3s45[39]	.			4.996	0.555	-3.331	1.11	
b3s45[40]	b3s45[38]	21.923	3.322	9.965	1.11	
b3s45[41]	b3s45[36]	10.000	0.000	5.000	1.33	

*compt /library/Purk_thickd
b3s46[0]	br3[16]		2.223	0.000	6.669	3.94	
*compt /library/Purk_spinyd
b3s46[1]	b3s46[0]	5.001	0.556	12.225	2.56	
b3s46[2]	.			5.558	0.000	5.558	2.28	
b3s46[3]	.			3.890	0.000	6.668	2.00	
b3s46[4]	.			4.444	-0.555	14.442	1.61	
b3s46[5]	b3s46[3]	8.885	-1.666	6.108	1.61	
b3s46[6]	.			-1.178	0.589	18.263	1.22	
b3s46[7]	b3s46[1]	1.667	-0.556	14.444	2.11	
b3s46[8]	.			3.332	0.000	11.663	1.89	
b3s46[9]	.			6.668	-0.556	3.890	1.89	
b3s46[10]	.			8.331	1.111	7.220	1.56	
b3s46[11]	.			4.582	2.291	13.747	1.44	
b3s46[12]	.			-16.665	-1.111	11.110	1.44	
b3s46[13]	b3s46[8]	-3.332	0.000	8.886	1.78	
b3s46[14]	.			-6.600	0.600	16.200	1.44	
b3s46[15]	.			-1.900	4.433	17.733	1.44	

