// genesis

// Customized userprefs.g to run the "Tutorial 5" simulation with neurokit

/**********************************************************************
**
**	DO NOT EDIT THIS FILE IN THE neurokit DIRECTORY!
**
**	Make a copy of this file in every directory that contains .p
**	files and edit the copies, in order to customize neurokit for
**	different simulations. When you run neurokit from other
**	directories, the simulator will look for the local version of
**	userprefs.g, and if it cannot find it there will look for the
**	default in the neurokit directory.
**	
**	There are three aspects to customisation :
**	
**	1	Include the appropriate script files from the /neuron/prototype
**		directory and from wherever you have defined new prototype
**		elements.
**
**	2	Invoke the functions that make the prototypes you want for
**		your simulation.
**
**	3	Put your preferences for the user_variables defined in
** 		defaults.g in the copies of this file.
**
**********************************************************************/

echo Using local user preferences
 
/**********************************************************************
**
**	1	Including script files for prototype functions
**
**********************************************************************/

/* file for standard compartments */
include compartments

/* file for Hodgkin-Huxley Squid Na and K channels */
include hhchan

/* file for synaptic channels */
include synchans

/* file which makes a spike generator */
include protospike

/**********************************************************************
**
**	2	Invoking functions to make prototypes in the /library element
**
**********************************************************************/

/* To ensure that all subsequent elements are made in the library */
	pushe /library

	make_cylind_compartment		/* makes "compartment" */

/* Assign some constants to override those used in hhchan.g */
EREST_ACT = -0.07       // resting membrane potential (volts)
ENA   = 0.045           // sodium equilibrium potential
EK    = -0.082          // potassium equilibrium potential

make_Na_squid_hh     /* makes "Na_squid_hh" */

make_K_squid_hh      /* makes "K_squid_hh" */

make_Ex_channel      /* synchan with Ek = 0.045, tau1 = tau2 = 3 msec */

/* In case we need it later, put an inhibitory GABA-activated channel
   in the library, too */

make_Inh_channel    /* synchan: Ek = -0.082, tau1 = tau2 = 20 msec */

make_spike	/* Make a spike generator element */

pope /		/* return to the root element */

/**********************************************************************
**
**	3	Setting preferences for user-variables.
**
**********************************************************************/

/* See defaults.g for default values of these */
str user_help = "../neurokit/README"

user_cell = "/cell"
user_pfile = "cell.p"

user_runtime = 0.1
user_dt = 50e-6  // 0.05 msec
user_refresh = 5


// These are used for the two buttons which can be used to enter a value
// in the "Syn Type" dialog box
user_syntype1 = "Ex_channel"
user_syntype2 = "Inh_channel"

user_inject = 0.3  // default injection current (nA)

// Set the scales for the graphs in the two cell windows
user_ymin1 = -0.1
user_ymax1 = 0.05
user_xmax1 = 0.1
user_xmax2 = 0.1
user_ymin2 = 0.0
user_ymax2 = 5e-9

/*  This displays the second cell window and plots the "Gk" field of the
    "glu_mit_upi" channel for the compartment in which a recording electrode
    has been planted.  The default values of the field and path
    are "Vm" and ".", meaning to plot the Vm field for the compartment
    which is selected for recording.
*/

user_numxouts = 2
user_field2	= "Gk"
user_path2 = "Ex_channel"

/* These variables are used to set the draw widget window size, and were
   not given in Sec. 16.2 of "The Book of GENESIS".  The default values
   (0.0014, 0.0014) make the dendrite hard to see.  Smaller values of
   the xdraw wx and wy fields are equivalent to zooming in on the cell.
*/

user_wx = 0.0005
user_wy = 0.0005
