function [] = generate_STPlike_timed_odour_response(odour_ID,N)

    for n = 1:N
        if isa(odour_ID, 'char')
        else    
            error('odour_ID must be of type char')
        end

        foldername = strcat('/home/adithya/Documents/MATLAB/Odour_PNresponse_params_900PNs/STPlike/',odour_ID);

        cd(foldername);

        files_in_folder = dir(foldername);

        param_filename = strcat(odour_ID, '_params_similarity80.mat');

        number_exisitng_response_matrices = length(dir(foldername)) - 3;

        trial_number = number_exisitng_response_matrices + 1;

        load(param_filename);


        % generate the odour representation matrix : # of rows = # of PNs; # of
        % columns = trial duration


        odour_onset_time = 500; %(ms)
        number_PNs = 900; % number of Projection Neurons (PNs) in the system 
        trial_duration = 3000; % duration of the trial (ms)

        odour_rep_PN = zeros(number_PNs, trial_duration);

        % Create baseline spiking reponse for all neurons
        for i = 1:number_PNs
            n_b = round(2.23*randn(1) + 3.87); % n_b - baseline number of spikes generated by the neuron
            while n_b < 0 
                n_b = round(2.23*randn(1) + 3.87);
            end
            spike_location = randi(trial_duration,n_b,1); % defines location of spikes in time
            for j = 1:length(spike_location)
                odour_rep_PN(i,spike_location(j)) = 1;
            end    
        end

        % Create odour induced spiking response.
        for k = 1:length(parameters.responding_PNs)
            responding_PN = parameters.responding_PNs(k);
            
            n_r = parameters.n_r(1);
            n_e = parameters.n_e(1);
            d_f = parameters.d_f(1);
            s_c = parameters.s_c(1);
            
            if odour_ID == 'Odour01'
                if k == 1
                    for l = 1:n_e
                        odour_spike_locations = round(12*randn(s_c)+25);
                        save('spike_locations','odour_spike_locations')
                        for m = 1:length(odour_spike_locations)
                            if odour_spike_locations(m) <0 || odour_spike_locations(m) >50
                                odour_spike_locations(m) = round(12*randn(1)+25);
                            end
                            % This step adds spikes to the odour_rep_PN matrix at position
                            % [Number of responding PN, 500ms(time of odour onset) +
                            % 50ms(starting time for one cycle of LFP)*lth cycle in which that
                            % neuron fires + location of spike in that cycle]
                            odour_rep_PN(responding_PN,odour_onset_time +(d_f+l-1)*50+odour_spike_locations(m)) = 1; 
                        end    
                    end
                else
                    for l = 1:n_e
                        for m = 1:length(odour_spike_locations)
                            odour_rep_PN(responding_PN,odour_onset_time +(d_f+l-1)*50+odour_spike_locations(m)) = 1; 
                        end    
                    end
                end
            else
                load('/home/adithya/Documents/MATLAB/Odour_PNresponse_params_900PNs/STPlike/Odour1/spike_locations.mat');
                for l = 1:n_e
                    for m = 1:length(odour_spike_locations)
                        odour_rep_PN(responding_PN,odour_onset_time +(d_f+l-1)*50+odour_spike_locations(m)) = 1; 
                    end    
                end
            end    
        end

        filename = sprintf('trial%d',trial_number);
        xlswrite(filename, odour_rep_PN);
    end
end