TITLE Mod file for component: Component(id=generated_model__slow_transient_outward_potassium_current_0 type=generated_model__slow_transient_outward_potassium_current)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.4.6
         org.neuroml.model   v1.4.6
         jLEMS               v0.9.8.6

ENDCOMMENT

NEURON {
    SUFFIX Ksto : generated_model__slow_transient_outward_potassium_current_0
    USEION k READ ek WRITE ik 
    
    RANGE g_Kto_s                           : parameter
    : RANGE V                                 : parameter
    : RANGE E_K                               : parameter
    : RANGE time_                             : parameter
    : RANGE tscale                            : parameter
    
    RANGE ass                               : exposure
    
    RANGE ik                          : exposure
    
    RANGE iss                               : exposure
    
    RANGE tau_ti_s                          : exposure
    
    RANGE tau_ta_s                          : exposure
    
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (molar) = (1/liter)
    (kHz) = (kilohertz)
    (mM) = (millimolar)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    
}

PARAMETER {
    
    g_Kto_s = 0 (mho/cm2)
    v (mV) 
    ek (mV) 
    tscale = 0.001 (kHz)
}

ASSIGNED {
    
    ass (1)                                  : derived variable
    
    ik (mA/cm2)                                : derived variable
    
    iss  (1)                                  : derived variable
    
    tau_ti_s (ms)                              : derived variable
    
    tau_ta_s (ms)                              : derived variable
    rate_ato_s (/ms)
    rate_ito_s (/ms)
    
}

STATE {
    ato_s  (1)
    ito_s  (1)
    
}

INITIAL {
    rates(v)
    rates(v) ? To ensure correct initialisation.
    
    ato_s = 4.17069E-4
    
    ito_s = 0.998543
    
}

BREAKPOINT {
    
    SOLVE states METHOD cnexp
    ik = (((  g_Kto_s   *   ato_s  ) *   ito_s  ) * (  v   -   ek  )) ? evaluable    
    
}

DERIVATIVE states {
    rates(v)
    ato_s' = rate_ato_s 
    ito_s' = rate_ito_s 
    
}

PROCEDURE rates(v (mV)) {
    
    ass = (1.0 / (1.0 + exp(((0.0 - (  v   + 22.5 (mV))) / 7.7 (mV))))) ? evaluable

    iss = (1.0 / (1.0 + exp(((  v   + 45.2(mV)) / 5.7(mV))))) ? evaluable
    tau_ti_s = (270.0 (ms)+ (1050.0 (ms) / (1.0 + exp(((  v   + 45.2(mV)) / 5.7(mV)))))) ? evaluable
    tau_ta_s = ((0.493 (ms) * exp((( - 0.0629(/mV)) *   v  ))) + 2.058(ms)) ? evaluable
    rate_ito_s = (((  iss   -   ito_s  ) /   tau_ti_s  )) ? Note units of all quantities used here need to be consistent!
    rate_ato_s = (((  ass   -   ato_s  ) /   tau_ta_s  )) ? Note units of all quantities used here need to be consistent!
    
     
    
}

