TITLE Mod file for component: Component(id=generated_model__ultra_rapidly_activating_delayed_rectifier_potassium_current_0 type=generated_model__ultra_rapidly_activating_delayed_rectifier_potassium_current)

COMMENT

    This NEURON file has been generated by org.neuroml.export (see https://github.com/NeuroML/org.neuroml.export)
         org.neuroml.export  v1.4.6
         org.neuroml.model   v1.4.6
         jLEMS               v0.9.8.6

ENDCOMMENT

NEURON {
    SUFFIX Kurdr :generated_model__ultra_rapidly_activating_delayed_rectifier_potassium_current_0
    USEION k READ ek WRITE ik 
    RANGE g_Kur                             : parameter
    :RANGE time_                             : parameter
    RANGE iss                               : parameter
    :RANGE V                                 : parameter
    :RANGE E_K                               : parameter
    RANGE ass                               : parameter
    :RANGE tscale                            : parameter
    
    RANGE tau_iur                           : exposure
    
    RANGE tau_aur                           : exposure
    
    RANGE ik                             : exposure
    
}

UNITS {
    
    (nA) = (nanoamp)
    (uA) = (microamp)
    (mA) = (milliamp)
    (A) = (amp)
    (mV) = (millivolt)
    (mS) = (millisiemens)
    (uS) = (microsiemens)
    (molar) = (1/liter)
    (kHz) = (kilohertz)
    (mM) = (millimolar)
    (um) = (micrometer)
    (umol) = (micromole)
    (S) = (siemens)
    
}

PARAMETER {
    
    g_Kur = 0.000112 (S/cm2)
    :time_ = NaN 
    v (mV)
    ek (mV)
    :tscale = 0.001 (kHz)
}

ASSIGNED {
    
    tau_iur (ms)                               : derived variable
    
    tau_aur (ms)                               : derived variable
    ass (1) :slow_transient_outward_potassium_current.ass 
    iss (1) :slow_transient_outward_potassium_current.ass
    
    ik (mA/cm2)                                 : derived variable
    rate_aur (/ms)
    rate_iur (/ms)
    
}

STATE {
    aur  (1)
    iur  (1)
    
}

INITIAL {
    rates(v)
    rates(v) ? To ensure correct initialisation.
    
    aur = 4.17069E-4
    
    iur = 0.998543
    
}

BREAKPOINT {
    
    SOLVE states METHOD cnexp
    ik = (((  g_Kur   *   aur  ) *   iur  ) * (  v   -   ek  )) ? evaluable
}

DERIVATIVE states {
    rates(v)
    aur' =  (((  ass   -   aur  ) /   tau_aur  ))
    iur' = (((  iss   -   iur  ) /   tau_iur  ))
    
}

PROCEDURE rates(v (mV)) {
    
    ass = 1 / (1 + exp(-(v + 22.5 (mV) ) / 7.7 (mV) ))
    iss = 1 / (1 + exp((v + 45.2 (mV)) / 5.7 (mV)))
    tau_iur = (1200.0 (ms)- (170.0 (ms)/ (1.0 + exp(((  v   + 45.2 (mV)) / 5.7(mV)))))) ? evaluable
    tau_aur = ((0.493 (ms)* exp(((- 0.0629 (/mV)) *   v  ))) + 2.058(ms)) ? evaluable
    :rate_iur = tscale  * (((  iss   -   iur  ) /   tau_iur  )) ? Note units of all quantities used here need to be consistent!
    :rate_aur = tscale  * (((  ass   -   aur  ) /   tau_aur  )) ? Note units of all quantities used here need to be consistent!
}

