/*
 * Decompiled with CFR 0.152.
 */
package connectivity.conn_package;

import connectivity.nodes.ConnectivityPackageManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class PackageReader {
    public static final Double MAX_NE_EN_RATIO_DEF = 0.0;
    public static final Double MIN_NE_EN_RATIO_DEF = Double.MAX_VALUE;
    public static final Double MAX_AMPLITUDE_DEF = 0.0;
    public static final Double MIN_AMPLITUDE_DEF = Double.MAX_VALUE;
    private String packagePath;
    private Integer vertexNum;
    private Long edgesNum;
    private ConnectivityPackageManager rm;
    private static final Double zeroDouble = new Double(0.0);
    private static final String TAG = "[Package Reader]";
    private static Boolean verbose = true;
    private Double maxNe_xn_ratio = MAX_NE_EN_RATIO_DEF;
    private Double maxAmplitude = MAX_AMPLITUDE_DEF;
    private Double minNe_xn_ratio = MIN_NE_EN_RATIO_DEF;
    private Double minAmplitude = MIN_AMPLITUDE_DEF;
    private static final String AMPLITUDES_FILE_NAME = "mu_omega.txt";
    private static final String AMPLITUDES_STD_DEVIATION_FILE_NAME = "sigma_omega.txt";
    private static final String TRACT_LENGTHS_FILE_NAME = "mu_lambda.txt";
    private static final String TRACT_LENGTHS_SHAPE_PARAMETERS_FILE_NAME = "alpha_lambda.txt";
    private static final String CENTRES_FILE_NAME = "centres.txt";
    private static final String WEIGHTS_FILE_NAME = "Ne_xn_ratio.txt";
    private static final String CONNECTIONS_TYPE_FILE_NAME = "conn_type.txt";

    public PackageReader(ConnectivityPackageManager rm) {
        this.rm = rm;
    }

    public void readConnectivityPackage(String path) {
        this.packagePath = path;
        if (path.charAt(path.length() - 1) != '/') {
            this.packagePath = this.packagePath + '/';
        }
        this.println("reading configs file...");
        this.readCentersFile();
        this.println("done.");
        this.println("reading the Ne-en-ratio file...");
        this.readWeightsFile();
        this.println("reading the mu omega file...");
        this.readAmplitudesFile();
        this.println("reading the sigma omega file...");
        this.readAmplitudesStdDeviationFile();
        this.println("reading the mu lambda file...");
        this.readLengthsFile();
        this.println("reading the alpha lambda file...");
        this.readLengthsShapeParametersFile();
        this.println("reading the conenctions type file...");
        this.readConnectionsTypeFile();
        this.println("done.");
    }

    private void readCentersFile() {
        int i = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(this.packagePath + CENTRES_FILE_NAME));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] tokens = line.split(" ");
                String[] goodTkns = new String[4];
                int k = 0;
                int j = 0;
                while (k < 4) {
                    if (!tokens[j].equals("")) {
                        goodTkns[k++] = tokens[j];
                    }
                    ++j;
                }
                this.rm.addNode(goodTkns[0], new Double(goodTkns[1]), new Double(goodTkns[2]), new Double(goodTkns[3]));
                ++i;
            }
            this.vertexNum = i;
        }
        catch (FileNotFoundException e) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(this.packagePath + WEIGHTS_FILE_NAME));
                int lines = 0;
                while (reader.readLine() != null) {
                    this.rm.addNode();
                    ++lines;
                }
                reader.close();
                this.vertexNum = lines;
            }
            catch (FileNotFoundException e2) {
                e2.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readWeightsFile() {
        int i = 0;
        this.edgesNum = 0L;
        try (BufferedReader br = new BufferedReader(new FileReader(this.packagePath + WEIGHTS_FILE_NAME));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] tokens = line.split(" ");
                String[] goodTkns = new String[this.vertexNum.intValue()];
                int k = 0;
                int j = 0;
                while (k < this.vertexNum) {
                    if (!tokens[j].equals("")) {
                        goodTkns[k++] = tokens[j];
                    }
                    ++j;
                }
                for (j = 0; j < this.vertexNum; ++j) {
                    if (i == j) continue;
                    Double d = new Double(goodTkns[j]);
                    if (d > this.maxNe_xn_ratio) {
                        this.maxNe_xn_ratio = d;
                    }
                    if (d.equals(zeroDouble)) continue;
                    if (d < this.minNe_xn_ratio) {
                        this.minNe_xn_ratio = d;
                    }
                    this.rm.addEdge(i, j, d);
                    this.edgesNum = this.edgesNum + 1L;
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readAmplitudesFile() {
        int i = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(this.packagePath + AMPLITUDES_FILE_NAME));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] tokens = line.split(" ");
                String[] goodTkns = new String[this.vertexNum.intValue()];
                int k = 0;
                int j = 0;
                while (k < this.vertexNum) {
                    if (!tokens[j].equals("")) {
                        goodTkns[k++] = tokens[j];
                    }
                    ++j;
                }
                for (j = 0; j < this.vertexNum; ++j) {
                    if (i == j) continue;
                    Double d = new Double(goodTkns[j]);
                    if (d > this.maxAmplitude) {
                        this.maxAmplitude = d;
                    }
                    if (d < this.minAmplitude) {
                        this.minAmplitude = d;
                    }
                    this.rm.addAmplitude(i, j, d);
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readAmplitudesStdDeviationFile() {
        int i = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(this.packagePath + AMPLITUDES_STD_DEVIATION_FILE_NAME));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] tokens = line.split(" ");
                String[] goodTkns = new String[this.vertexNum.intValue()];
                int k = 0;
                int j = 0;
                while (k < this.vertexNum) {
                    if (!tokens[j].equals("")) {
                        goodTkns[k++] = tokens[j];
                    }
                    ++j;
                }
                for (j = 0; j < this.vertexNum; ++j) {
                    Double d;
                    if (i == j || (d = new Double(goodTkns[j])).equals(zeroDouble)) continue;
                    if (d < this.minNe_xn_ratio) {
                        this.minNe_xn_ratio = d;
                    }
                    this.rm.addAmplitudeStdDeviation(i, j, d);
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readLengthsFile() {
        int i = 0;
        this.edgesNum = 0L;
        try (BufferedReader br = new BufferedReader(new FileReader(this.packagePath + TRACT_LENGTHS_FILE_NAME));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] tokens = line.split(" ");
                String[] goodTkns = new String[this.vertexNum.intValue()];
                int k = 0;
                int j = 0;
                while (k < this.vertexNum) {
                    if (!tokens[j].equals("")) {
                        goodTkns[k++] = tokens[j];
                    }
                    ++j;
                }
                for (j = 0; j < this.vertexNum; ++j) {
                    Double d;
                    if (i == j || (d = new Double(goodTkns[j])).equals(zeroDouble)) continue;
                    this.rm.addLength(i, j, d);
                    this.edgesNum = this.edgesNum + 1L;
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readLengthsShapeParametersFile() {
        int i = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(this.packagePath + TRACT_LENGTHS_SHAPE_PARAMETERS_FILE_NAME));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] tokens = line.split(" ");
                String[] goodTkns = new String[this.vertexNum.intValue()];
                int k = 0;
                int j = 0;
                while (k < this.vertexNum) {
                    if (!tokens[j].equals("")) {
                        goodTkns[k++] = tokens[j];
                    }
                    ++j;
                }
                for (j = 0; j < this.vertexNum; ++j) {
                    Double d;
                    if (i == j || (d = new Double(goodTkns[j])).equals(zeroDouble)) continue;
                    this.rm.addLengthShapeParameter(i, j, d);
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void readConnectionsTypeFile() {
        int i = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(this.packagePath + CONNECTIONS_TYPE_FILE_NAME));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] tokens = line.split(" ");
                String[] goodTkns = new String[this.vertexNum.intValue()];
                int k = 0;
                int j = 0;
                while (k < this.vertexNum) {
                    if (!tokens[j].equals("")) {
                        goodTkns[k++] = tokens[j];
                    }
                    ++j;
                }
                for (j = 0; j < this.vertexNum; ++j) {
                    Integer d;
                    if (i == j || (d = new Integer(goodTkns[j])).equals(0)) continue;
                    this.rm.addType(i, j, d);
                }
                ++i;
            }
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Integer getVertexNum() {
        return this.vertexNum;
    }

    public Long getedgesNum() {
        return this.edgesNum;
    }

    public Double getMinNe_xn_ratio() {
        return this.minNe_xn_ratio;
    }

    public Double getMaxNe_xn_ratio() {
        return this.maxNe_xn_ratio;
    }

    private void println(String s) {
        if (verbose.booleanValue()) {
            System.out.println(TAG + s);
        }
    }
}

