/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.classworlds;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.classworlds.ClassWorldListener;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class ClassWorld {
    private Map<String, ClassRealm> realms;
    private final List<ClassWorldListener> listeners = new ArrayList<ClassWorldListener>();

    public ClassWorld(String realmId, ClassLoader classLoader) {
        this();
        try {
            this.newRealm(realmId, classLoader);
        }
        catch (DuplicateRealmException duplicateRealmException) {
            // empty catch block
        }
    }

    public ClassWorld() {
        this.realms = new LinkedHashMap<String, ClassRealm>();
    }

    public ClassRealm newRealm(String id) throws DuplicateRealmException {
        return this.newRealm(id, this.getClass().getClassLoader());
    }

    public synchronized ClassRealm newRealm(String id, ClassLoader classLoader) throws DuplicateRealmException {
        if (this.realms.containsKey(id)) {
            throw new DuplicateRealmException(this, id);
        }
        ClassRealm realm = new ClassRealm(this, id, classLoader);
        this.realms.put(id, realm);
        for (ClassWorldListener listener2 : this.listeners) {
            listener2.realmCreated(realm);
        }
        return realm;
    }

    public synchronized void disposeRealm(String id) throws NoSuchRealmException {
        ClassRealm realm = this.realms.remove(id);
        if (realm != null) {
            this.closeIfJava7(realm);
            for (ClassWorldListener listener2 : this.listeners) {
                listener2.realmDisposed(realm);
            }
        }
    }

    private void closeIfJava7(ClassRealm realm) {
        try {
            if (realm instanceof Closeable) {
                realm.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized ClassRealm getRealm(String id) throws NoSuchRealmException {
        if (this.realms.containsKey(id)) {
            return this.realms.get(id);
        }
        throw new NoSuchRealmException(this, id);
    }

    public synchronized Collection<ClassRealm> getRealms() {
        return Collections.unmodifiableList(new ArrayList<ClassRealm>(this.realms.values()));
    }

    public synchronized ClassRealm getClassRealm(String id) {
        if (this.realms.containsKey(id)) {
            return this.realms.get(id);
        }
        return null;
    }

    public synchronized void addListener(ClassWorldListener listener2) {
        if (!this.listeners.contains(listener2)) {
            this.listeners.add(listener2);
        }
    }

    public synchronized void removeListener(ClassWorldListener listener2) {
        this.listeners.remove(listener2);
    }
}

