/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.SynchronizedBag;
import org.eclipse.collections.impl.bag.mutable.UnmodifiableBag;
import org.eclipse.collections.impl.collection.mutable.AbstractMultiReaderMutableCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Iterables;
import org.eclipse.collections.impl.utility.LazyIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiReaderHashBag<T>
extends AbstractMultiReaderMutableCollection<T>
implements Externalizable,
MutableBag<T> {
    private static final long serialVersionUID = 1L;
    private transient ReadWriteLock lock;
    private MutableBag<T> delegate;

    @Deprecated
    public MultiReaderHashBag() {
    }

    private MultiReaderHashBag(MutableBag<T> newDelegate) {
        this(newDelegate, new ReentrantReadWriteLock());
    }

    private MultiReaderHashBag(MutableBag<T> newDelegate, ReadWriteLock newLock) {
        this.lock = newLock;
        this.delegate = newDelegate;
    }

    public static <T> MultiReaderHashBag<T> newBag() {
        return new MultiReaderHashBag(HashBag.newBag());
    }

    public static <T> MultiReaderHashBag<T> newBag(int capacity) {
        return new MultiReaderHashBag(HashBag.newBag(capacity));
    }

    public static <T> MultiReaderHashBag<T> newBag(Iterable<T> iterable) {
        return new MultiReaderHashBag<T>(HashBag.newBag(iterable));
    }

    public static <T> MultiReaderHashBag<T> newBagWith(T ... elements) {
        return new MultiReaderHashBag<T>(HashBag.newBagWith(elements));
    }

    @Override
    protected MutableBag<T> getDelegate() {
        return this.delegate;
    }

    @Override
    protected ReadWriteLock getLock() {
        return this.lock;
    }

    UntouchableMutableBag<T> asReadUntouchable() {
        return new UntouchableMutableBag(this.delegate.asUnmodifiable());
    }

    UntouchableMutableBag<T> asWriteUntouchable() {
        return new UntouchableMutableBag(this.delegate);
    }

    public void withReadLockAndDelegate(Procedure<MutableBag<T>> procedure) {
        this.acquireReadLock();
        try {
            UntouchableMutableBag<T> bag = this.asReadUntouchable();
            procedure.value(bag);
            bag.becomeUseless();
        }
        finally {
            this.unlockReadLock();
        }
    }

    public void withWriteLockAndDelegate(Procedure<MutableBag<T>> procedure) {
        this.acquireWriteLock();
        try {
            UntouchableMutableBag<T> bag = this.asWriteUntouchable();
            procedure.value(bag);
            bag.becomeUseless();
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public MutableBag<T> asSynchronized() {
        this.acquireReadLock();
        try {
            SynchronizedBag synchronizedBag = SynchronizedBag.of(this);
            return synchronizedBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableBag<T> asUnmodifiable() {
        this.acquireReadLock();
        try {
            UnmodifiableBag unmodifiableBag = UnmodifiableBag.of(this);
            return unmodifiableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public ImmutableBag<T> toImmutable() {
        this.acquireReadLock();
        try {
            ImmutableBag<T> immutableBag = Bags.immutable.withAll(this.delegate);
            return immutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public void addOccurrences(T item, int occurrences) {
        this.acquireWriteLock();
        try {
            this.delegate.addOccurrences(item, occurrences);
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeOccurrences(Object item, int occurrences) {
        this.acquireWriteLock();
        try {
            boolean bl = this.delegate.removeOccurrences(item, occurrences);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setOccurrences(T item, int occurrences) {
        this.acquireWriteLock();
        try {
            boolean bl = this.delegate.setOccurrences(item, occurrences);
            return bl;
        }
        finally {
            this.unlockWriteLock();
        }
    }

    @Override
    public int occurrencesOf(Object item) {
        this.acquireReadLock();
        try {
            int n = this.delegate.occurrencesOf(item);
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public int sizeDistinct() {
        this.acquireReadLock();
        try {
            int n = this.delegate.sizeDistinct();
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableBag<? extends V> mutableBag = this.delegate.collect(function);
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        this.acquireReadLock();
        try {
            MutableBooleanBag mutableBooleanBag = this.delegate.collectBoolean(booleanFunction);
            return mutableBooleanBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        this.acquireReadLock();
        try {
            MutableByteBag mutableByteBag = this.delegate.collectByte(byteFunction);
            return mutableByteBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
        this.acquireReadLock();
        try {
            MutableCharBag mutableCharBag = this.delegate.collectChar(charFunction);
            return mutableCharBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        this.acquireReadLock();
        try {
            MutableDoubleBag mutableDoubleBag = this.delegate.collectDouble(doubleFunction);
            return mutableDoubleBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        this.acquireReadLock();
        try {
            MutableFloatBag mutableFloatBag = this.delegate.collectFloat(floatFunction);
            return mutableFloatBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableIntBag collectInt(IntFunction<? super T> intFunction) {
        this.acquireReadLock();
        try {
            MutableIntBag mutableIntBag = this.delegate.collectInt(intFunction);
            return mutableIntBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
        this.acquireReadLock();
        try {
            MutableLongBag mutableLongBag = this.delegate.collectLong(longFunction);
            return mutableLongBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        this.acquireReadLock();
        try {
            MutableShortBag mutableShortBag = this.delegate.collectShort(shortFunction);
            return mutableShortBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        this.acquireReadLock();
        try {
            MutableBag mutableBag = this.delegate.flatCollect(function);
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableList<ObjectIntPair<T>> topOccurrences(int count2) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.topOccurrences(count2);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableList<ObjectIntPair<T>> bottomOccurrences(int count2) {
        this.acquireReadLock();
        try {
            MutableList mutableList = this.delegate.bottomOccurrences(count2);
            return mutableList;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableBag<? extends V> mutableBag = this.delegate.collectIf(predicate, function);
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        this.acquireReadLock();
        try {
            MutableBag<? extends V> mutableBag = this.delegate.collectWith(function, parameter);
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableBag<T> newEmpty() {
        return MultiReaderHashBag.newBag();
    }

    @Override
    public MutableBag<T> reject(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            MutableBag<? super T> mutableBag = this.delegate.reject(predicate);
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            MutableBag<? super T> mutableBag = this.delegate.rejectWith(predicate, parameter);
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableBag<T> tap(Procedure<? super T> procedure) {
        this.acquireReadLock();
        try {
            this.forEach(procedure);
            MultiReaderHashBag multiReaderHashBag = this;
            return multiReaderHashBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableBag<T> select(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            MutableBag<? super T> mutableBag = this.delegate.select(predicate);
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            MutableBag<? super T> mutableBag = this.delegate.selectWith(predicate, parameter);
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
        this.acquireReadLock();
        try {
            MutableBag<T> mutableBag = this.delegate.selectByOccurrences(predicate);
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        this.acquireReadLock();
        try {
            MutableBag<S> mutableBag = this.delegate.selectInstancesOf(clazz);
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
        this.acquireReadLock();
        try {
            PartitionMutableBag<? super T> partitionMutableBag = this.delegate.partition(predicate);
            return partitionMutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        this.acquireReadLock();
        try {
            PartitionMutableBag<? super T> partitionMutableBag = this.delegate.partitionWith(predicate, parameter);
            return partitionMutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public MutableBag<T> with(T element) {
        this.add(element);
        return this;
    }

    @Override
    public MutableBag<T> without(T element) {
        this.remove(element);
        return this;
    }

    @Override
    public MutableBag<T> withAll(Iterable<? extends T> elements) {
        this.addAllIterable(elements);
        return this;
    }

    @Override
    public MutableBag<T> withoutAll(Iterable<? extends T> elements) {
        this.removeAllIterable(elements);
        return this;
    }

    @Override
    public MutableMap<T, Integer> toMapOfItemToCount() {
        this.acquireReadLock();
        try {
            MutableMap<T, Integer> mutableMap = this.delegate.toMapOfItemToCount();
            return mutableMap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public String toStringOfItemToCount() {
        this.acquireReadLock();
        try {
            String string = this.delegate.toStringOfItemToCount();
            return string;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableBagMultimap<? extends V, ? super T> mutableBagMultimap = this.delegate.groupBy(function);
            return mutableBagMultimap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        this.acquireReadLock();
        try {
            MutableBagMultimap mutableBagMultimap = this.delegate.groupByEach(function);
            return mutableBagMultimap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        this.acquireReadLock();
        try {
            MutableMap<? extends V, ? super T> mutableMap = this.delegate.groupByUniqueKey(function);
            return mutableMap;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        this.acquireReadLock();
        try {
            MutableBag<Pair<T, S>> mutableBag = this.delegate.zip(that);
            return mutableBag;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        this.acquireReadLock();
        try {
            MutableSet<Pair<T, Integer>> mutableSet = this.delegate.zipWithIndex();
            return mutableSet;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size2) {
        this.acquireReadLock();
        try {
            RichIterable richIterable = this.delegate.chunk(size2);
            return richIterable;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public void forEachWithOccurrences(ObjectIntProcedure<? super T> procedure) {
        this.acquireReadLock();
        try {
            this.delegate.forEachWithOccurrences(procedure);
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public boolean equals(Object o) {
        this.acquireReadLock();
        try {
            boolean bl = this.delegate.equals(o);
            return bl;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public int hashCode() {
        this.acquireReadLock();
        try {
            int n = this.delegate.hashCode();
            return n;
        }
        finally {
            this.unlockReadLock();
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.delegate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = (MutableBag)in.readObject();
        this.lock = new ReentrantReadWriteLock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UntouchableIterator<T>
    implements Iterator<T> {
        private Iterator<T> delegate;

        private UntouchableIterator(Iterator<T> newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        public void becomeUseless() {
            this.delegate = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UntouchableMutableBag<T>
    extends AbstractMultiReaderMutableCollection.UntouchableMutableCollection<T>
    implements MutableBag<T> {
        private final MutableList<UntouchableIterator<T>> requestedIterators = Iterables.mList();

        private UntouchableMutableBag(MutableBag<T> newDelegate) {
            this.delegate = newDelegate;
        }

        public void becomeUseless() {
            this.delegate = null;
            this.requestedIterators.forEach(new Procedure<UntouchableIterator<T>>(){

                @Override
                public void value(UntouchableIterator<T> each2) {
                    each2.becomeUseless();
                }
            });
        }

        @Override
        public MutableBag<T> with(T element) {
            this.add(element);
            return this;
        }

        @Override
        public MutableBag<T> without(T element) {
            this.remove(element);
            return this;
        }

        @Override
        public MutableBag<T> withAll(Iterable<? extends T> elements) {
            this.addAllIterable(elements);
            return this;
        }

        @Override
        public MutableBag<T> withoutAll(Iterable<? extends T> elements) {
            this.removeAllIterable(elements);
            return this;
        }

        @Override
        public MutableBag<T> asSynchronized() {
            throw new UnsupportedOperationException("cannot wrap an UntouchableMutableBag");
        }

        @Override
        public MutableBag<T> asUnmodifiable() {
            throw new UnsupportedOperationException("cannot wrap an UntouchableMutableBag");
        }

        @Override
        public ImmutableBag<T> toImmutable() {
            return Bags.immutable.withAll(this.getDelegate());
        }

        @Override
        public LazyIterable<T> asLazy() {
            return LazyIterate.adapt(this);
        }

        @Override
        public Iterator<T> iterator() {
            UntouchableIterator iterator2 = new UntouchableIterator(this.delegate.iterator());
            this.requestedIterators.add(iterator2);
            return iterator2;
        }

        @Override
        public void addOccurrences(T item, int occurrences) {
            this.getDelegate().addOccurrences(item, occurrences);
        }

        @Override
        public boolean removeOccurrences(Object item, int occurrences) {
            return this.getDelegate().removeOccurrences(item, occurrences);
        }

        @Override
        public boolean setOccurrences(T item, int occurrences) {
            return this.getDelegate().setOccurrences(item, occurrences);
        }

        @Override
        public int occurrencesOf(Object item) {
            return this.getDelegate().occurrencesOf(item);
        }

        @Override
        public int sizeDistinct() {
            return this.getDelegate().sizeDistinct();
        }

        @Override
        public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
            return this.getDelegate().collect(function);
        }

        @Override
        public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
            return this.getDelegate().collectBoolean(booleanFunction);
        }

        @Override
        public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super T> booleanFunction, R target) {
            return this.getDelegate().collectBoolean(booleanFunction, target);
        }

        @Override
        public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
            return this.getDelegate().collectByte(byteFunction);
        }

        @Override
        public <R extends MutableByteCollection> R collectByte(ByteFunction<? super T> byteFunction, R target) {
            return this.getDelegate().collectByte(byteFunction, target);
        }

        @Override
        public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
            return this.getDelegate().collectChar(charFunction);
        }

        @Override
        public <R extends MutableCharCollection> R collectChar(CharFunction<? super T> charFunction, R target) {
            return this.getDelegate().collectChar(charFunction, target);
        }

        @Override
        public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
            return this.getDelegate().collectDouble(doubleFunction);
        }

        @Override
        public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super T> doubleFunction, R target) {
            return this.getDelegate().collectDouble(doubleFunction, target);
        }

        @Override
        public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
            return this.getDelegate().collectFloat(floatFunction);
        }

        @Override
        public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super T> floatFunction, R target) {
            return this.getDelegate().collectFloat(floatFunction, target);
        }

        @Override
        public MutableIntBag collectInt(IntFunction<? super T> intFunction) {
            return this.getDelegate().collectInt(intFunction);
        }

        @Override
        public <R extends MutableIntCollection> R collectInt(IntFunction<? super T> intFunction, R target) {
            return this.getDelegate().collectInt(intFunction, target);
        }

        @Override
        public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
            return this.getDelegate().collectLong(longFunction);
        }

        @Override
        public <R extends MutableLongCollection> R collectLong(LongFunction<? super T> longFunction, R target) {
            return this.getDelegate().collectLong(longFunction, target);
        }

        @Override
        public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
            return this.getDelegate().collectShort(shortFunction);
        }

        @Override
        public <R extends MutableShortCollection> R collectShort(ShortFunction<? super T> shortFunction, R target) {
            return this.getDelegate().collectShort(shortFunction, target);
        }

        @Override
        public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().flatCollect(function);
        }

        @Override
        public MutableList<ObjectIntPair<T>> topOccurrences(int count2) {
            return this.getDelegate().topOccurrences(count2);
        }

        @Override
        public MutableList<ObjectIntPair<T>> bottomOccurrences(int count2) {
            return this.getDelegate().bottomOccurrences(count2);
        }

        @Override
        public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
            return this.getDelegate().collectIf(predicate, function);
        }

        @Override
        public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
            return this.getDelegate().collectWith(function, parameter);
        }

        @Override
        public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupBy(function);
        }

        @Override
        public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().groupByEach(function);
        }

        @Override
        public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupByUniqueKey(function);
        }

        @Override
        public MutableBag<T> newEmpty() {
            return this.getDelegate().newEmpty();
        }

        @Override
        public MutableBag<T> reject(Predicate<? super T> predicate) {
            return this.getDelegate().reject(predicate);
        }

        @Override
        public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().rejectWith(predicate, parameter);
        }

        @Override
        public MutableBag<T> tap(Procedure<? super T> procedure) {
            this.forEach(procedure);
            return this;
        }

        @Override
        public MutableBag<T> select(Predicate<? super T> predicate) {
            return this.getDelegate().select(predicate);
        }

        @Override
        public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().selectWith(predicate, parameter);
        }

        @Override
        public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
            return this.getDelegate().selectByOccurrences(predicate);
        }

        @Override
        public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
            return this.getDelegate().selectInstancesOf(clazz);
        }

        @Override
        public void forEachWithOccurrences(ObjectIntProcedure<? super T> procedure) {
            this.getDelegate().forEachWithOccurrences(procedure);
        }

        @Override
        public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
            return this.getDelegate().partition(predicate);
        }

        @Override
        public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().partitionWith(predicate, parameter);
        }

        @Override
        @Deprecated
        public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
            return this.getDelegate().zip(that);
        }

        @Override
        @Deprecated
        public MutableSet<Pair<T, Integer>> zipWithIndex() {
            return this.getDelegate().zipWithIndex();
        }

        @Override
        public MutableMap<T, Integer> toMapOfItemToCount() {
            return this.getDelegate().toMapOfItemToCount();
        }

        @Override
        public String toStringOfItemToCount() {
            return this.getDelegate().toStringOfItemToCount();
        }

        private MutableBag<T> getDelegate() {
            return (MutableBag)this.delegate;
        }
    }
}

