/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.forkjoin;

import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.concurrent.ForkJoinPool;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.impl.block.procedure.MultimapPutProcedure;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.forkjoin.FJBatchIterableProcedureRunner;
import org.eclipse.collections.impl.forkjoin.FJListObjectIntProcedureRunner;
import org.eclipse.collections.impl.forkjoin.FJListProcedureRunner;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.eclipse.collections.impl.map.mutable.ConcurrentHashMap;
import org.eclipse.collections.impl.multimap.list.SynchronizedPutFastListMultimap;
import org.eclipse.collections.impl.parallel.BatchIterable;
import org.eclipse.collections.impl.parallel.CollectIfProcedureCombiner;
import org.eclipse.collections.impl.parallel.CollectIfProcedureFactory;
import org.eclipse.collections.impl.parallel.Combiner;
import org.eclipse.collections.impl.parallel.Combiners;
import org.eclipse.collections.impl.parallel.CountCombiner;
import org.eclipse.collections.impl.parallel.CountProcedureFactory;
import org.eclipse.collections.impl.parallel.FastListCollectProcedureCombiner;
import org.eclipse.collections.impl.parallel.FastListCollectProcedureFactory;
import org.eclipse.collections.impl.parallel.FlatCollectProcedureCombiner;
import org.eclipse.collections.impl.parallel.FlatCollectProcedureFactory;
import org.eclipse.collections.impl.parallel.ObjectIntProcedureFactory;
import org.eclipse.collections.impl.parallel.ParallelArrayIterate;
import org.eclipse.collections.impl.parallel.ParallelIterate;
import org.eclipse.collections.impl.parallel.PassThruCombiner;
import org.eclipse.collections.impl.parallel.PassThruObjectIntProcedureFactory;
import org.eclipse.collections.impl.parallel.PassThruProcedureFactory;
import org.eclipse.collections.impl.parallel.ProcedureFactory;
import org.eclipse.collections.impl.parallel.RejectProcedureCombiner;
import org.eclipse.collections.impl.parallel.RejectProcedureFactory;
import org.eclipse.collections.impl.parallel.SelectProcedureCombiner;
import org.eclipse.collections.impl.parallel.SelectProcedureFactory;
import org.eclipse.collections.impl.utility.Iterate;

public final class FJIterate {
    public static final int DEFAULT_MIN_FORK_SIZE = 5000;
    private static final int DEFAULT_PARALLEL_TASK_COUNT = ParallelIterate.getDefaultTaskCount() * 4;
    private static final ForkJoinPool FORK_JOIN_POOL = new ForkJoinPool(ParallelIterate.getDefaultMaxThreadPoolSize());

    private FJIterate() {
    }

    public static <T> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedure<? super T> procedure) {
        FJIterate.forEachWithIndex(iterable, procedure, FORK_JOIN_POOL);
    }

    public static <T, PT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, PT procedure, ForkJoinPool executor) {
        PassThruObjectIntProcedureFactory<PT> procedureFactory = new PassThruObjectIntProcedureFactory<PT>(procedure);
        PassThruCombiner combiner = new PassThruCombiner();
        FJIterate.forEachWithIndex(iterable, procedureFactory, combiner, executor);
    }

    public static <T, PT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, PT procedure, int minForkSize, int taskCount) {
        PassThruObjectIntProcedureFactory<PT> procedureFactory = new PassThruObjectIntProcedureFactory<PT>(procedure);
        PassThruCombiner combiner = new PassThruCombiner();
        FJIterate.forEachWithIndex(iterable, procedureFactory, combiner, minForkSize, taskCount);
    }

    public static <T, PT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, ForkJoinPool executor) {
        int taskCount = Math.max(DEFAULT_PARALLEL_TASK_COUNT, Iterate.sizeOf(iterable) / 5000);
        FJIterate.forEachWithIndex(iterable, procedureFactory, combiner, 5000, taskCount, executor);
    }

    public static <T, PT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount) {
        FJIterate.forEachWithIndex(iterable, procedureFactory, combiner, minForkSize, taskCount, FORK_JOIN_POOL);
    }

    public static <T, PT extends ObjectIntProcedure<? super T>> void forEachWithIndex(Iterable<T> iterable, ObjectIntProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount, ForkJoinPool executor) {
        if (Iterate.notEmpty(iterable)) {
            if ((iterable instanceof RandomAccess || iterable instanceof ListIterable) && iterable instanceof List) {
                FJIterate.forEachWithIndexInListOnExecutor((List)iterable, procedureFactory, combiner, minForkSize, taskCount, executor);
            } else {
                FJIterate.forEachWithIndexInListOnExecutor(ArrayAdapter.adapt(Iterate.toArray(iterable)), procedureFactory, combiner, minForkSize, taskCount, executor);
            }
        }
    }

    public static <T, PT extends ObjectIntProcedure<? super T>> void forEachWithIndexInListOnExecutor(List<T> list, ObjectIntProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount, ForkJoinPool executor) {
        int size2 = list.size();
        if (size2 < minForkSize || FJIterate.executedInsideOfForEach()) {
            PT procedure = procedureFactory.create();
            Iterate.forEachWithIndex(list, procedure);
            if (combiner.useCombineOne()) {
                combiner.combineOne(procedure);
            } else {
                combiner.combineAll(Lists.immutable.of(procedure));
            }
        } else {
            int threadCount = Math.min(size2, taskCount);
            new FJListObjectIntProcedureRunner<T, PT>(combiner, threadCount).executeAndCombine(executor, procedureFactory, list);
        }
    }

    public static <T> void forEach(Iterable<T> iterable, Procedure<? super T> procedure) {
        FJIterate.forEach(iterable, procedure, FORK_JOIN_POOL);
    }

    public static <T> void forEach(Iterable<T> iterable, Procedure<? super T> procedure, int batchSize) {
        FJIterate.forEach(iterable, procedure, batchSize, FORK_JOIN_POOL);
    }

    public static <T> void forEach(Iterable<T> iterable, Procedure<? super T> procedure, int batchSize, ForkJoinPool executor) {
        FJIterate.forEach(iterable, procedure, batchSize, FJIterate.calculateTaskCount(iterable, batchSize), executor);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, PT procedure, ForkJoinPool executor) {
        PassThruProcedureFactory<PT> procedureFactory = new PassThruProcedureFactory<PT>(procedure);
        PassThruCombiner combiner = new PassThruCombiner();
        FJIterate.forEach(iterable, procedureFactory, combiner, executor);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, PT procedure, int minForkSize, int taskCount) {
        FJIterate.forEach(iterable, procedure, minForkSize, taskCount, FORK_JOIN_POOL);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, PT procedure, int minForkSize, int taskCount, ForkJoinPool executor) {
        PassThruProcedureFactory<PT> procedureFactory = new PassThruProcedureFactory<PT>(procedure);
        PassThruCombiner combiner = new PassThruCombiner();
        FJIterate.forEach(iterable, procedureFactory, combiner, minForkSize, taskCount, executor);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, ForkJoinPool executor) {
        FJIterate.forEach(iterable, procedureFactory, combiner, 5000, executor);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner) {
        FJIterate.forEach(iterable, procedureFactory, combiner, FORK_JOIN_POOL);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int batchSize) {
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, FORK_JOIN_POOL);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<PT> blockFactory, Combiner<PT> combiner, int batchSize, ForkJoinPool executor) {
        FJIterate.forEach(iterable, blockFactory, combiner, batchSize, FJIterate.calculateTaskCount(iterable, batchSize), executor);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount) {
        FJIterate.forEach(iterable, procedureFactory, combiner, minForkSize, taskCount, FORK_JOIN_POOL);
    }

    public static <T, PT extends Procedure<? super T>> void forEach(Iterable<T> iterable, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount, ForkJoinPool executor) {
        if (Iterate.notEmpty(iterable)) {
            if ((iterable instanceof RandomAccess || iterable instanceof ListIterable) && iterable instanceof List) {
                FJIterate.forEachInListOnExecutor((List)iterable, procedureFactory, combiner, minForkSize, taskCount, executor);
            } else if (iterable instanceof BatchIterable) {
                FJIterate.forEachInBatchWithExecutor((BatchIterable)((Object)iterable), procedureFactory, combiner, minForkSize, taskCount, executor);
            } else {
                ParallelArrayIterate.forEachOn(Iterate.toArray(iterable), procedureFactory, combiner, minForkSize, taskCount, executor);
            }
        }
    }

    public static <T, PT extends Procedure<? super T>> void forEachInListOnExecutor(List<T> list, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount, ForkJoinPool executor) {
        int size2 = list.size();
        if (size2 < minForkSize || FJIterate.executedInsideOfForEach()) {
            PT procedure = procedureFactory.create();
            Iterate.forEach(list, procedure);
            if (combiner.useCombineOne()) {
                combiner.combineOne(procedure);
            } else {
                combiner.combineAll(Lists.immutable.of(procedure));
            }
        } else {
            int newTaskCount = Math.min(size2, taskCount);
            new FJListProcedureRunner<T, PT>(combiner, newTaskCount).executeAndCombine(executor, procedureFactory, list);
        }
    }

    public static <T, PT extends Procedure<? super T>> void forEachInBatchWithExecutor(BatchIterable<T> batchIterable, ProcedureFactory<PT> procedureFactory, Combiner<PT> combiner, int minForkSize, int taskCount, ForkJoinPool executor) {
        int size2 = batchIterable.size();
        if (size2 < minForkSize || FJIterate.executedInsideOfForEach()) {
            PT procedure = procedureFactory.create();
            batchIterable.forEach((Procedure<T>)procedure);
            if (combiner.useCombineOne()) {
                combiner.combineOne(procedure);
            } else {
                combiner.combineAll(Lists.immutable.of(procedure));
            }
        } else {
            int newTaskCount = Math.min(size2, Math.min(taskCount, batchIterable.getBatchCount((int)Math.ceil((double)size2 / (double)taskCount))));
            new FJBatchIterableProcedureRunner<T, PT>(combiner, newTaskCount).executeAndCombine(executor, procedureFactory, batchIterable);
        }
    }

    static boolean executedInsideOfForEach() {
        return Thread.currentThread().getName().startsWith("ForkJoinPool");
    }

    public static <T> Collection<T> select(Iterable<T> iterable, Predicate<? super T> predicate) {
        return FJIterate.select(iterable, predicate, false);
    }

    public static <T> Collection<T> select(Iterable<T> iterable, Predicate<? super T> predicate, boolean allowReorderedResult) {
        return FJIterate.select(iterable, predicate, null, allowReorderedResult);
    }

    public static <T, R extends Collection<T>> R select(Iterable<T> iterable, Predicate<? super T> predicate, R target, boolean allowReorderedResult) {
        return FJIterate.select(iterable, predicate, target, 5000, FORK_JOIN_POOL, allowReorderedResult);
    }

    public static <T, R extends Collection<T>> R select(Iterable<T> iterable, Predicate<? super T> predicate, R target, int batchSize, ForkJoinPool executor, boolean allowReorderedResult) {
        SelectProcedureCombiner<T> combiner = new SelectProcedureCombiner<T>(iterable, target, 10, allowReorderedResult);
        SelectProcedureFactory<? super T> procedureFactory = new SelectProcedureFactory<T>(predicate, batchSize);
        int taskCount = FJIterate.calculateTaskCount(iterable, batchSize);
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, taskCount, executor);
        return (R)combiner.getResult();
    }

    private static <T> int calculateTaskCount(Iterable<T> iterable, int batchSize) {
        if (iterable instanceof BatchIterable) {
            return FJIterate.calculateTaskCount((BatchIterable)((Object)iterable), batchSize);
        }
        return FJIterate.calculateTaskCount(Iterate.sizeOf(iterable), batchSize);
    }

    private static <T> int calculateTaskCount(BatchIterable<T> batchIterable, int batchSize) {
        return Math.max(2, batchIterable.getBatchCount(batchSize));
    }

    private static int calculateTaskCount(int size2, int batchSize) {
        return Math.max(2, size2 / batchSize);
    }

    public static <T> Collection<T> reject(Iterable<T> iterable, Predicate<? super T> predicate) {
        return FJIterate.reject(iterable, predicate, false);
    }

    public static <T> Collection<T> reject(Iterable<T> iterable, Predicate<? super T> predicate, boolean allowReorderedResult) {
        return FJIterate.reject(iterable, predicate, null, allowReorderedResult);
    }

    public static <T, R extends Collection<T>> R reject(Iterable<T> iterable, Predicate<? super T> predicate, R target, boolean allowReorderedResult) {
        return FJIterate.reject(iterable, predicate, target, 5000, FORK_JOIN_POOL, allowReorderedResult);
    }

    public static <T, R extends Collection<T>> R reject(Iterable<T> iterable, Predicate<? super T> predicate, R target, int batchSize, ForkJoinPool executor, boolean allowReorderedResult) {
        RejectProcedureCombiner<T> combiner = new RejectProcedureCombiner<T>(iterable, target, 10, allowReorderedResult);
        RejectProcedureFactory<? super T> procedureFactory = new RejectProcedureFactory<T>(predicate, batchSize);
        int taskCount = FJIterate.calculateTaskCount(iterable, batchSize);
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, taskCount, executor);
        return (R)combiner.getResult();
    }

    public static <T> int count(Iterable<T> iterable, Predicate<? super T> predicate) {
        return FJIterate.count(iterable, predicate, 5000, FORK_JOIN_POOL);
    }

    public static <T> int count(Iterable<T> iterable, Predicate<? super T> predicate, int batchSize, ForkJoinPool executor) {
        CountCombiner combiner = new CountCombiner();
        CountProcedureFactory<? super T> procedureFactory = new CountProcedureFactory<T>(predicate);
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, executor);
        return combiner.getCount();
    }

    public static <T, V> Collection<V> collect(Iterable<T> iterable, Function<? super T, V> function) {
        return FJIterate.collect(iterable, function, false);
    }

    public static <T, V> Collection<V> collect(Iterable<T> iterable, Function<? super T, V> function, boolean allowReorderedResult) {
        return FJIterate.collect(iterable, function, null, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R collect(Iterable<T> iterable, Function<? super T, V> function, R target, boolean allowReorderedResult) {
        return FJIterate.collect(iterable, function, target, 5000, FORK_JOIN_POOL, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R collect(Iterable<T> iterable, Function<? super T, V> function, R target, int batchSize, ForkJoinPool executor, boolean allowReorderedResult) {
        int size2 = Iterate.sizeOf(iterable);
        FastListCollectProcedureCombiner combiner = new FastListCollectProcedureCombiner(iterable, target, size2, allowReorderedResult);
        int taskCount = FJIterate.calculateTaskCount(size2, batchSize);
        FastListCollectProcedureFactory<? super T, V> procedureFactory = new FastListCollectProcedureFactory<T, V>(function, size2 / taskCount);
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, taskCount, executor);
        return (R)combiner.getResult();
    }

    public static <T, V> Collection<V> flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function) {
        return FJIterate.flatCollect(iterable, function, false);
    }

    public static <T, V> Collection<V> flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function, boolean allowReorderedResult) {
        return FJIterate.flatCollect(iterable, function, null, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function, R target, boolean allowReorderedResult) {
        return FJIterate.flatCollect(iterable, function, target, 5000, FORK_JOIN_POOL, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R flatCollect(Iterable<T> iterable, Function<? super T, ? extends Iterable<V>> function, R target, int batchSize, ForkJoinPool executor, boolean allowReorderedResult) {
        int size2 = Iterate.sizeOf(iterable);
        int taskSize = size2 / DEFAULT_PARALLEL_TASK_COUNT;
        FlatCollectProcedureCombiner combiner = new FlatCollectProcedureCombiner(iterable, target, size2, allowReorderedResult);
        FlatCollectProcedureFactory procedureFactory = new FlatCollectProcedureFactory(function, taskSize);
        int taskCount = FJIterate.calculateTaskCount(size2, batchSize);
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, taskCount, executor);
        return (R)combiner.getResult();
    }

    public static <T, V> Collection<V> collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, V> function) {
        return FJIterate.collectIf(iterable, predicate, function, false);
    }

    public static <T, V> Collection<V> collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, V> function, boolean allowReorderedResult) {
        return FJIterate.collectIf(iterable, predicate, function, null, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, V> function, R target, boolean allowReorderedResult) {
        return FJIterate.collectIf(iterable, predicate, function, target, 5000, FORK_JOIN_POOL, allowReorderedResult);
    }

    public static <T, V, R extends Collection<V>> R collectIf(Iterable<T> iterable, Predicate<? super T> predicate, Function<? super T, V> function, R target, int batchSize, ForkJoinPool executor, boolean allowReorderedResult) {
        CollectIfProcedureCombiner combiner = new CollectIfProcedureCombiner(iterable, target, 10, allowReorderedResult);
        CollectIfProcedureFactory<? super T, V> procedureFactory = new CollectIfProcedureFactory<T, V>(function, predicate, batchSize);
        FJIterate.forEach(iterable, procedureFactory, combiner, batchSize, FJIterate.calculateTaskCount(iterable, batchSize), executor);
        return (R)combiner.getResult();
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        return FJIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, 5000);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, R mutableMap) {
        return FJIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, mutableMap, 5000);
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, int batchSize) {
        return FJIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, batchSize, FORK_JOIN_POOL);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, R mutableMap, int batchSize) {
        return FJIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, mutableMap, batchSize, FORK_JOIN_POOL);
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, int batchSize, ForkJoinPool executor) {
        return FJIterate.aggregateBy(iterable, groupBy, zeroValueFactory, nonMutatingAggregator, ConcurrentHashMap.newMap(), batchSize, executor);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator, R mutableMap, int batchSize, ForkJoinPool executor) {
        NonMutatingAggregationProcedure<? super T, ? extends K, ? extends V> nonMutatingAggregationProcedure = new NonMutatingAggregationProcedure<T, K, V>(mutableMap, groupBy, zeroValueFactory, nonMutatingAggregator);
        FJIterate.forEach(iterable, new PassThruProcedureFactory<NonMutatingAggregationProcedure<? super T, ? extends K, ? extends V>>(nonMutatingAggregationProcedure), Combiners.passThru(), batchSize, executor);
        return mutableMap;
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        return FJIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator, 5000);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, R mutableMap) {
        return FJIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator, mutableMap, 5000);
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, int batchSize) {
        return FJIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator, batchSize, FORK_JOIN_POOL);
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, R mutableMap, int batchSize) {
        return FJIterate.aggregateInPlaceBy(iterable, groupBy, zeroValueFactory, mutatingAggregator, mutableMap, batchSize, FORK_JOIN_POOL);
    }

    public static <T, K, V> MutableMap<K, V> aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, int batchSize, ForkJoinPool executor) {
        ConcurrentHashMap map2 = ConcurrentHashMap.newMap();
        MutatingAggregationProcedure<? super T, ? extends K, ? super V> mutatingAggregationProcedure = new MutatingAggregationProcedure<T, K, V>(map2, groupBy, zeroValueFactory, mutatingAggregator);
        FJIterate.forEach(iterable, new PassThruProcedureFactory<MutatingAggregationProcedure<? super T, ? extends K, ? super V>>(mutatingAggregationProcedure), Combiners.passThru(), batchSize, executor);
        return map2;
    }

    public static <T, K, V, R extends MutableMap<K, V>> R aggregateInPlaceBy(Iterable<T> iterable, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator, R mutableMap, int batchSize, ForkJoinPool executor) {
        MutatingAggregationProcedure<? super T, ? extends K, ? super V> mutatingAggregationProcedure = new MutatingAggregationProcedure<T, K, V>(mutableMap, groupBy, zeroValueFactory, mutatingAggregator);
        FJIterate.forEach(iterable, new PassThruProcedureFactory<MutatingAggregationProcedure<? super T, ? extends K, ? super V>>(mutatingAggregationProcedure), Combiners.passThru(), batchSize, executor);
        return mutableMap;
    }

    public static <K, V> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function) {
        return FJIterate.groupBy(iterable, function, 5000, FORK_JOIN_POOL);
    }

    public static <K, V, R extends MutableMultimap<K, V>> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, R concurrentMultimap) {
        return FJIterate.groupBy(iterable, function, concurrentMultimap, 5000);
    }

    public static <K, V, R extends MutableMultimap<K, V>> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, R concurrentMultimap, int batchSize) {
        return FJIterate.groupBy(iterable, function, concurrentMultimap, batchSize, FORK_JOIN_POOL);
    }

    public static <K, V> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, int batchSize) {
        return FJIterate.groupBy(iterable, function, batchSize, FORK_JOIN_POOL);
    }

    public static <K, V> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, int batchSize, ForkJoinPool executor) {
        return FJIterate.groupBy(iterable, function, SynchronizedPutFastListMultimap.newMultimap(), batchSize, executor);
    }

    public static <K, V, R extends MutableMultimap<K, V>> MutableMultimap<K, V> groupBy(Iterable<V> iterable, Function<? super V, ? extends K> function, R concurrentMultimap, int batchSize, ForkJoinPool executor) {
        FJIterate.forEach(iterable, new PassThruProcedureFactory<MultimapPutProcedure<? extends K, ? super V>>(new MultimapPutProcedure<K, V>(concurrentMultimap, function)), Combiners.passThru(), batchSize, executor);
        return concurrentMultimap;
    }
}

