/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.block.procedure.AdaptObjectIntProcedureToProcedure;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.lazy.iterator.DistinctIterator;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.utility.Iterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class DistinctIterable<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;

    public DistinctIterable(Iterable<T> newAdapted) {
        this.adapted = newAdapted;
    }

    @Override
    public LazyIterable<T> distinct() {
        return this;
    }

    @Override
    public void each(final Procedure<? super T> procedure) {
        final UnifiedSet seenSoFar = UnifiedSet.newSet();
        Iterate.forEach(this.adapted, new Procedure<T>(){

            @Override
            public void value(T each2) {
                if (seenSoFar.add(each2)) {
                    procedure.value(each2);
                }
            }
        });
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        this.each(new AdaptObjectIntProcedureToProcedure<T>(objectIntProcedure));
    }

    @Override
    public boolean anySatisfy(final Predicate<? super T> predicate) {
        final UnifiedSet seenSoFar = UnifiedSet.newSet();
        return Iterate.anySatisfy(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                return seenSoFar.add(each2) && predicate.accept(each2);
            }
        });
    }

    @Override
    public boolean allSatisfy(final Predicate<? super T> predicate) {
        final UnifiedSet seenSoFar = UnifiedSet.newSet();
        return Iterate.allSatisfy(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                return !seenSoFar.add(each2) || predicate.accept(each2);
            }
        });
    }

    @Override
    public boolean noneSatisfy(final Predicate<? super T> predicate) {
        final UnifiedSet seenSoFar = UnifiedSet.newSet();
        return Iterate.allSatisfy(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                return !seenSoFar.add(each2) || !predicate.accept(each2);
            }
        });
    }

    @Override
    public T detect(final Predicate<? super T> predicate) {
        final UnifiedSet seenSoFar = UnifiedSet.newSet();
        return Iterate.detect(this.adapted, new Predicate<T>(){

            @Override
            public boolean accept(T each2) {
                return seenSoFar.add(each2) && predicate.accept(each2);
            }
        });
    }

    @Override
    public Iterator<T> iterator() {
        return new DistinctIterator<T>(this.adapted);
    }
}

