/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy;

import java.util.Collection;
import java.util.Iterator;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.impl.UnmodifiableIteratorAdapter;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.utility.Iterate;
import org.eclipse.collections.impl.utility.LazyIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public class LazyIterableAdapter<T>
extends AbstractLazyIterable<T> {
    private final Iterable<T> adapted;

    public LazyIterableAdapter(Iterable<T> newAdapted) {
        this.adapted = newAdapted;
    }

    @Override
    public void each(Procedure<? super T> procedure) {
        Iterate.forEach(this.adapted, procedure);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        Iterate.forEachWithIndex(this.adapted, objectIntProcedure);
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        Iterate.forEachWith(this.adapted, procedure, parameter);
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIteratorAdapter<T>(this.adapted.iterator());
    }

    @Override
    public <R extends Collection<T>> R into(R target) {
        Iterate.addAllIterable(this.adapted, target);
        return target;
    }

    @Override
    public LazyIterable<T> select(Predicate<? super T> predicate) {
        return LazyIterate.select(this.adapted, predicate);
    }

    @Override
    public LazyIterable<T> reject(Predicate<? super T> predicate) {
        return LazyIterate.reject(this.adapted, predicate);
    }

    @Override
    public <V> LazyIterable<V> collect(Function<? super T, ? extends V> function) {
        return LazyIterate.collect(this.adapted, function);
    }

    @Override
    public <V> LazyIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return LazyIterate.flatCollect(this.adapted, function);
    }

    @Override
    public <V> LazyIterable<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return LazyIterate.collectIf(this.adapted, predicate, function);
    }

    @Override
    public LazyIterable<T> take(int count2) {
        return LazyIterate.take(this.adapted, count2);
    }

    @Override
    public LazyIterable<T> drop(int count2) {
        return LazyIterate.drop(this.adapted, count2);
    }

    @Override
    public LazyIterable<T> distinct() {
        return LazyIterate.distinct(this.adapted);
    }

    @Override
    public Object[] toArray() {
        return Iterate.toArray(this.adapted);
    }

    @Override
    public int size() {
        return Iterate.sizeOf(this.adapted);
    }

    @Override
    public boolean isEmpty() {
        return Iterate.isEmpty(this.adapted);
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return Iterate.anySatisfy(this.adapted, predicate);
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return Iterate.allSatisfy(this.adapted, predicate);
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return Iterate.noneSatisfy(this.adapted, predicate);
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return Iterate.anySatisfyWith(this.adapted, predicate, parameter);
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return Iterate.allSatisfyWith(this.adapted, predicate, parameter);
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return Iterate.noneSatisfyWith(this.adapted, predicate, parameter);
    }

    @Override
    public T getFirst() {
        return Iterate.getFirst(this.adapted);
    }

    @Override
    public T getLast() {
        return Iterate.getLast(this.adapted);
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return Iterate.detect(this.adapted, predicate);
    }

    @Override
    public <P> T detectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return Iterate.detectWith(this.adapted, predicate, parameter);
    }
}

