/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.parallel.list;

import org.eclipse.collections.api.annotation.Beta;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.list.ParallelListIterable;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.multimap.list.ListMultimap;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.lazy.parallel.AbstractParallelIterable;
import org.eclipse.collections.impl.lazy.parallel.list.ListBatch;
import org.eclipse.collections.impl.lazy.parallel.list.ParallelCollectListIterable;
import org.eclipse.collections.impl.lazy.parallel.list.ParallelDistinctListIterable;
import org.eclipse.collections.impl.lazy.parallel.list.ParallelFlatCollectListIterable;
import org.eclipse.collections.impl.lazy.parallel.list.ParallelSelectListIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Beta
public abstract class AbstractParallelListIterable<T, B extends ListBatch<T>>
extends AbstractParallelIterable<T, B>
implements ParallelListIterable<T> {
    @Override
    protected boolean isOrdered() {
        return true;
    }

    @Override
    public ParallelUnsortedSetIterable<T> asUnique() {
        return new ParallelDistinctListIterable(this);
    }

    @Override
    public ParallelListIterable<T> select(Predicate<? super T> predicate) {
        return new ParallelSelectListIterable<T>(this, predicate);
    }

    @Override
    public <P> ParallelListIterable<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <S> ParallelListIterable<S> selectInstancesOf(Class<S> clazz) {
        return this.select(Predicates.instanceOf(clazz));
    }

    @Override
    public ParallelListIterable<T> reject(Predicate<? super T> predicate) {
        return this.select(Predicates.not(predicate));
    }

    @Override
    public <P> ParallelListIterable<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public <V> ParallelListIterable<V> collect(Function<? super T, ? extends V> function) {
        return new ParallelCollectListIterable<T, V>(this, function);
    }

    @Override
    public <P, V> ParallelListIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collect((Function)Functions.bind(function, parameter));
    }

    @Override
    public <V> ParallelListIterable<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return this.select((Predicate)predicate).collect(function);
    }

    @Override
    public <V> ParallelListIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return new ParallelFlatCollectListIterable(this, function);
    }

    @Override
    public <V> ListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.toList().groupBy(function);
    }

    @Override
    public <V> ListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.toList().groupByEach(function);
    }

    @Override
    public <V> MapIterable<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.toList().groupByUniqueKey(function);
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public <E> E[] toArray(E[] array) {
        return this.toList().toArray(array);
    }
}

