/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.block.function.primitive.LongToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectLongToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoubleLongPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongPredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleLongProcedure;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.map.primitive.DoubleLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleLongMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleLongMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.DoubleLongPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedDoubleLongProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableLongCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableLongIterator;
import org.eclipse.collections.impl.map.mutable.primitive.DoubleLongHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableDoubleSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableDoubleLongHashMap
implements ImmutableDoubleLongMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableDoubleLongMap delegate;

    ImmutableDoubleLongHashMap(DoubleLongMap delegate) {
        this.delegate = new DoubleLongHashMap(delegate);
    }

    @Override
    public long get(double key) {
        return this.delegate.get(key);
    }

    @Override
    public long getIfAbsent(double key, long ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public long getOrThrow(double key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(double key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(long value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(LongProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(DoubleProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(DoubleLongProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyDoubleIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<DoubleLongPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableDoubleLongMap select(DoubleLongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableDoubleLongMap reject(DoubleLongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectLongToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableDoubleLongMap toImmutable() {
        return this;
    }

    @Override
    public LongIterator longIterator() {
        return new UnmodifiableLongIterator(this.delegate.longIterator());
    }

    @Override
    public void forEach(LongProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(LongProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(LongPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(LongPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(LongPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(LongPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableLongCollection select(LongPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableLongCollection reject(LongPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public long detectIfNone(LongPredicate predicate, long ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableCollection<V> collect(LongToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public long max() {
        return this.delegate.max();
    }

    @Override
    public long maxIfEmpty(long defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public long min() {
        return this.delegate.min();
    }

    @Override
    public long minIfEmpty(long defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public long[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableLongList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public long[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(long value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(long ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(LongIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableLongList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableLongSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableLongBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyLongIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableDoubleLongMap newWithKeyValue(double key, long value) {
        DoubleLongHashMap map2 = new DoubleLongHashMap(this.size() + 1);
        map2.putAll(this);
        map2.put(key, value);
        return map2.toImmutable();
    }

    @Override
    public ImmutableDoubleLongMap newWithoutKey(double key) {
        DoubleLongHashMap map2 = new DoubleLongHashMap(this.size());
        map2.putAll(this);
        map2.removeKey(key);
        return map2.toImmutable();
    }

    @Override
    public ImmutableDoubleLongMap newWithoutAllKeys(DoubleIterable keys) {
        DoubleLongHashMap map2 = new DoubleLongHashMap(this.size());
        map2.putAll(this);
        DoubleIterator iterator2 = keys.doubleIterator();
        while (iterator2.hasNext()) {
            map2.removeKey(iterator2.next());
        }
        return map2.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableDoubleSet keySet() {
        return UnmodifiableDoubleSet.of(this.delegate.keySet());
    }

    @Override
    public MutableLongCollection values() {
        return UnmodifiableLongCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableDoubleLongMapSerializationProxy(this);
    }

    protected static class ImmutableDoubleLongMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private DoubleLongMap map;

        public ImmutableDoubleLongMapSerializationProxy() {
        }

        protected ImmutableDoubleLongMapSerializationProxy(DoubleLongMap map2) {
            this.map = map2;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedDoubleLongProcedure(){

                    public void safeValue(double key, long value) throws IOException {
                        out.writeDouble(key);
                        out.writeLong(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size2 = in.readInt();
            DoubleLongHashMap deserializedMap = new DoubleLongHashMap();
            for (int i = 0; i < size2; ++i) {
                deserializedMap.put(in.readDouble(), in.readLong());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

