/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.sorted.immutable;

import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.sorted.ImmutableSortedMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.list.ImmutableListMultimap;
import org.eclipse.collections.api.multimap.sortedset.ImmutableSortedSetMultimap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.partition.list.PartitionImmutableList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.PartitionPredicate2Procedure;
import org.eclipse.collections.impl.block.procedure.PartitionProcedure;
import org.eclipse.collections.impl.block.procedure.SelectInstancesOfProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectBooleanProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectByteProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectCharProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectDoubleProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectFloatProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectIntProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectLongProcedure;
import org.eclipse.collections.impl.block.procedure.primitive.CollectShortProcedure;
import org.eclipse.collections.impl.factory.SortedMaps;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.AbstractMapIterable;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.map.sorted.mutable.TreeSortedMap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.partition.list.PartitionFastList;
import org.eclipse.collections.impl.utility.MapIterate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public abstract class AbstractImmutableSortedMap<K, V>
extends AbstractMapIterable<K, V>
implements ImmutableSortedMap<K, V>,
SortedMap<K, V> {
    @Override
    public SortedMap<K, V> castToMap() {
        return this;
    }

    @Override
    public SortedMap<K, V> castToSortedMap() {
        return this;
    }

    @Override
    public MutableSortedMap<K, V> toSortedMap() {
        return TreeSortedMap.newMap(this);
    }

    @Override
    public ImmutableSortedMap<K, V> toImmutable() {
        return this;
    }

    @Override
    public Iterator<V> iterator() {
        return this.valuesView().iterator();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map2) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    @Override
    public ImmutableSortedMap<K, V> newWithKeyValue(K key, V value) {
        TreeSortedMap<K, V> sortedMap = TreeSortedMap.newMap(this);
        sortedMap.put(key, value);
        return sortedMap.toImmutable();
    }

    @Override
    public ImmutableSortedMap<K, V> newWithAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> keyValues) {
        TreeSortedMap<K, V> sortedMap = TreeSortedMap.newMap(this);
        for (Pair<K, V> keyValuePair : keyValues) {
            sortedMap.put(keyValuePair.getOne(), keyValuePair.getTwo());
        }
        return sortedMap.toImmutable();
    }

    @Override
    public ImmutableSortedMap<K, V> newWithAllKeyValueArguments(Pair<? extends K, ? extends V> ... keyValuePairs) {
        TreeSortedMap<K, V> sortedMap = TreeSortedMap.newMap(this);
        for (Pair<K, V> pair : keyValuePairs) {
            sortedMap.put(pair.getOne(), pair.getTwo());
        }
        return sortedMap.toImmutable();
    }

    @Override
    public ImmutableSortedMap<K, V> newWithoutKey(K key) {
        TreeSortedMap sortedMap = TreeSortedMap.newMap(this);
        sortedMap.removeKey(key);
        return sortedMap.toImmutable();
    }

    @Override
    public ImmutableSortedMap<K, V> newWithoutAllKeys(Iterable<? extends K> keys) {
        TreeSortedMap sortedMap = TreeSortedMap.newMap(this);
        for (K key : keys) {
            sortedMap.removeKey(key);
        }
        return sortedMap.toImmutable();
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    @Override
    public ImmutableSortedSetMultimap<V, K> flip() {
        return MapIterate.flip(this).toImmutable();
    }

    @Override
    public ImmutableSortedMap<K, V> tap(Procedure<? super V> procedure) {
        this.forEach(procedure);
        return this;
    }

    @Override
    public ImmutableList<V> select(Predicate<? super V> predicate) {
        return this.select(predicate, FastList.newList(this.size())).toImmutable();
    }

    @Override
    public <P> ImmutableList<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.select((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public ImmutableSortedMap<K, V> select(final Predicate2<? super K, ? super V> predicate) {
        final MutableSortedMap selectedMap = SortedMaps.mutable.with(this.comparator());
        this.forEachKeyValue(new Procedure2<K, V>(){

            @Override
            public void value(K key, V value) {
                if (predicate.accept(key, value)) {
                    selectedMap.put(key, value);
                }
            }
        });
        return selectedMap.toImmutable();
    }

    @Override
    public ImmutableList<V> reject(Predicate<? super V> predicate) {
        return this.reject(predicate, FastList.newList(this.size())).toImmutable();
    }

    @Override
    public <P> ImmutableList<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.reject((Predicate)Predicates.bind(predicate, parameter));
    }

    @Override
    public ImmutableSortedMap<K, V> reject(final Predicate2<? super K, ? super V> predicate) {
        final MutableSortedMap rejectedMap = SortedMaps.mutable.with(this.comparator());
        this.forEachKeyValue(new Procedure2<K, V>(){

            @Override
            public void value(K key, V value) {
                if (!predicate.accept(key, value)) {
                    rejectedMap.put(key, value);
                }
            }
        });
        return rejectedMap.toImmutable();
    }

    @Override
    public PartitionImmutableList<V> partition(Predicate<? super V> predicate) {
        PartitionFastList partitionFastList = new PartitionFastList();
        this.forEach(new PartitionProcedure<V>(predicate, partitionFastList));
        return partitionFastList.toImmutable();
    }

    @Override
    public <P> PartitionImmutableList<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        PartitionFastList partitionFastList = new PartitionFastList();
        this.forEach(new PartitionPredicate2Procedure<V, P>(predicate, parameter, partitionFastList));
        return partitionFastList.toImmutable();
    }

    @Override
    public <S> ImmutableList<S> selectInstancesOf(Class<S> clazz) {
        FastList result = FastList.newList(this.size());
        this.forEach(new SelectInstancesOfProcedure<S>(clazz, result));
        return result.toImmutable();
    }

    @Override
    public <R> ImmutableList<R> collect(Function<? super V, ? extends R> function) {
        return this.collect(function, FastList.newList(this.size())).toImmutable();
    }

    @Override
    public ImmutableBooleanList collectBoolean(BooleanFunction<? super V> booleanFunction) {
        BooleanArrayList result = new BooleanArrayList(this.size());
        this.forEach(new CollectBooleanProcedure<V>(booleanFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableByteList collectByte(ByteFunction<? super V> byteFunction) {
        ByteArrayList result = new ByteArrayList(this.size());
        this.forEach(new CollectByteProcedure<V>(byteFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableCharList collectChar(CharFunction<? super V> charFunction) {
        CharArrayList result = new CharArrayList(this.size());
        this.forEach(new CollectCharProcedure<V>(charFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableDoubleList collectDouble(DoubleFunction<? super V> doubleFunction) {
        DoubleArrayList result = new DoubleArrayList(this.size());
        this.forEach(new CollectDoubleProcedure<V>(doubleFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableFloatList collectFloat(FloatFunction<? super V> floatFunction) {
        FloatArrayList result = new FloatArrayList(this.size());
        this.forEach(new CollectFloatProcedure<V>(floatFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableIntList collectInt(IntFunction<? super V> intFunction) {
        IntArrayList result = new IntArrayList(this.size());
        this.forEach(new CollectIntProcedure<V>(intFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableLongList collectLong(LongFunction<? super V> longFunction) {
        LongArrayList result = new LongArrayList(this.size());
        this.forEach(new CollectLongProcedure<V>(longFunction, result));
        return result.toImmutable();
    }

    @Override
    public ImmutableShortList collectShort(ShortFunction<? super V> shortFunction) {
        ShortArrayList result = new ShortArrayList(this.size());
        this.forEach(new CollectShortProcedure<V>(shortFunction, result));
        return result.toImmutable();
    }

    @Override
    public <K2, V2> ImmutableMap<K2, V2> collect(final Function2<? super K, ? super V, Pair<K2, V2>> function) {
        final UnifiedMap collectedMap = UnifiedMap.newMap(this.size());
        this.forEachKeyValue(new Procedure2<K, V>(){

            @Override
            public void value(K key, V value) {
                collectedMap.add((Pair)function.value(key, value));
            }
        });
        return collectedMap.toImmutable();
    }

    @Override
    public <P, VV> ImmutableList<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        return this.collect(Functions.bind(function, parameter));
    }

    @Override
    public <R> ImmutableList<R> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends R> function) {
        return this.collectIf(predicate, function, FastList.newList(this.size())).toImmutable();
    }

    @Override
    public <R> ImmutableSortedMap<K, R> collectValues(final Function2<? super K, ? super V, ? extends R> function) {
        final MutableSortedMap collectedMap = SortedMaps.mutable.with(this.comparator());
        this.forEachKeyValue(new Procedure2<K, V>(){

            @Override
            public void value(K key, V value) {
                collectedMap.put(key, function.value(key, value));
            }
        });
        return collectedMap.toImmutable();
    }

    @Override
    public Pair<K, V> detect(final Predicate2<? super K, ? super V> predicate) {
        return this.keyValuesView().detect(new Predicate<Pair<K, V>>(){

            @Override
            public boolean accept(Pair<K, V> each2) {
                return predicate.accept(each2.getOne(), each2.getTwo());
            }
        });
    }

    @Override
    public <R> ImmutableList<R> flatCollect(Function<? super V, ? extends Iterable<R>> function) {
        return this.flatCollect(function, FastList.newList(this.size())).toImmutable();
    }

    @Override
    public <S> ImmutableList<Pair<V, S>> zip(Iterable<S> that) {
        return this.zip(that, FastList.newList(this.size())).toImmutable();
    }

    @Override
    public ImmutableList<Pair<V, Integer>> zipWithIndex() {
        return this.zipWithIndex(FastList.newList(this.size())).toImmutable();
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".subMap() not implemented yet");
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".headMap() not implemented yet");
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".tailMap() not implemented yet");
    }

    @Override
    public <R> ImmutableListMultimap<R, V> groupBy(Function<? super V, ? extends R> function) {
        return this.groupBy(function, FastListMultimap.newMultimap()).toImmutable();
    }

    @Override
    public <R> ImmutableListMultimap<R, V> groupByEach(Function<? super V, ? extends Iterable<R>> function) {
        return this.groupByEach(function, FastListMultimap.newMultimap()).toImmutable();
    }

    @Override
    public <V1> ImmutableMap<V1, V> groupByUniqueKey(Function<? super V, ? extends V1> function) {
        return this.groupByUniqueKey(function, UnifiedMap.newMap()).toImmutable();
    }

    @Override
    public <K2, V2> ImmutableMap<K2, V2> aggregateInPlaceBy(Function<? super V, ? extends K2> groupBy, Function0<? extends V2> zeroValueFactory, Procedure2<? super V2, ? super V> mutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach(new MutatingAggregationProcedure<V, K2, V2>(map2, groupBy, zeroValueFactory, mutatingAggregator));
        return map2.toImmutable();
    }

    @Override
    public <K2, V2> ImmutableMap<K2, V2> aggregateBy(Function<? super V, ? extends K2> groupBy, Function0<? extends V2> zeroValueFactory, Function2<? super V2, ? super V, ? extends V2> nonMutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        this.forEach(new NonMutatingAggregationProcedure<V, K2, V2>(map2, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map2.toImmutable();
    }

    @Override
    public void reverseForEach(Procedure<? super V> procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".reverseForEach() not implemented yet");
    }

    @Override
    public LazyIterable<V> asReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asReversed() not implemented yet");
    }

    @Override
    public ImmutableSortedMap<K, V> toReversed() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toReversed() not implemented yet");
    }

    @Override
    public int detectLastIndex(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".detectLastIndex() not implemented yet");
    }

    @Override
    public ImmutableSortedMap<K, V> takeWhile(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".takeWhile() not implemented yet");
    }

    @Override
    public ImmutableSortedMap<K, V> dropWhile(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".dropWhile() not implemented yet");
    }

    @Override
    public PartitionImmutableList<V> partitionWhile(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".partitionWhile() not implemented yet");
    }

    @Override
    public ImmutableList<V> distinct() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".distinct() not implemented yet");
    }

    @Override
    public int indexOf(Object object) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    @Override
    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super V, ? super S> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".corresponds() not implemented yet");
    }

    @Override
    public void forEach(int startIndex, int endIndex, Procedure<? super V> procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEach() not implemented yet");
    }

    @Override
    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super V> objectIntProcedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    @Override
    public MutableStack<V> toStack() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".toStack() not implemented yet");
    }

    @Override
    public int detectIndex(Predicate<? super V> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".detectIndex() not implemented yet");
    }
}

