/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.primitive.FloatStack;
import org.eclipse.collections.api.stack.primitive.ImmutableFloatStack;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.FloatStacks;
import org.eclipse.collections.impl.iterator.ImmutableEmptyFloatIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableFloatEmptyStack
implements ImmutableFloatStack,
Serializable {
    static final ImmutableFloatStack INSTANCE = new ImmutableFloatEmptyStack();
    private static final long serialVersionUID = 1L;

    ImmutableFloatEmptyStack() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public FloatIterator floatIterator() {
        return ImmutableEmptyFloatIterator.INSTANCE;
    }

    @Override
    public void forEach(FloatProcedure procedure) {
    }

    @Override
    public void each(FloatProcedure procedure) {
    }

    @Override
    public int count(FloatPredicate predicate) {
        return 0;
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        return true;
    }

    @Override
    public float peek() {
        throw new EmptyStackException();
    }

    @Override
    public FloatList peek(int count2) {
        this.checkNegativeCount(count2);
        if (count2 == 0) {
            return new FloatArrayList(0);
        }
        throw new EmptyStackException();
    }

    @Override
    public float peekAt(int index) {
        this.checkNegativeCount(index);
        throw new EmptyStackException();
    }

    @Override
    public ImmutableFloatStack select(FloatPredicate predicate) {
        return this;
    }

    @Override
    public ImmutableFloatStack reject(FloatPredicate predicate) {
        return this;
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        return ifNone;
    }

    @Override
    public <V> ImmutableStack<V> collect(FloatToObjectFunction<? extends V> function) {
        return Stacks.immutable.of();
    }

    @Override
    public double sum() {
        return 0.0;
    }

    @Override
    public float max() {
        throw new NoSuchElementException();
    }

    @Override
    public float maxIfEmpty(float defaultValue) {
        return defaultValue;
    }

    @Override
    public float min() {
        throw new NoSuchElementException();
    }

    @Override
    public float minIfEmpty(float defaultValue) {
        return defaultValue;
    }

    @Override
    public double average() {
        throw new ArithmeticException();
    }

    @Override
    public double median() {
        throw new ArithmeticException();
    }

    @Override
    public float[] toSortedArray() {
        return new float[0];
    }

    @Override
    public MutableFloatList toSortedList() {
        return new FloatArrayList();
    }

    @Override
    public float[] toArray() {
        return new float[0];
    }

    @Override
    public boolean contains(float value) {
        return false;
    }

    @Override
    public boolean containsAll(float ... source) {
        return source.length == 0;
    }

    @Override
    public boolean containsAll(FloatIterable source) {
        return source.isEmpty();
    }

    @Override
    public MutableFloatList toList() {
        return new FloatArrayList();
    }

    @Override
    public MutableFloatSet toSet() {
        return new FloatHashSet();
    }

    @Override
    public MutableFloatBag toBag() {
        return new FloatHashBag();
    }

    @Override
    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter(this);
    }

    @Override
    public ImmutableFloatStack toImmutable() {
        return this;
    }

    @Override
    public ImmutableFloatStack push(float element) {
        return FloatStacks.immutable.with(element);
    }

    @Override
    public ImmutableFloatStack pop() {
        throw new EmptyStackException();
    }

    @Override
    public ImmutableFloatStack pop(int count2) {
        this.checkNegativeCount(count2);
        if (count2 == 0) {
            return this;
        }
        throw new EmptyStackException();
    }

    private void checkNegativeCount(int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count2);
        }
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof FloatStack)) {
            return false;
        }
        FloatStack stack = (FloatStack)otherStack;
        return stack.isEmpty();
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

