/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal.primitive;

import java.util.Collection;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntIteratorIterate {
    private IntIteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void forEach(IntIterator iterator2, IntProcedure procedure) {
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    public static <R extends MutableIntCollection> R select(IntIterator iterator2, IntPredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            int item = iterator2.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <R extends MutableIntCollection> R reject(IntIterator iterator2, IntPredicate predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            int item = iterator2.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <V, R extends Collection<V>> R collect(IntIterator iterator2, IntToObjectFunction<? extends V> function, R targetCollection) {
        while (iterator2.hasNext()) {
            int item = iterator2.next();
            targetCollection.add(function.valueOf(item));
        }
        return targetCollection;
    }

    public static int detectIfNone(IntIterator iterator2, IntPredicate predicate, int ifNone) {
        while (iterator2.hasNext()) {
            int item = iterator2.next();
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public static int count(IntIterator iterator2, IntPredicate predicate) {
        int count2 = 0;
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            ++count2;
        }
        return count2;
    }

    public static boolean anySatisfy(IntIterator iterator2, IntPredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return true;
        }
        return false;
    }

    public static boolean allSatisfy(IntIterator iterator2, IntPredicate predicate) {
        while (iterator2.hasNext()) {
            if (predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static boolean noneSatisfy(IntIterator iterator2, IntPredicate predicate) {
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> T injectInto(IntIterator iterator2, T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        while (iterator2.hasNext()) {
            result = function.valueOf(result, iterator2.next());
        }
        return result;
    }

    public static long sum(IntIterator iterator2) {
        long sum2 = 0L;
        while (iterator2.hasNext()) {
            sum2 += (long)iterator2.next();
        }
        return sum2;
    }

    public static int max(IntIterator iterator2) {
        int max2 = iterator2.next();
        while (iterator2.hasNext()) {
            int next = iterator2.next();
            if (max2 >= next) continue;
            max2 = next;
        }
        return max2;
    }

    public static int min(IntIterator iterator2) {
        int min2 = iterator2.next();
        while (iterator2.hasNext()) {
            int next = iterator2.next();
            if (next >= min2) continue;
            min2 = next;
        }
        return min2;
    }
}

