/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.serializer;

import java.io.IOException;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.serializer.SerializerByteArray;

public class SerializerByteArrayDelta
extends SerializerByteArray {
    @Override
    public void valueArraySerialize(DataOutput2 out, Object vals) throws IOException {
        byte[][] chars;
        for (byte[] b : chars = (byte[][])vals) {
            out.packInt(b.length);
        }
        int prefixLen = SerializerByteArrayDelta.commonPrefixLen(chars);
        out.packInt(prefixLen);
        out.write(chars[0], 0, prefixLen);
        for (byte[] b : chars) {
            out.write(b, prefixLen, b.length - prefixLen);
        }
    }

    @Override
    public byte[][] valueArrayDeserialize(DataInput2 in, int size2) throws IOException {
        byte[][] ret2 = new byte[size2][];
        for (int i = 0; i < ret2.length; ++i) {
            ret2[i] = new byte[in.unpackInt()];
        }
        int prefixLen = in.unpackInt();
        in.readFully(ret2[0], 0, prefixLen);
        for (int i = 1; i < ret2.length; ++i) {
            System.arraycopy(ret2[0], 0, ret2[i], 0, prefixLen);
        }
        for (byte[] aRet : ret2) {
            in.readFully(aRet, prefixLen, aRet.length - prefixLen);
        }
        return ret2;
    }

    protected static int commonPrefixLen(byte[][] bytes) {
        int ret2 = 0;
        while (bytes[0].length != ret2) {
            byte byt = bytes[0][ret2];
            for (int i = 1; i < bytes.length; ++i) {
                if (bytes[i].length != ret2 && byt == bytes[i][ret2]) continue;
                return ret2;
            }
            ++ret2;
        }
        return ret2;
    }
}

