/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb.volume;

import java.io.Closeable;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jpountz.xxhash.StreamingXXHash64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mapdb.CC;
import org.mapdb.DBException;
import org.mapdb.DataIO;
import org.mapdb.DataInput2;
import org.mapdb.volume.ByteBufferMemoryVol;
import org.mapdb.volume.VolumeFactory;

public abstract class Volume
implements Closeable {
    static final byte[] CLEAR = new byte[1024];
    protected static final Logger LOG = Logger.getLogger(Volume.class.getName());
    public static final VolumeFactory UNSAFE_VOL_FACTORY = new VolumeFactory(){

        @Override
        public Volume makeVolume(String file, boolean readOnly, long fileLockWait, int sliceShift, long initSize, boolean fixedSize) {
            Class<?> clazz;
            String packageName = Volume.class.getPackage().getName();
            try {
                clazz = Class.forName(packageName + ".UnsafeStuff$UnsafeVolume");
            }
            catch (ClassNotFoundException e) {
                clazz = null;
            }
            if (clazz != null) {
                try {
                    return (Volume)clazz.getConstructor(Long.TYPE, Integer.TYPE, Long.TYPE).newInstance(0L, sliceShift, initSize);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Could not invoke UnsafeVolume constructor. Falling back to DirectByteBuffer", e);
                }
            }
            return ByteBufferMemoryVol.FACTORY.makeVolume(file, readOnly, fileLockWait, sliceShift, initSize, fixedSize);
        }

        @Override
        @NotNull
        public boolean exists(@Nullable String file) {
            return false;
        }

        @Override
        public boolean handlesReadonly() {
            return false;
        }
    };
    protected final AtomicBoolean closed = new AtomicBoolean(false);

    static int sliceShiftFromSize(long sizeIncrement) {
        sizeIncrement = DataIO.nextPowTwo(sizeIncrement);
        for (int i = 0; i < 32; ++i) {
            if (1L << i != sizeIncrement) continue;
            return i;
        }
        throw new AssertionError((Object)"Could not find sliceShift");
    }

    static boolean isEmptyFile(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return true;
        }
        File f = new File(fileName);
        return !f.exists() || f.length() == 0L;
    }

    public boolean fileLoad() {
        return false;
    }

    public void assertZeroes(long startOffset, long endOffset) throws DBException.DataCorruption {
        for (long offset = startOffset; offset < endOffset; ++offset) {
            if (this.getUnsignedByte(offset) == 0) continue;
            throw new DBException.DataCorruption("Not zero at offset: " + offset);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    protected void finalize() {
    }

    public abstract void ensureAvailable(long var1);

    public abstract void truncate(long var1);

    public abstract void putLong(long var1, long var3);

    public abstract void putInt(long var1, int var3);

    public abstract void putByte(long var1, byte var3);

    public abstract void putData(long var1, byte[] var3, int var4, int var5);

    public abstract void putData(long var1, ByteBuffer var3);

    public void putDataOverlap(long offset, byte[] src, int srcPos, int srcSize) {
        this.putData(offset, src, srcPos, srcSize);
    }

    public abstract long getLong(long var1);

    public abstract int getInt(long var1);

    public abstract byte getByte(long var1);

    public abstract DataInput2 getDataInput(long var1, int var3);

    public DataInput2 getDataInputOverlap(long offset, int size2) {
        return this.getDataInput(offset, size2);
    }

    public abstract void getData(long var1, byte[] var3, int var4, int var5);

    @Override
    public abstract void close();

    public abstract void sync();

    public abstract int sliceSize();

    public void deleteFile() {
        File f = this.getFile();
        if (f != null && f.isFile() && !f.delete()) {
            LOG.warning("Could not delete file: " + f);
        }
    }

    public abstract boolean isSliced();

    public abstract long length();

    public void putUnsignedShort(long offset, int value) {
        this.putByte(offset, (byte)(value >> 8));
        this.putByte(offset + 1L, (byte)value);
    }

    public int getUnsignedShort(long offset) {
        return (this.getByte(offset) & 0xFF) << 8 | this.getByte(offset + 1L) & 0xFF;
    }

    public int getUnsignedByte(long offset) {
        return this.getByte(offset) & 0xFF;
    }

    public void putUnsignedByte(long offset, int b) {
        this.putByte(offset, (byte)(b & 0xFF));
    }

    public long getSixLong(long pos) {
        return (long)(this.getByte(pos++) & 0xFF) << 40 | (long)(this.getByte(pos++) & 0xFF) << 32 | (long)(this.getByte(pos++) & 0xFF) << 24 | (long)(this.getByte(pos++) & 0xFF) << 16 | (long)(this.getByte(pos++) & 0xFF) << 8 | (long)(this.getByte(pos) & 0xFF);
    }

    public void putSixLong(long pos, long value) {
        if (value >>> 48 != 0L) {
            throw new DBException.DataCorruption("six long illegal value");
        }
        this.putByte(pos++, (byte)(0xFFL & value >> 40));
        this.putByte(pos++, (byte)(0xFFL & value >> 32));
        this.putByte(pos++, (byte)(0xFFL & value >> 24));
        this.putByte(pos++, (byte)(0xFFL & value >> 16));
        this.putByte(pos++, (byte)(0xFFL & value >> 8));
        this.putByte(pos, (byte)(0xFFL & value));
    }

    public int putPackedLong(long pos, long value) {
        int ret2 = 0;
        int shift = 63 - Long.numberOfLeadingZeros(value);
        shift -= shift % 7;
        while (shift != 0) {
            this.putByte(pos + (long)ret2++, (byte)(value >>> shift & 0x7FL));
            shift -= 7;
        }
        this.putByte(pos + (long)ret2++, (byte)(value & 0x7FL | 0x80L));
        return ret2;
    }

    public long getPackedLong(long position) {
        byte v;
        long ret2 = 0L;
        long pos2 = 0L;
        do {
            v = this.getByte(position + pos2++);
            ret2 = ret2 << 7 | (long)(v & 0x7F);
        } while ((v & 0x80) == 0);
        return pos2 << 60 | ret2;
    }

    public abstract boolean isReadOnly();

    public abstract File getFile();

    public abstract boolean getFileLocked();

    public void copyTo(long inputOffset, Volume target, long targetOffset, long size2) {
        byte[] data = new byte[(int)size2];
        try {
            this.getDataInput(inputOffset, (int)size2).readFully(data);
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
        target.putData(targetOffset, data, 0, (int)size2);
    }

    public abstract void clear(long var1, long var3);

    public void clearOverlap(long startOffset, long endOffset) {
        if (startOffset > endOffset) {
            throw new AssertionError();
        }
        long bufSize = 0x100000L;
        long offset = Math.min(endOffset, DataIO.roundUp(startOffset, 0x100000L));
        if (offset != startOffset) {
            this.clear(startOffset, offset);
        }
        long prevOffset = offset;
        offset = Math.min(endOffset, DataIO.roundUp(offset + 1L, 0x100000L));
        while (prevOffset < endOffset) {
            this.clear(prevOffset, offset);
            prevOffset = offset;
            offset = Math.min(endOffset, DataIO.roundUp(offset + 1L, 0x100000L));
        }
        if (prevOffset != endOffset) {
            throw new AssertionError();
        }
    }

    public void copyTo(Volume to) {
        long volSize = this.length();
        long bufSize = 0x100000L;
        to.ensureAvailable(volSize);
        for (long offset = 0L; offset < volSize; offset += 0x100000L) {
            long size2 = Math.min(volSize, offset + 0x100000L) - offset;
            if (size2 < 0L) {
                throw new AssertionError();
            }
            this.copyTo(offset, to, offset, size2);
        }
    }

    public void copyFrom(InputStream input) {
        byte[] buf = new byte[1024];
        long offset = 0L;
        try {
            while (true) {
                int read;
                if ((read = input.read(buf)) == -1) {
                    return;
                }
                this.ensureAvailable(offset + (long)read);
                this.putData(offset, buf, 0, read);
                offset += (long)read;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void copyTo(OutputStream output) {
        long volSize = this.length();
        byte[] buf = new byte[1024];
        for (long offset = 0L; offset < volSize; offset += (long)buf.length) {
            int size2 = (int)(Math.min(volSize, offset + (long)buf.length) - offset);
            if (size2 < 0) {
                throw new AssertionError();
            }
            this.getData(offset, buf, 0, size2);
            try {
                output.write(buf, 0, size2);
                continue;
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
    }

    public long hash(long off, long len, long seed) {
        int blen = 128;
        byte[] b = new byte[128];
        StreamingXXHash64 s = CC.HASH_FACTORY.newStreamingHash64(seed);
        int size2 = (int)Math.min((len += off) - off, Math.min(128L, DataIO.roundUp(off, 128L) - off));
        this.getData(off, b, 0, size2);
        s.update(b, 0, size2);
        off += (long)size2;
        while (off < len) {
            size2 = (int)Math.min(128L, len - off);
            this.getData(off, b, 0, size2);
            s.update(b, 0, size2);
            off += (long)size2;
        }
        return s.getValue();
    }

    /*
     * Loose catch block
     */
    static FileLock lockFile(File file, FileChannel channel, boolean readOnly, long fileLockWait) {
        if (fileLockWait < 0L || readOnly) {
            return null;
        }
        while (true) {
            try {
                return channel.lock();
            }
            catch (OverlappingFileLockException e) {
                if (fileLockWait > 0L) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e1) {
                        throw new DBException.Interrupted(e1);
                    }
                    fileLockWait -= 100L;
                    continue;
                }
                throw new DBException.FileLocked(file.toPath(), e);
            }
            break;
        }
        catch (IOException e) {
            throw new DBException.VolumeIOError(e);
        }
    }
}

