/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.security.AccessControlException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JToolBar;
import org.math.plot.DataPanel;
import org.math.plot.PlotPanel;

public class DataToolBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    protected JButton buttonPasteToClipboard;
    protected JButton buttonSaveFile;
    private boolean denySaveSecurity;
    private JFileChooser fileChooser;
    private DataPanel dataPanel;

    public DataToolBar(DataPanel dp) {
        this.dataPanel = dp;
        try {
            this.fileChooser = new JFileChooser();
        }
        catch (AccessControlException ace) {
            this.denySaveSecurity = true;
        }
        this.buttonPasteToClipboard = new JButton(new ImageIcon(PlotPanel.class.getResource("icons/toclipboard.png")));
        this.buttonPasteToClipboard.setToolTipText("Copy data to clipboard");
        this.buttonSaveFile = new JButton(new ImageIcon(PlotPanel.class.getResource("icons/tofile.png")));
        this.buttonSaveFile.setToolTipText("Save data into ASCII file");
        this.buttonPasteToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolBar.this.dataPanel.toClipBoard();
            }
        });
        this.buttonSaveFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataToolBar.this.chooseFile();
            }
        });
        this.add((Component)this.buttonPasteToClipboard, null);
        this.add((Component)this.buttonSaveFile, null);
        if (!this.denySaveSecurity) {
            this.fileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataToolBar.this.saveFile();
                }
            });
        } else {
            this.buttonSaveFile.setEnabled(false);
        }
    }

    void saveFile() {
        File file = this.fileChooser.getSelectedFile();
        this.dataPanel.toASCIIFile(file);
    }

    void chooseFile() {
        this.fileChooser.showSaveDialog(this);
    }
}

