/*
 * Decompiled with CFR 0.152.
 */
package org.math.plot.plotObjects;

import org.math.plot.utils.FastMath;

public class Base {
    public static final String STRINGS = "str";
    public static final String LINEAR = "lin";
    public static final String LOGARITHM = "log";
    public double[][] baseCoords;
    protected double[] precisionUnit;
    public double[] roundXmin;
    public double[] roundXmax;
    protected double[] trueXmin;
    protected double[] trueXmax;
    public int dimension;
    public String[] axesScales;

    public Base(double[] Xmi, double[] Xma, String[] scales) {
        this.init(Xmi.length);
        this.trueXmin = Xmi;
        this.trueXmax = Xma;
        this.dimension = this.trueXmin.length;
        this.axesScales = scales;
        this.setFixedBounds(Xmi, Xma);
    }

    private void init(int d) {
        this.precisionUnit = new double[d];
        this.roundXmin = new double[d];
        this.roundXmax = new double[d];
        this.trueXmin = new double[d];
        this.trueXmax = new double[d];
    }

    private void resetCoords() {
        this.baseCoords = new double[this.dimension + 1][];
        for (int i = 0; i < this.baseCoords.length; ++i) {
            this.baseCoords[i] = (double[])this.roundXmin.clone();
            if (i <= 0) continue;
            this.baseCoords[i][i - 1] = this.roundXmax[i - 1];
        }
    }

    private void setPrecisionUnit(int i, double Xmi, double Xma) {
        this.precisionUnit[i] = Xma - Xmi > 0.0 ? FastMath.pow(10.0, FastMath.floor(FastMath.log(Xma - Xmi) / FastMath.log(10.0))) : 1.0;
    }

    public void setAxesScales(String[] scales) {
        this.axesScales = scales;
        this.setRoundBounds(this.trueXmin, this.trueXmax);
        this.resetCoords();
    }

    public void setAxesScales(int i, String scale) {
        this.axesScales[i] = scale;
        this.setRoundBounds(this.trueXmin, this.trueXmax);
        this.resetCoords();
    }

    public double[][] getCoords() {
        return this.baseCoords;
    }

    public String[] getAxesScales() {
        return this.axesScales;
    }

    public String getAxeScale(int i) {
        return this.axesScales[i];
    }

    public double[] getMinBounds() {
        return this.roundXmin;
    }

    public double[] getMaxBounds() {
        return this.roundXmax;
    }

    public double[] getPrecisionUnit() {
        return this.precisionUnit;
    }

    private void setBounds(int i, double Xmi, double Xma) {
        if (Xmi <= 0.0 && this.axesScales[i].equalsIgnoreCase(LOGARITHM)) {
            Xmi = 1.0;
        }
        if (Xma <= 0.0 && this.axesScales[i].equalsIgnoreCase(LOGARITHM)) {
            Xma = 1.0;
        }
        if (Xmi == Xma) {
            Xmi = Xma - 1.0;
        }
        if (Xmi > Xma) {
            throw new IllegalArgumentException("Error while bounding dimension " + (i + 1) + " : min " + Xmi + " must be < to max " + Xma);
        }
        this.roundXmin[i] = Xmi;
        this.roundXmax[i] = Xma;
        this.resetCoords();
    }

    public void setFixedBounds(int i, double Xmi, double Xma) {
        this.setPrecisionUnit(i, Xmi, Xma);
        this.setBounds(i, Xmi, Xma);
    }

    public void setFixedBounds(double[] Xmi, double[] Xma) {
        for (int i = 0; i < Xmi.length; ++i) {
            this.setFixedBounds(i, Xmi[i], Xma[i]);
        }
    }

    public void roundBounds(int i) {
        this.setPrecisionUnit(i, this.trueXmin[i], this.trueXmax[i]);
        if (this.axesScales[i].equalsIgnoreCase(LOGARITHM)) {
            this.setBounds(i, FastMath.pow(10.0, FastMath.floor(FastMath.log(this.trueXmin[i]) / FastMath.log(10.0))), FastMath.pow(10.0, FastMath.ceil(FastMath.log(this.trueXmax[i]) / FastMath.log(10.0))));
        } else if (this.axesScales[i].equalsIgnoreCase(LINEAR) || this.axesScales[i].equalsIgnoreCase(STRINGS)) {
            if (this.roundXmin[i] <= this.roundXmax[i]) {
                this.setBounds(i, this.precisionUnit[i] * FastMath.floor(this.trueXmin[i] / this.precisionUnit[i]), this.precisionUnit[i] * FastMath.ceil(this.trueXmax[i] / this.precisionUnit[i]));
            } else {
                this.setBounds(i, this.precisionUnit[i] * FastMath.ceil(this.trueXmax[i] / this.precisionUnit[i]), this.precisionUnit[i] * FastMath.floor(this.trueXmin[i] / this.precisionUnit[i]));
            }
        }
    }

    public void setRoundBounds(int i, double Xmi, double Xma) {
        this.trueXmin[i] = Xmi;
        this.trueXmax[i] = Xma;
        this.roundBounds(i);
    }

    public void setRoundBounds(double[] Xmi, double[] Xma) {
        for (int i = 0; i < Xmi.length; ++i) {
            this.trueXmin[i] = Xmi[i];
            this.trueXmax[i] = Xma[i];
            this.roundBounds(i);
        }
    }

    public boolean includeInBounds(int dim, double XY) {
        int i;
        boolean changed = false;
        for (i = 0; i < this.roundXmin.length; ++i) {
            if (i != dim || !(XY < this.trueXmin[i])) continue;
            this.trueXmin[i] = XY;
            changed = true;
        }
        for (i = 0; i < this.roundXmax.length; ++i) {
            if (i != dim || !(XY > this.trueXmax[i])) continue;
            this.trueXmax[i] = XY;
            changed = true;
        }
        if (changed) {
            this.roundBounds(dim);
        }
        return changed;
    }

    public boolean includeInBounds(double[] XY) {
        int i;
        boolean changed = false;
        for (i = 0; i < this.roundXmin.length; ++i) {
            if (!(XY[i] < this.trueXmin[i])) continue;
            this.trueXmin[i] = XY[i];
            changed = true;
        }
        for (i = 0; i < this.roundXmax.length; ++i) {
            if (!(XY[i] > this.trueXmax[i])) continue;
            this.trueXmax[i] = XY[i];
            changed = true;
        }
        if (changed) {
            this.setRoundBounds(this.trueXmin, this.trueXmax);
        }
        return changed;
    }

    public boolean authorizedLogScale(int i) {
        return this.roundXmin[i] > 0.0;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.baseCoords.length; ++i) {
            s.append("[");
            for (int j = 0; j < this.baseCoords[i].length; ++j) {
                s.append(this.baseCoords[i][j] + ",");
            }
            s.deleteCharAt(s.length() - 1);
            s.append("]");
        }
        return s.toString();
    }
}

