/*
 * Decompiled with CFR 0.152.
 */
package spiking.controllers.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import spiking.internode.InterNodeBurningSpike;
import spiking.internode.InterNodeSpike;
import spiking.node.Node;
import spiking.node.NodesManager;
import spiking.node.Synapse;
import spiking.node.SynapsesManager;
import spiking.node.neuron.NodeNeuronsManager;
import spiking.node.spikes.FixedBurnSpike;
import utils.constants.Constants;
import utils.math.FastMath;
import utils.statistics.BurningWriter;
import utils.statistics.FiringWriter;
import utils.statistics.StatisticsCollector;
import utils.tools.NiceNode;
import utils.tools.NiceQueue;

public class NodeThread
extends Thread {
    private static final String TAG = "[Node Thread ";
    private static final Boolean verbose = true;
    private Node n;
    private NodeNeuronsManager nnMan;
    private NodesManager nMan;
    private SynapsesManager synMan;
    private Boolean plasticity;
    private HashMap<Synapse, NiceQueue> queuesMap;
    private double currentTime = 0.0;
    private double stopTime = 0.0;
    private double startTime = 0.0;
    private Boolean debug = false;
    private Boolean activePassiveDebug = false;
    private int debug_level = 3;
    private int debNum = 28;
    private ArrayList<InterNodeSpike> internodeFires;
    private Boolean keepRunning = true;
    private Lock lock = new ReentrantLock();
    private Condition newTimeSplitCond = this.lock.newCondition();
    private PriorityQueue<InterNodeBurningSpike> interNodeBurningSpikes = new PriorityQueue();
    private PriorityQueue<FixedBurnSpike> burningQueueSpikes = new PriorityQueue();
    private FastMath fm = new FastMath();
    private Double debugMaxWPDiff = 0.0;
    private Boolean do_fast;
    private Boolean isNOI;
    private Boolean lif = false;
    private Boolean exp_decay = false;
    long[] times = new long[10];
    private StatisticsCollector sc;
    private int toremDebug = 0;
    private BurningWriter burningWriter;
    private FiringWriter firingWriter;

    public NodeThread(NodesManager nMan, Integer id, Long n, Double excitProportion, Integer k, Double prew, Integer Bn, Double IBI, Double D_exc, Double D_inh, Double ld, Double kr, Double mu_w_exc, Double mu_w_inh, Double sigma_w_exc, Double sigma_w_inh, Double w_pre_exc, Double w_pre_inh, Double externalPresynapticDefVal, Boolean plasticity, Double etap, Double etam, Double taup, Double taum, Double pwMax, Double to, Double avgNeuronalSignalSpeed, Boolean lif, Boolean exp_decay, Boolean do_fast, Boolean isNOI, StatisticsCollector sc) {
        this.n = new Node(id, n, excitProportion, mu_w_exc, mu_w_inh, sigma_w_exc, sigma_w_inh, w_pre_exc, w_pre_inh, k, prew, Bn, IBI, plasticity, etap, etam, taup, taum, pwMax, to);
        this.init(nMan, D_exc, D_inh, ld, kr, w_pre_exc, w_pre_inh, externalPresynapticDefVal, avgNeuronalSignalSpeed, lif, exp_decay, do_fast, isNOI, sc);
    }

    public NodeThread(NodesManager nMan, Integer id, Long n, Integer externalInputs, int externalInputType, Double externalInputsTimeOffset, double timeStep, int fireDuration, Double externalAmplitude, int externalOutdegree, Double excitRatio, Integer k, Double prew, Integer Bn, Double IBI, Double c, Double D_exc, Double D_inh, Double t_arp, Double mu_w_exc, Double mu_w_inh, Double sigma_w_exc, Double sigma_w_inh, Double w_pre_exc, Double w_pre_inh, Double externalPresynapticDefVal, Boolean plasticity, Double etap, Double etam, Double taup, Double taum, Double pwMax, Double to, Double avgNeuronalSignalSpeed, Boolean lif, Boolean exp_decay, Boolean do_fast, Boolean isNOI, StatisticsCollector sc) {
        this.n = new Node(id, n, externalInputs, externalInputType, externalInputsTimeOffset, timeStep, fireDuration, externalAmplitude, externalOutdegree, excitRatio, mu_w_exc, mu_w_inh, sigma_w_exc, sigma_w_inh, w_pre_exc, w_pre_inh, k, prew, Bn, IBI, plasticity, etap, etam, taup, taum, pwMax, to);
        this.init(nMan, c, D_exc, D_inh, t_arp, w_pre_exc, w_pre_inh, externalPresynapticDefVal, avgNeuronalSignalSpeed, lif, exp_decay, do_fast, isNOI, sc);
    }

    public void init(NodesManager nMan, Double c, Double D_exc, Double D_inh, Double t_arp, Double excitatoryPresynapticDefVal, Double inhibithoryPresynapticDefVal, Double externalPresynapticDefVal, Double avgNeuronalSignalSpeed, Boolean lif, Boolean exp_decay, Boolean do_fast, Boolean isNOI, StatisticsCollector sc) {
        this.sc = sc;
        this.queuesMap = new HashMap();
        this.internodeFires = new ArrayList();
        this.nnMan = new NodeNeuronsManager(this.n, c, D_exc, D_inh, t_arp, excitatoryPresynapticDefVal, inhibithoryPresynapticDefVal, externalPresynapticDefVal);
        this.plasticity = this.n.getPlasticity();
        this.initExtInput();
        this.synMan = new SynapsesManager(this.n, avgNeuronalSignalSpeed);
        this.nMan = nMan;
        this.println("Bn: " + this.n.getBn());
        this.println("IBI: " + this.n.getIBI());
        this.println("c: " + c);
        this.println("D exc: " + D_exc);
        this.println("D inh: " + D_inh);
        this.println("t arp: " + t_arp);
        this.lif = lif;
        this.exp_decay = exp_decay;
        this.do_fast = do_fast;
        this.isNOI = isNOI;
    }

    @Override
    public void run() {
        Long firingNeuronId = null;
        Double spikeTime = null;
        Integer lastCollectedBurstFiringNodeId = -1;
        Long lastCollectedBurstFiringNeuronId = -1L;
        Double lastCollectedBurstFiringBurnTime = -1.0;
        int fires = 0;
        Boolean stopped = false;
        while (this.keepRunning.booleanValue()) {
            while (this.currentTime < this.stopTime && !stopped.booleanValue()) {
                block23: {
                    block27: {
                        Double tmpMinFiringTime;
                        block24: {
                            block26: {
                                FixedBurnSpike fixedBurnSpike;
                                Double minFixedBurnTime;
                                block25: {
                                    FixedBurnSpike tmpFixedBurnSpike;
                                    block21: {
                                        InterNodeSpike irs;
                                        Double tmpMinInterNodeBurningTime;
                                        block22: {
                                            tmpMinFiringTime = this.nnMan.getMinFiringTime();
                                            InterNodeBurningSpike tmpInterNodeBurningSpike = this.interNodeBurningSpikes.peek();
                                            tmpFixedBurnSpike = this.burningQueueSpikes.peek();
                                            minFixedBurnTime = tmpFixedBurnSpike == null ? Double.MAX_VALUE : tmpFixedBurnSpike.getBurnTime();
                                            if (tmpInterNodeBurningSpike == null || (tmpMinInterNodeBurningTime = tmpInterNodeBurningSpike.getTimeToBurn()) == null || !(tmpMinInterNodeBurningTime < this.stopTime)) break block21;
                                            if (tmpMinFiringTime == null) break block22;
                                            if (!(tmpMinInterNodeBurningTime < tmpMinFiringTime) || !(tmpMinInterNodeBurningTime < minFixedBurnTime)) break block21;
                                            irs = this.interNodeBurningSpikes.poll().getInterNodeSpike();
                                            if (tmpMinInterNodeBurningTime < this.currentTime) {
                                                this.println("internode burning:" + tmpMinInterNodeBurningTime + " min FixedBurn:" + minFixedBurnTime + " tmpMinFiringTime:" + tmpMinFiringTime);
                                                if (this.interNodeBurningSpikes.peek() != null) {
                                                    this.println("polled:" + irs.getBurnTime() + " peeked:" + this.interNodeBurningSpikes.peek().getTimeToBurn() + "\n");
                                                }
                                            }
                                            if (this.interNodeBurningSpikes.peek() != null && irs.getBurnTime() > this.interNodeBurningSpikes.peek().getTimeToBurn()) {
                                                this.println("polled:" + irs.getBurnTime() + " peeked:" + this.interNodeBurningSpikes.peek().getTimeToBurn() + " syn:" + tmpInterNodeBurningSpike.getInterNodeSpike().getSyn());
                                            }
                                            this.currentTime = tmpMinInterNodeBurningTime;
                                            this.burnNeuron(irs.getSyn(), irs.getBurnTime(), irs.getFireTime(), false);
                                            break block23;
                                        }
                                        if (!(tmpMinInterNodeBurningTime < minFixedBurnTime)) break block21;
                                        irs = this.interNodeBurningSpikes.poll().getInterNodeSpike();
                                        this.currentTime = tmpMinInterNodeBurningTime;
                                        this.burnNeuron(irs.getSyn(), irs.getBurnTime(), irs.getFireTime(), false);
                                        break block23;
                                    }
                                    if (!(minFixedBurnTime < this.stopTime)) break block24;
                                    if (tmpMinFiringTime == null) break block25;
                                    if (!(minFixedBurnTime < tmpMinFiringTime)) break block24;
                                    fixedBurnSpike = this.burningQueueSpikes.poll();
                                    if (tmpFixedBurnSpike.getBurnTime() != fixedBurnSpike.getBurnTime()) {
                                        this.println("tada!:" + tmpFixedBurnSpike.getBurnTime() + "!=" + fixedBurnSpike.getBurnTime());
                                        System.exit(1);
                                    }
                                    this.currentTime = minFixedBurnTime;
                                    this.burnNeuron(fixedBurnSpike.getSyn(), fixedBurnSpike.getBurnTime(), minFixedBurnTime, false);
                                    if (!(lastCollectedBurstFiringNodeId.equals(this.n.getId()) && lastCollectedBurstFiringNeuronId.equals(fixedBurnSpike.getSyn().getAxonNeuronId()) && lastCollectedBurstFiringBurnTime.equals(fixedBurnSpike.getBurnTime()))) {
                                        lastCollectedBurstFiringNodeId = this.n.getId();
                                        lastCollectedBurstFiringNeuronId = fixedBurnSpike.getSyn().getAxonNeuronId();
                                        lastCollectedBurstFiringBurnTime = fixedBurnSpike.getBurnTime();
                                        if (this.isNOI.booleanValue()) {
                                            this.sc.collectFireSpike(this.n.getId(), fixedBurnSpike.getSyn().getAxonNeuronId(), fixedBurnSpike.getBurnTime(), this.nMan.getMaxN(), this.nMan.getCompressionFactor(), fixedBurnSpike.getSyn().getAxonNeuronId() < this.n.getExcitatory(), fixedBurnSpike.getSyn().getAxonNeuronId() >= this.n.getN());
                                        }
                                    }
                                    break block23;
                                }
                                if (!(minFixedBurnTime < Double.MAX_VALUE)) break block26;
                                fixedBurnSpike = this.burningQueueSpikes.poll();
                                this.currentTime = minFixedBurnTime;
                                this.burnNeuron(fixedBurnSpike.getSyn(), fixedBurnSpike.getBurnTime(), fixedBurnSpike.getFireTime(), false);
                                if (!(lastCollectedBurstFiringNodeId.equals(this.n.getId()) && lastCollectedBurstFiringNeuronId.equals(fixedBurnSpike.getSyn().getAxonNeuronId()) && lastCollectedBurstFiringBurnTime.equals(fixedBurnSpike.getBurnTime()))) {
                                    lastCollectedBurstFiringNodeId = this.n.getId();
                                    lastCollectedBurstFiringNeuronId = fixedBurnSpike.getSyn().getAxonNeuronId();
                                    lastCollectedBurstFiringBurnTime = fixedBurnSpike.getBurnTime();
                                    if (this.isNOI.booleanValue()) {
                                        this.sc.collectFireSpike(this.n.getId(), fixedBurnSpike.getSyn().getAxonNeuronId(), fixedBurnSpike.getBurnTime(), this.nMan.getMaxN(), this.nMan.getCompressionFactor(), fixedBurnSpike.getSyn().getAxonNeuronId() < this.n.getExcitatory(), fixedBurnSpike.getSyn().getAxonNeuronId() >= this.n.getN());
                                    }
                                }
                                break block23;
                            }
                            stopped = true;
                            break;
                        }
                        if (tmpMinFiringTime == null || tmpMinFiringTime > this.stopTime) {
                            stopped = true;
                            break;
                        }
                        NiceNode minFiringNeuron = this.nnMan.getNextFiringNeuron();
                        if (minFiringNeuron == null) {
                            stopped = true;
                            break;
                        }
                        firingNeuronId = minFiringNeuron.fn;
                        spikeTime = minFiringNeuron.tf;
                        if (spikeTime > this.stopTime) {
                            stopped = true;
                            break;
                        }
                        this.currentTime = spikeTime;
                        if (firingNeuronId < this.n.getN()) {
                            this.nnMan.resetState(firingNeuronId);
                            this.nnMan.resetTimeToFire(firingNeuronId);
                        }
                        this.nnMan.setLastFiringTime(firingNeuronId, this.currentTime);
                        if (firingNeuronId < this.n.getN()) break block27;
                        this.nnMan.resetTimeToFire(firingNeuronId);
                        this.nnMan.extInputReset(firingNeuronId, this.currentTime);
                        if (this.currentTime > (double)this.n.getExternalInput().getFireDuration().intValue()) break block23;
                    }
                    if (this.isNOI.booleanValue()) {
                        this.sc.collectFireSpike(this.n.getId(), firingNeuronId, spikeTime, this.nMan.getMaxN(), this.nMan.getCompressionFactor(), firingNeuronId < this.n.getExcitatory(), firingNeuronId >= this.n.getN());
                    }
                    this.makeNeuronFire(firingNeuronId, this.currentTime);
                }
                ++fires;
            }
            this.completed();
            stopped = false;
        }
    }

    private void addInterNodeFire(Synapse syn, Double fireTime) {
        Double axonalDelay = this.synMan.getAxDelay(syn);
        this.internodeFires.add(new InterNodeSpike(syn, fireTime + axonalDelay, fireTime, axonalDelay));
    }

    public Boolean hasInterNodeSpikes() {
        if (this.internodeFires.size() > 0) {
            return true;
        }
        return false;
    }

    public ArrayList<InterNodeSpike> pullInternodeFires() {
        ArrayList<InterNodeSpike> retval = this.internodeFires;
        this.internodeFires = new ArrayList();
        return retval;
    }

    public double getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(double currentTime) {
        this.currentTime = currentTime;
    }

    public double getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(double stopTime) {
        this.stopTime = stopTime;
    }

    public Integer getNodeId() {
        return this.n.getId();
    }

    public void addInterNodeSynapse(Integer firingNodeId, Long firingNeuronId, Integer burningNodeId, Long burningNeuronId, Double presynaptic_w, Double mu, Double lambda2) {
        this.synMan.addInterNodeSynapse(firingNodeId, firingNeuronId, burningNodeId, burningNeuronId, mu, this.n.getPresynapticForNeuron(firingNeuronId), lambda2);
    }

    public Long getN() {
        return this.n.getN();
    }

    public Long getExcitatory() {
        return this.n.getExcitatory();
    }

    public Long getInhibithory() {
        return this.n.getInhibithory();
    }

    public Double getExcitatoryPresynapticWeight() {
        return this.n.getExc_ampl();
    }

    public boolean hasExternalInput() {
        return this.n.hasExternalInput();
    }

    public Integer getExternalInputs() {
        return this.n.getExternalInputs();
    }

    private void fire_ltp(Synapse syn, Double fireTime) {
        double wpold;
        Double wp;
        Double delta;
        int i;
        if (!this.plasticity.booleanValue()) {
            return;
        }
        if (syn.getFiring() == null) {
            return;
        }
        Long firingNeuronId = syn.getFiring();
        ArrayList<Synapse> synapses = this.synMan.getFiringNeuronSynapses(firingNeuronId);
        ArrayList<Synapse> interNodeSynapses = this.synMan.getFiringNeuronInterNodesSynapses(firingNeuronId);
        for (i = 0; i < synapses.size(); ++i) {
            if (synapses.get(i).getLastBurningTime() == null || !((delta = Double.valueOf(fireTime - synapses.get(i).getLastBurningTime())) < this.n.getPlasticityTo())) continue;
            wp = synapses.get(i).getPostSynapticWeight();
            wpold = wp;
            wp = wp + (this.do_fast != false ? (this.n.getPwMax() - wp) * this.n.getEtap() * (double)this.fm.fastexp(-delta.doubleValue() / this.n.getTaup()) : (this.n.getPwMax() - wp) * this.n.getEtap() * Math.exp(-delta.doubleValue() / this.n.getTaup()));
            this.synMan.setIntraNodePostSynapticWeight(synapses.get(i), wp);
        }
        for (i = 0; i < interNodeSynapses.size(); ++i) {
            if (interNodeSynapses.get(i).getLastBurningTime() == null || !((delta = Double.valueOf(fireTime - interNodeSynapses.get(i).getLastBurningTime())) < this.n.getPlasticityTo())) continue;
            wp = interNodeSynapses.get(i).getPostSynapticWeight();
            wpold = wp;
            wp = wp + (this.do_fast != false ? (this.n.getPwMax() - wp) * this.n.getEtap() * (double)this.fm.fastexp(-delta.doubleValue() / this.n.getTaup()) : (this.n.getPwMax() - wp) * this.n.getEtap() * Math.exp(-delta.doubleValue() / this.n.getTaup()));
            this.synMan.setIntraNodePostSynapticWeight(interNodeSynapses.get(i), wp);
        }
    }

    private void burning_ltd(Synapse syn, Double burningTime, Double lastFiringTime) {
        if (!this.plasticity.booleanValue()) {
            return;
        }
        if (syn.getBurning() == null) {
            return;
        }
        syn.setLastBurningTime(burningTime);
        Double delta = burningTime - lastFiringTime;
        if (delta < this.n.getPlasticityTo()) {
            Double wp = syn.getPostSynapticWeight();
            double wpold = wp;
            if ((wp = Double.valueOf(wp - (this.do_fast != false ? wp * this.n.getEtam() * (double)this.fm.fastexp(-delta.doubleValue() / this.n.getTaum()) : wp * this.n.getEtam() * Math.exp(-delta.doubleValue() / this.n.getTaum())))) < 0.0) {
                wp = 0.0;
            }
            this.synMan.setIntraNodePostSynapticWeight(syn, wp);
        }
    }

    private void makeNeuronFire(Long firingNeuronId, Double currentTime) {
        int j;
        int i;
        ArrayList<Synapse> synapses = this.synMan.getFiringNeuronSynapses(firingNeuronId);
        ArrayList<Synapse> interNodeSynapses = this.synMan.getFiringNeuronInterNodesSynapses(firingNeuronId);
        if (this.n.isExternalInput(firingNeuronId).booleanValue()) {
            int eod = this.n.getExternalOutDegree();
            int eoj = this.n.getExternalOutJump();
            if (eod == 1) {
                this.burnNeuron(null, firingNeuronId, this.n.getId(), firingNeuronId % this.n.getN(), this.n.getId(), 0.1, 1.0, this.n.getExternalAmplitude(), currentTime, currentTime, true);
            } else {
                for (int i2 = 0; i2 < eod; ++i2) {
                    this.burnNeuron(null, firingNeuronId, this.n.getId(), (firingNeuronId + (long)(eoj * i2)) % this.n.getN(), this.n.getId(), 0.1, 1.0, this.n.getExternalAmplitude(), currentTime, currentTime, true);
                }
            }
            return;
        }
        for (i = 0; i < synapses.size(); ++i) {
            this.fire_ltp(synapses.get(i), currentTime);
            if (!synapses.get(i).getBurningNodeId().equals(this.n.getId())) continue;
            this.burnNeuron(synapses.get(i), currentTime, currentTime, false);
            for (j = 1; j < this.n.getBn(); ++j) {
                this.burningQueueSpikes.add(new FixedBurnSpike(synapses.get(i), currentTime + this.n.getIBI() * (double)j, currentTime));
            }
        }
        for (i = 0; i < interNodeSynapses.size(); ++i) {
            for (j = 0; j < this.n.getBn(); ++j) {
                this.addInterNodeFire(interNodeSynapses.get(i), currentTime + this.n.getIBI() * (double)j);
            }
        }
    }

    public void burnNeuron(Synapse s, Double burnTime, Double fireTime, Boolean fromExternalInput) {
        this.burnNeuron(s, s.getFiring(), s.getFiringNodeId(), s.getBurning(), s.getBurningNodeId(), s.getLength(), s.getPostSynapticWeight(), s.getPreSynapticWeight(), burnTime, fireTime, fromExternalInput);
    }

    public void burnNeuron(Synapse s, long firingNeuronId, int firingNodeId, long burningNeuronId, int burningNodeId, double axon_length, double postsynapticWeight, double presynapticWeight, double burnTime, double fireTime, boolean fromExternalInput) {
        boolean arp;
        boolean bl = arp = !this.nnMan.getLastFiringTime(burningNeuronId).equals(Constants.TIME_TO_FIRE_DEF_VAL);
        if (burnTime >= (this.nnMan.getLastFiringTime(burningNeuronId) + this.nnMan.getT_arp() + (double)(this.n.getBn() - 1) * this.n.getIBI()) * (double)arp) {
            double sx;
            double tmp;
            long startTime = System.currentTimeMillis();
            if (!fromExternalInput) {
                this.burning_ltd(s, burnTime, this.nnMan.getLastFiringTime(burningNeuronId));
            }
            if ((tmp = this.nnMan.getState(burningNeuronId).doubleValue()) < this.nnMan.getSpikingThr()) {
                Double decay;
                if (!this.exp_decay.booleanValue()) {
                    decay = this.nnMan.getLinearDecayD(burningNeuronId) * (burnTime - this.nnMan.getLastBurningTime(burningNeuronId));
                    this.nnMan.setState(burningNeuronId, tmp - decay);
                } else {
                    decay = this.do_fast != false ? tmp * (double)(1.0f - this.fm.fastexp(-(burnTime - this.nnMan.getLastBurningTime(burningNeuronId)) / this.nnMan.getLinearDecayD(burningNeuronId))) : tmp * (1.0 - Math.exp(-(burnTime - this.nnMan.getLastBurningTime(burningNeuronId)) / this.nnMan.getLinearDecayD(burningNeuronId)));
                    this.nnMan.setState(burningNeuronId, tmp - decay);
                }
                if (this.nnMan.getState(burningNeuronId) < 0.0) {
                    this.nnMan.setState(burningNeuronId, 0.0);
                }
            }
            this.times[0] = this.times[0] + (System.currentTimeMillis() - startTime);
            startTime = System.currentTimeMillis();
            double oldSx = sx = this.nnMan.getState(burningNeuronId).doubleValue();
            double sy = postsynapticWeight * presynapticWeight;
            if (this.nnMan.getTimeToFire(burningNeuronId).equals(Constants.TIME_TO_FIRE_DEF_VAL)) {
                oldSx = sx;
                sx = sx + sy < 0.0 ? 0.0 : sx + sy;
                this.nnMan.setState(burningNeuronId, sx);
                if (sx >= this.nnMan.getSpikingThr()) {
                    if (this.lif.booleanValue()) {
                        this.nnMan.setTimeToFire(burningNeuronId, burnTime + Constants.EPSILON);
                    } else {
                        double activeTransitionDelay = 1.0 / (sx - 1.0);
                        this.nnMan.setTimeToFire(burningNeuronId, burnTime + activeTransitionDelay);
                    }
                    this.nnMan.addActiveNeuron(burningNeuronId, this.nnMan.getTimeToFire(burningNeuronId), this.currentTime, 2);
                }
                this.times[1] = this.times[1] + (System.currentTimeMillis() - startTime);
            } else if (!this.lif.booleanValue()) {
                if (this.nnMan.getTimeToFire(burningNeuronId) == 0.0) {
                    this.nnMan.setTimeToFire(burningNeuronId, Constants.EPSILON);
                }
                if (sx >= this.nnMan.getSpikingThr()) {
                    this.nnMan.removeActiveNeuron(burningNeuronId);
                    if (burnTime < this.nnMan.getTimeToFire(burningNeuronId) && !this.nnMan.getLastBurningTime(burningNeuronId).equals(Constants.BURNING_TIME_DEF_VAL)) {
                        double riseTermXFactor = burnTime == this.nnMan.getLastBurningTime(burningNeuronId) ? Constants.EPSILON : burnTime - this.nnMan.getLastBurningTime(burningNeuronId);
                        tmp = (sx - 1.0) * riseTermXFactor;
                        double dsxNumerator = (sx - 1.0) * tmp;
                        double dsxDenominator = 1.0 - tmp;
                        sx += dsxNumerator / dsxDenominator;
                    }
                    oldSx = sx;
                    this.nnMan.setState(burningNeuronId, sx += sy);
                    if (sx < this.nnMan.getSpikingThr()) {
                        this.nnMan.removeActiveNeuron(burningNeuronId);
                        this.nnMan.resetTimeToFire(burningNeuronId);
                    } else {
                        this.nnMan.setTimeToFire(burningNeuronId, burnTime + 1.0 / (sx - 1.0));
                        this.nnMan.setState(burningNeuronId, sx);
                        this.nnMan.addActiveNeuron(burningNeuronId, this.nnMan.getTimeToFire(burningNeuronId), this.currentTime, 3);
                    }
                    if (sx < 0.0) {
                        oldSx = sx = 0.0;
                        this.nnMan.setState(burningNeuronId, sx);
                        this.nnMan.removeActiveNeuron(burningNeuronId);
                        this.nnMan.resetTimeToFire(burningNeuronId);
                    }
                } else {
                    oldSx = sx;
                    this.nnMan.removeActiveNeuron(burningNeuronId);
                    this.nnMan.resetTimeToFire(burningNeuronId);
                }
                this.times[2] = this.times[2] + (System.currentTimeMillis() - startTime);
            }
            startTime = System.currentTimeMillis();
            this.nnMan.setLastBurningTime(burningNeuronId, burnTime);
            this.times[4] = this.times[4] + (System.currentTimeMillis() - startTime);
            if (this.isNOI.booleanValue()) {
                this.sc.collectBurnSpike(firingNeuronId, firingNodeId, burningNeuronId, burningNodeId, burnTime, fromExternalInput, oldSx, sy, postsynapticWeight, presynapticWeight, this.nnMan.getTimeToFire(burningNeuronId), fireTime);
            }
            this.times[3] = this.times[3] + (System.currentTimeMillis() - startTime);
        } else if (this.isNOI.booleanValue()) {
            this.sc.collectBurnSpike(firingNeuronId, firingNodeId, burningNeuronId, burningNodeId, burnTime, fromExternalInput, null, null, postsynapticWeight, presynapticWeight, this.nnMan.getTimeToFire(burningNeuronId), fireTime);
        }
    }

    public void burnInterNodeSpike(InterNodeSpike irs) {
        if (irs.getBurnTime() >= this.stopTime) {
            this.interNodeBurningSpikes.add(new InterNodeBurningSpike(irs, irs.getBurnTime()));
        } else {
            this.sc.collectMissedFire(irs.getAxonalDelay());
            this.println("missed fire at time:" + irs.getBurnTime() + ", axonal del:" + irs.getAxonalDelay() + ", fire time:" + irs.getFireTime() + ", current time:" + this.currentTime + ", syn:" + irs.getSyn());
        }
    }

    private void initExtInput() {
        this.println("initializing external input...");
        for (int j = 0; j < this.n.getExternalInputs(); ++j) {
            this.nnMan.extInputReset(this.n.getN() + (long)j, 0.0);
        }
        this.println("external input initialization done.");
    }

    public void runNewSplit(double newStopTime) {
        this.startTime = this.stopTime;
        if (this.currentTime < this.stopTime) {
            this.currentTime = this.stopTime;
        }
        this.stopTime = newStopTime;
        this.lock.lock();
        this.newTimeSplitCond.signal();
        this.lock.unlock();
    }

    private void completed() {
        double oldStopTime = this.stopTime;
        this.print_times();
        if (this.nMan.splitComplete(this.getNodeId()).booleanValue()) {
            this.lock.lock();
            try {
                this.newTimeSplitCond.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.lock.unlock();
        } else {
            while (this.keepRunning.booleanValue() && this.stopTime <= oldStopTime) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void kill() {
        this.keepRunning = false;
        this.lock.lock();
        this.newTimeSplitCond.signal();
        this.lock.unlock();
    }

    public void printQueues() {
        Iterator<Synapse> it = this.queuesMap.keySet().iterator();
        this.println("Printing queues:");
        while (it.hasNext()) {
            Synapse s = it.next();
            System.out.println(s + ": ");
            this.queuesMap.get(s).printQueue();
        }
        System.out.println();
    }

    private void println(String s) {
        if (verbose.booleanValue()) {
            if (this.nMan != null) {
                System.out.println(TAG + this.getNodeId() + "/" + (this.nMan.getNodeThreadsNum() - 1) + "] " + s);
            } else {
                System.out.println(TAG + this.getNodeId() + "/-] " + s);
            }
        }
    }

    private void debprintln(String s) {
        if (verbose.booleanValue() && this.debug.booleanValue()) {
            System.out.println(TAG + this.getNodeId() + "/" + (this.nMan.getNodeThreadsNum() - 1) + " [debug] ] " + s);
        }
    }

    private void leveldebprintln(String s, int level) {
        if (this.debug_level >= level) {
            this.debprintln(s);
        }
    }

    private void debActiveprintln(String s) {
        if (verbose.booleanValue() && this.debug.booleanValue() && this.activePassiveDebug.booleanValue()) {
            System.out.println(TAG + this.getNodeId() + "/" + (this.nMan.getNodeThreadsNum() - 1) + "[debug] ] " + s);
        }
    }

    public void printDebug() {
        this.println("max pw approximation:" + this.debugMaxWPDiff);
        System.out.println();
    }

    public void print_times() {
    }
}

