/*
 * Decompiled with CFR 0.152.
 */
package spiking.node;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.mapdb.DB;
import org.mapdb.DBMaker;
import org.mapdb.HTreeMap;
import org.mapdb.Serializer;
import spiking.node.external_inputs.ExternalInput;
import utils.tools.LongCouple;
import utils.tools.Shuffler;

public class Node {
    private static final String TAG = "[Node ";
    private static final Boolean verbose = true;
    private Integer id;
    private ExternalInput ext;
    private Long n = 100L;
    private Long excitatory;
    private Long inhibithory;
    private Integer Bn;
    private Double IBI;
    private HashMap<LongCouple, Double> connectionMatrix = new HashMap();
    private Double R = 0.8;
    private Double mu_w_exc;
    private Double mu_w_inh;
    private Double sigma_w_exc;
    private Double sigma_w_inh;
    private Double w_pre_exc;
    private Double w_pre_inh;
    private Integer externalInputs = 0;
    private Integer k = 20;
    private Double prew = 0.5;
    private Boolean hasExternalInputs = false;
    private int externalInputType = -1;
    private Double externalInputsTimeOffset;
    private double timeStep = -1.0;
    private int fireDuration = 1;
    private Double externalAmplitude = ExternalInput.EXTERNAL_AMPLITUDE_DEF_VALUE;
    private int externalOutdegree = 0;
    private int externalOutJump = 1;
    private Boolean plasticity;
    private Double etap;
    private Double etam;
    private Double taup;
    private Double taum;
    private Double pwMax;
    private Double to;
    private HashMap<Long, Boolean> external_init = new HashMap();
    private Random random = new Random();

    public Node(Integer id, Long n, Double R, Double mu_w_exc, Double mu_w_inh, Double sigma_w_exc, Double sigma_w_inh, Double w_pre_exc, Double w_pre_inh, Integer k, Double prew, Integer Bn, Double IBI, Boolean plasticity, Double etap, Double etam, Double taup, Double taum, Double pwMax, Double to) {
        this.id = id;
        this.n = n;
        this.R = R;
        this.mu_w_exc = mu_w_exc;
        this.mu_w_inh = mu_w_inh;
        this.sigma_w_exc = sigma_w_exc;
        this.sigma_w_inh = sigma_w_inh;
        this.w_pre_exc = w_pre_exc;
        this.w_pre_inh = w_pre_inh < 0.0 ? w_pre_inh : -w_pre_inh.doubleValue();
        this.k = k;
        this.prew = prew;
        this.Bn = Bn;
        this.IBI = IBI;
        this.plasticity = plasticity;
        this.etap = etap;
        this.etam = etam;
        this.taup = taup;
        this.taum = taum;
        this.pwMax = pwMax;
        this.to = to;
        this.initExcitInhib();
        this.nodeInit();
    }

    public Node(Integer id, Long n, Integer externalInputs, int externalInputType, Double externalInputsTimeOffset, double timeStep, int fireDuration, Double externalAmplitude, Integer externalOutdegree, Double R, Double mu_w_exc, Double mu_w_inh, Double sigma_w_exc, Double sigma_w_inh, Double w_pre_exc, Double w_pre_inh, Integer k, Double prew, Integer Bn, Double IBI, Boolean plasticity, Double etap, Double etam, Double taup, Double taum, Double pwMax, Double to) {
        this.id = id;
        this.n = n;
        this.externalInputType = externalInputType;
        this.externalInputsTimeOffset = externalInputsTimeOffset;
        this.R = R;
        this.mu_w_exc = mu_w_exc;
        this.mu_w_inh = mu_w_inh;
        this.sigma_w_exc = sigma_w_exc;
        this.sigma_w_inh = sigma_w_inh;
        this.w_pre_exc = w_pre_exc;
        this.w_pre_inh = w_pre_inh < 0.0 ? w_pre_inh : -w_pre_inh.doubleValue();
        if (externalInputs > 0) {
            this.hasExternalInputs = true;
            this.externalInputs = externalInputs;
            this.timeStep = timeStep;
            this.fireDuration = fireDuration;
            this.externalAmplitude = externalAmplitude;
            this.externalOutdegree = externalOutdegree;
            do {
                this.externalOutJump = this.random.nextInt(1987);
            } while (this.externalOutJump == 0);
        }
        this.k = k;
        this.prew = prew;
        this.Bn = Bn;
        this.IBI = IBI;
        this.plasticity = plasticity;
        this.etap = etap;
        this.etam = etam;
        this.taup = taup;
        this.taum = taum;
        this.pwMax = pwMax;
        this.to = to;
        this.initExcitInhib();
        this.nodeInit();
    }

    public void nodeInit() {
        this.println("init...");
        this.wireInit();
        this.externalInputInit();
        this.println("init done.");
    }

    public void initExcitInhib() {
        this.excitatory = (long)Math.floor((double)this.n.longValue() * this.R);
        this.inhibithory = this.n - this.excitatory;
    }

    private void putConnection(Long firingNeuronId, Long burningNeuronId, Double presynaptic_weight) {
        this.connectionMatrix.put(new LongCouple(firingNeuronId, burningNeuronId), presynaptic_weight);
    }

    public Double getConnectionPresynapticWeight(Long firingNeuronId, Long burningNeuronId) {
        return this.connectionMatrix.get(new LongCouple(firingNeuronId, burningNeuronId)) != null ? this.connectionMatrix.get(new LongCouple(firingNeuronId, burningNeuronId)) : 0.0;
    }

    public Iterator<Map.Entry<LongCouple, Double>> getIterator() {
        return this.connectionMatrix.entrySet().iterator();
    }

    public Iterator<LongCouple> getKeyConnectionIterator() {
        return this.connectionMatrix.keySet().iterator();
    }

    public Integer getId() {
        return this.id;
    }

    private void wireInit() {
        if (this.n <= 1L) {
            return;
        }
        this.println("ring wiring...");
        DB tmpDb1 = DBMaker.memoryDirectDB().make();
        DB tmpDb2 = DBMaker.memoryDirectDB().make();
        Object shuffled = tmpDb1.hashMap("shuffle", Serializer.LONG, Serializer.LONG).create();
        Object shuffled_rand = tmpDb2.hashMap("shuffle", Serializer.LONG, Serializer.LONG).create();
        Shuffler.shuffleArray((HTreeMap<Long, Long>)shuffled, this.n);
        Shuffler.shuffleArray((HTreeMap<Long, Long>)shuffled_rand, this.n);
        int k2 = this.k / 2;
        long l = 0L;
        for (long i = 0L; i < this.n; ++i) {
            Long tmpSrc = (Long)((HTreeMap)shuffled).get(i);
            Double tmpAmpl = this.isExcitatory((Long)((HTreeMap)shuffled).get(i)) ? this.w_pre_exc : this.w_pre_inh;
            for (long j = 1L; j <= (long)k2; ++j) {
                Long tmp;
                if (Math.random() < this.prew) {
                    while ((tmp = (Long)((HTreeMap)shuffled_rand).get(l)).equals(tmpSrc) || tmp.equals(((HTreeMap)shuffled).get((i + j) % this.n)) || this.connectionMatrix.get(new LongCouple(tmpSrc, tmp)) != null) {
                        l = (l + 1L) % this.n;
                    }
                    this.putConnection((Long)((HTreeMap)shuffled).get(i), tmp, tmpAmpl);
                } else {
                    this.putConnection((Long)((HTreeMap)shuffled).get(i), (Long)((HTreeMap)shuffled).get((i + j) % this.n), tmpAmpl);
                }
                if (Math.random() < this.prew) {
                    while ((tmp = (Long)((HTreeMap)shuffled_rand).get(l)).equals(tmpSrc) || tmp.equals(((HTreeMap)shuffled).get((this.n + i - j) % this.n)) || this.connectionMatrix.get(new LongCouple(tmpSrc, tmp)) != null) {
                        l = (l + 1L) % this.n;
                    }
                    this.putConnection((Long)((HTreeMap)shuffled).get(i), tmp, tmpAmpl);
                    continue;
                }
                this.putConnection((Long)((HTreeMap)shuffled).get(i), (Long)((HTreeMap)shuffled).get((this.n + i - j) % this.n), tmpAmpl);
            }
        }
        ((HTreeMap)shuffled).close();
        this.println("wiring done.");
    }

    private void externalInputInit() {
        if (this.externalInputs <= 0) {
            this.println("d with no external input.");
            return;
        }
        this.println("creating external input...");
        this.ext = new ExternalInput(this, this.externalInputType, this.externalInputsTimeOffset, this.fireDuration, this.externalAmplitude, this.externalOutdegree, this.timeStep);
        this.println("external input created, external spikes in queue:" + this.ext.getExternalSpikesInQueue());
    }

    public Long getN() {
        return this.n;
    }

    public Long getExcitatory() {
        return this.excitatory;
    }

    public Long getInhibithory() {
        return this.inhibithory;
    }

    public Double getExcitProportion() {
        return this.R;
    }

    public Double getMu_w_exc() {
        return this.mu_w_exc;
    }

    public Double getMu_w_inh() {
        return this.mu_w_inh;
    }

    public Double getMu_w_agnostic(Long neuronId) {
        return this.isExcitatory(neuronId) ? this.mu_w_exc : this.mu_w_inh;
    }

    public Double getSigma_w_exc() {
        return this.sigma_w_exc;
    }

    public Double getSigma_w_inh() {
        return this.sigma_w_inh;
    }

    public Double getSigma_w_agnostic(Long neuronId) {
        Double retval = this.isExcitatory(neuronId) ? this.sigma_w_exc : this.sigma_w_inh;
        return retval == null ? 1.0 : retval;
    }

    public void setMu_w_exc(Double mu_w_exc) {
        this.mu_w_exc = mu_w_exc;
    }

    public void setMu_w_inh(Double mu_w_inh) {
        this.mu_w_inh = mu_w_inh;
    }

    public Double getExc_ampl() {
        return this.w_pre_exc;
    }

    public Double getInh_ampl() {
        return this.w_pre_inh;
    }

    public Double getPresynapticForNeuron(Long neuronId) {
        return this.isExcitatory(neuronId) ? this.w_pre_exc : this.w_pre_inh;
    }

    public Integer getExternalInputs() {
        return this.externalInputs;
    }

    public Integer getK() {
        return this.k;
    }

    public Double getPrew() {
        return this.prew;
    }

    public int getExternalInputsType() {
        return this.externalInputType;
    }

    public void setStandardExternalInput() {
        this.ext = new ExternalInput(this, this.externalInputType, this.externalInputsTimeOffset, this.fireDuration, this.externalAmplitude, this.externalOutdegree, this.timeStep);
    }

    public int getExternalOutDegree() {
        return this.externalOutdegree;
    }

    public int getExternalOutJump() {
        return this.externalOutJump;
    }

    public Boolean hasExternalInput() {
        return this.hasExternalInputs;
    }

    public ExternalInput getExternalInput() {
        return this.ext;
    }

    public Double getAmplitudeValue(Long extNeuronGlobalId) {
        if (extNeuronGlobalId - this.n > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException("[NODE ERROR] The external input id is too big");
        }
        if (this.hasExternalInputs.booleanValue()) {
            return this.ext.getAmplitudeValue((int)(extNeuronGlobalId - this.n));
        }
        return null;
    }

    public Boolean isExternalInput(Long neuronId) {
        return neuronId >= this.n;
    }

    public Integer getBn() {
        return this.Bn != null ? this.Bn : 1;
    }

    public Double getIBI() {
        return this.IBI;
    }

    public Boolean getPlasticity() {
        return this.plasticity;
    }

    public Double getEtap() {
        return this.etap;
    }

    public Double getEtam() {
        return this.etam;
    }

    public Double getTaup() {
        return this.taup;
    }

    public Double getTaum() {
        return this.taum;
    }

    public Double getPwMax() {
        return this.pwMax;
    }

    public Double getPlasticityTo() {
        return this.to;
    }

    public Double getExternalAmplitude() {
        return this.externalAmplitude;
    }

    public Double getExternalInputsTimeOffset(Long extNeuronId) {
        Boolean ext_init = this.external_init.get(extNeuronId);
        double retval = this.externalInputsTimeOffset;
        if (ext_init == null) {
            this.external_init.put(extNeuronId, true);
        } else {
            this.externalInputsTimeOffset = this.timeStep;
        }
        return retval;
    }

    public boolean isExcitatory(Long neuronId) {
        return neuronId < this.excitatory;
    }

    public void printNodesConnections() {
        this.println("printing connections:");
        for (long i = 0L; i < this.n; ++i) {
            System.out.print(i + ".\t");
            for (long j = 0L; j < this.n; ++j) {
                System.out.print(this.getConnectionPresynapticWeight(i, j) + ", ");
            }
            System.out.println();
        }
    }

    private void println(String s) {
        if (verbose.booleanValue()) {
            System.out.println(TAG + this.id + "] " + s);
        }
    }
}

