/*
 * Decompiled with CFR 0.152.
 */
package utils.statistics;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import utils.statistics.CollectedBurn;
import utils.statistics.StatisticsCollector;

public class BurningWriter
extends Thread {
    private final String TAG = "[Burning Writer] ";
    private String defFileName;
    private PrintWriter pw;
    private PrintWriter pwGephi;
    private PrintWriter pwMatlab;
    private DecimalFormat df = new DecimalFormat("#.################");
    private int count = 1;
    private BlockingQueue<CollectedBurn> burningSpikesQueue;
    private StatisticsCollector sc;
    private int sa;

    public BurningWriter(StatisticsCollector sc, String defFileName, int sa) {
        this.sc = sc;
        this.defFileName = defFileName;
        this.sa = sa;
    }

    protected void setWriters(PrintWriter pw, PrintWriter pwGephi, PrintWriter pwMatlab) {
        this.pw = pw;
        this.pwGephi = pwGephi;
        this.pwMatlab = pwMatlab;
    }

    public void init() {
        this.burningSpikesQueue = new ArrayBlockingQueue<CollectedBurn>(this.sa);
    }

    @Override
    public void run() {
        this.init();
        try {
            while (this.sc.keepRunning.booleanValue()) {
                String toStateToPrint;
                String fromStateToPrint;
                CollectedBurn cb = this.burningSpikesQueue.take();
                Double fromState = cb.getFromState();
                Double stepInState = cb.getStepInState();
                if (fromState == null) {
                    fromStateToPrint = this.sc.reducedOutput != false || this.sc.superReducedOutput != false ? "0" : "refr";
                    toStateToPrint = this.sc.reducedOutput != false || this.sc.superReducedOutput != false ? "0" : "refr";
                } else {
                    fromStateToPrint = "" + this.df.format(fromState);
                    toStateToPrint = "" + this.df.format(fromState + stepInState);
                }
                String stepInStateToPrint = stepInState == null ? (this.sc.reducedOutput != false || this.sc.superReducedOutput != false ? "0" : "refr") : "" + this.df.format(stepInState);
                if (this.sc.reducedOutput.booleanValue() || this.sc.superReducedOutput.booleanValue()) {
                    this.pw.println(this.df.format(cb.getBurnTime()) + ", " + cb.getBurningNodeId() + ", " + cb.getBurningNeuronId() + ", " + toStateToPrint);
                } else {
                    this.pw.println(this.df.format(cb.getBurnTime()) + ", " + cb.getFiringNodeId() + ", " + cb.getFiringNeuronId() + ", " + cb.getBurningNodeId() + ", " + cb.getBurningNeuronId() + ", " + cb.fromExternalInput() + ", " + fromStateToPrint + ", " + toStateToPrint + ", " + stepInStateToPrint + ", " + this.df.format(cb.getPostSynapticWeight()) + ", " + this.df.format(cb.getPreSynapticWeight()) + ", " + this.df.format(cb.getTimeToFire()) + ", " + this.df.format(cb.getFireTime() != null ? cb.getFireTime() : 0.0));
                }
                if (this.sc.matlab.booleanValue()) {
                    String toStateToPrintMatlab;
                    String fromStateToPrintMatlab;
                    String refrStringMatlab = "0";
                    if (fromState == null) {
                        fromStateToPrintMatlab = refrStringMatlab;
                        toStateToPrintMatlab = refrStringMatlab;
                    } else {
                        fromStateToPrintMatlab = fromState.toString();
                        toStateToPrintMatlab = "" + (fromState + stepInState);
                    }
                    String stepInStateToPrintMatlab = stepInState == null ? "0" : stepInState.toString();
                    this.pwMatlab.println(cb.getBurnTime().toString() + ", " + cb.getFiringNodeId() + ", " + cb.getFiringNeuronId() + ", " + cb.getBurningNodeId() + ", " + cb.getBurningNeuronId() + ", " + cb.fromExternalInputInteger() + ", " + fromStateToPrintMatlab + ", " + toStateToPrintMatlab + ", " + stepInStateToPrintMatlab + ", " + cb.getPostSynapticWeight() + ", " + cb.getPreSynapticWeight() + ", " + cb.getTimeToFire() + ", " + cb.getFireTime());
                }
                if (!this.sc.gephi.booleanValue() || cb.fromExternalInput().booleanValue()) continue;
                this.pwGephi.println(cb.getFiringNodeId() + "-" + cb.getFiringNeuronId() + ", " + cb.getBurningNodeId() + "-" + cb.getBurningNeuronId());
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.pw.flush();
        this.pw.close();
        if (this.pwMatlab != null) {
            this.pwMatlab.flush();
            this.pwMatlab.close();
        }
        if (this.pwGephi != null) {
            this.pwGephi.flush();
            this.pwGephi.close();
        }
    }

    protected void flush() {
        this.pw.flush();
        if (this.pwMatlab != null) {
            this.pwMatlab.flush();
        }
        if (this.pwGephi != null) {
            this.pwGephi.flush();
        }
    }

    protected void put(CollectedBurn cb) {
        try {
            this.burningSpikesQueue.put(cb);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

