/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.DoubleList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyDoubleIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;

public class ReverseDoubleIterable
extends AbstractLazyDoubleIterable {
    private final DoubleList adapted;

    public ReverseDoubleIterable(DoubleList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseDoubleIterable adapt(DoubleList doubleList) {
        return new ReverseDoubleIterable(doubleList);
    }

    public DoubleIterator doubleIterator() {
        return new ReverseDoubleIterator();
    }

    public void each(DoubleProcedure procedure) {
        DoubleIterator iterator2 = this.doubleIterator();
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    public double sum() {
        return this.adapted.sum();
    }

    public double max() {
        return this.adapted.max();
    }

    public double min() {
        return this.adapted.min();
    }

    public double minIfEmpty(double defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public double maxIfEmpty(double defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average() {
        return this.adapted.average();
    }

    public double median() {
        return this.adapted.median();
    }

    public double[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    public double[] toArray() {
        double[] results = new double[this.adapted.size()];
        int index = 0;
        DoubleIterator iterator2 = this.doubleIterator();
        while (iterator2.hasNext()) {
            results[index] = iterator2.next();
            ++index;
        }
        return results;
    }

    public boolean contains(double value) {
        return this.adapted.contains(value);
    }

    public boolean containsAll(double ... source) {
        return this.adapted.containsAll(source);
    }

    public boolean containsAll(DoubleIterable source) {
        return this.adapted.containsAll(source);
    }

    public int size() {
        return this.adapted.size();
    }

    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    public MutableDoubleList toList() {
        return DoubleArrayList.newList(this);
    }

    public MutableDoubleSet toSet() {
        return DoubleHashSet.newSet(this);
    }

    public MutableDoubleBag toBag() {
        return DoubleHashBag.newBag(this);
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter(this);
    }

    private class ReverseDoubleIterator
    implements DoubleIterator {
        private int currentIndex;

        private ReverseDoubleIterator() {
            this.currentIndex = ReverseDoubleIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public double next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            double next = ReverseDoubleIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

