/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedFloatCollection;
import org.eclipse.collections.impl.factory.primitive.FloatLists;
import org.eclipse.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseFloatIterable;
import org.eclipse.collections.impl.list.mutable.primitive.UnmodifiableFloatList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public final class SynchronizedFloatList
extends AbstractSynchronizedFloatCollection
implements MutableFloatList {
    private static final long serialVersionUID = 1L;

    SynchronizedFloatList(MutableFloatList list) {
        super(list);
    }

    SynchronizedFloatList(MutableFloatList list, Object newLock) {
        super(list, newLock);
    }

    @GuardedBy(value="getLock()")
    private MutableFloatList getMutableFloatList() {
        return (MutableFloatList)this.getFloatCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float get(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFirst() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getLast() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(float value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().indexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(float value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().lastIndexOf(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAtIndex(int index, float element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatList().addAtIndex(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAllAtIndex(int index, float ... source) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().addAllAtIndex(index, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAllAtIndex(int index, FloatIterable source) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().addAllAtIndex(index, source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float removeAtIndex(int index) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().removeAtIndex(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float set(int index, float element) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatList with(float element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatList().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatList without(float element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatList().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatList withAll(FloatIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatList().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedFloatList withoutAll(FloatIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatList().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatList select(FloatPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatList reject(FloatPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableList<V> collect(FloatToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatList sortThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatList().sortThis();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int binarySearch(float value) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().binarySearch(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double dotProduct(FloatList list) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().dotProduct(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherList) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().equals(otherList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyFloatIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyFloatIterableAdapter(this);
        }
    }

    @Override
    public MutableFloatList asUnmodifiable() {
        return new UnmodifiableFloatList(this);
    }

    @Override
    public MutableFloatList asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableFloatList toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            int size2 = this.size();
            if (size2 == 0) {
                return FloatLists.immutable.with();
            }
            if (size2 == 1) {
                return FloatLists.immutable.with(this.getFirst());
            }
            return FloatLists.immutable.with(this.toArray());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatList reverseThis() {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatList().reverseThis();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatList toReversed() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().toReversed();
        }
    }

    @Override
    public LazyFloatIterable asReversed() {
        return ReverseFloatIterable.adapt(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forEachWithIndex(FloatIntProcedure procedure) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableFloatList().forEachWithIndex(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectIntoWithIndex(T injectedValue, ObjectFloatIntToObjectFunction<? super T, ? extends T> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().injectIntoWithIndex(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableFloatList distinct() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableFloatList().distinct();
        }
    }

    @Override
    public MutableFloatList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }
}

