/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntBooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntBooleanProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.collection.primitive.ImmutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.map.primitive.ImmutableIntBooleanMap;
import org.eclipse.collections.api.map.primitive.IntBooleanMap;
import org.eclipse.collections.api.map.primitive.MutableIntBooleanMap;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntBooleanPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedIntBooleanProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableBooleanCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableBooleanIterator;
import org.eclipse.collections.impl.map.mutable.primitive.IntBooleanHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ImmutableIntBooleanHashMap
implements ImmutableIntBooleanMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableIntBooleanMap delegate;

    ImmutableIntBooleanHashMap(IntBooleanMap delegate) {
        this.delegate = new IntBooleanHashMap(delegate);
    }

    @Override
    public boolean get(int key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean getIfAbsent(int key, boolean ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public boolean getOrThrow(int key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(int key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(boolean value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(BooleanProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(IntProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(IntBooleanProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyIntIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<IntBooleanPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableIntBooleanMap select(IntBooleanPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableIntBooleanMap reject(IntBooleanPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableIntBooleanMap toImmutable() {
        return this;
    }

    @Override
    public BooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator(this.delegate.booleanIterator());
    }

    @Override
    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(BooleanProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(BooleanPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableBooleanCollection select(BooleanPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableBooleanCollection reject(BooleanPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public <V> ImmutableCollection<V> collect(BooleanToObjectFunction<? extends V> function) {
        return this.delegate.collect(function).toImmutable();
    }

    @Override
    public boolean[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(boolean value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(boolean ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(BooleanIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableBooleanList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableBooleanSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableBooleanBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyBooleanIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableIntBooleanMap newWithKeyValue(int key, boolean value) {
        IntBooleanHashMap map2 = new IntBooleanHashMap(this.size() + 1);
        map2.putAll(this);
        map2.put(key, value);
        return map2.toImmutable();
    }

    @Override
    public ImmutableIntBooleanMap newWithoutKey(int key) {
        IntBooleanHashMap map2 = new IntBooleanHashMap(this.size());
        map2.putAll(this);
        map2.removeKey(key);
        return map2.toImmutable();
    }

    @Override
    public ImmutableIntBooleanMap newWithoutAllKeys(IntIterable keys) {
        IntBooleanHashMap map2 = new IntBooleanHashMap(this.size());
        map2.putAll(this);
        IntIterator iterator2 = keys.intIterator();
        while (iterator2.hasNext()) {
            map2.removeKey(iterator2.next());
        }
        return map2.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(this.delegate.keySet());
    }

    @Override
    public MutableBooleanCollection values() {
        return UnmodifiableBooleanCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableIntBooleanMapSerializationProxy(this);
    }

    protected static class ImmutableIntBooleanMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private IntBooleanMap map;

        public ImmutableIntBooleanMapSerializationProxy() {
        }

        protected ImmutableIntBooleanMapSerializationProxy(IntBooleanMap map2) {
            this.map = map2;
        }

        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedIntBooleanProcedure(){

                    public void safeValue(int key, boolean value) throws IOException {
                        out.writeInt(key);
                        out.writeBoolean(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size2 = in.readInt();
            IntBooleanHashMap deserializedMap = new IntBooleanHashMap();
            for (int i = 0; i < size2; ++i) {
                deserializedMap.put(in.readInt(), in.readBoolean());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

