/*
 * Decompiled with CFR 0.152.
 */
package spiking.node;

import java.io.Serializable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Synapse
implements Comparable<Synapse>,
Serializable {
    private static final long serialVersionUID = -4428703256832002027L;
    private static final String TAG = "[Syapse] ";
    private static final Boolean verbose = true;
    private Long firingNeuronId;
    private Long burningNeuronId;
    private Integer firingNodeId;
    private Integer burningNodeId;
    private Boolean fromExternalNode = false;
    private Boolean fromExternalInput = false;
    private Double length;
    private Double mu_w;
    private Double presynaptic_w;
    private Double lastBurningTime;

    public Synapse(Integer firingNodeId, Long firingNeuronId, Integer burningNodeId, Long burningNeuronId, Double length, Double mu_w, Double presynaptic_w, Boolean fromExternalInput, Boolean fromExternalNode) {
        this.firingNodeId = firingNodeId;
        this.firingNeuronId = firingNeuronId;
        this.burningNodeId = burningNodeId;
        this.burningNeuronId = burningNeuronId;
        this.fromExternalNode = fromExternalNode;
        this.length = length;
        this.presynaptic_w = presynaptic_w;
        this.fromExternalInput = fromExternalInput;
        this.setPostsynapticWeight(mu_w);
    }

    public Boolean fromExternalNode() {
        return this.fromExternalNode;
    }

    public Long getAxonNeuronId() {
        return this.firingNeuronId;
    }

    public Long getFiring() {
        return this.firingNeuronId;
    }

    public void setAxonNeuronId(Long firingNeuronId) {
        this.firingNeuronId = firingNeuronId;
    }

    public Long getBurningNeuronId() {
        return this.burningNeuronId;
    }

    public Long getBurning() {
        return this.burningNeuronId;
    }

    public void setBurningNeuronId(Long burningNeuronId) {
        this.burningNeuronId = burningNeuronId;
    }

    public Integer getAxonNodeId() {
        return this.firingNodeId;
    }

    public Integer getFiringNodeId() {
        return this.firingNodeId;
    }

    public void setAxonNodeId(Integer firingNodeId) {
        this.firingNodeId = firingNodeId;
    }

    public Integer getBurningNodeId() {
        return this.burningNodeId;
    }

    public void setBurningNodeId(Integer burningNodeId) {
        this.burningNodeId = burningNodeId;
    }

    public Double getLength() {
        return this.length;
    }

    public void setLenght(Double length) {
        this.length = length;
    }

    public Double getPostSynapticWeight() {
        return this.mu_w == null ? 1.0 : this.mu_w;
    }

    public void setPostsynapticWeight(Double post_synaptic_weight) {
        this.mu_w = post_synaptic_weight != null && post_synaptic_weight == 1.0 ? null : post_synaptic_weight;
    }

    public Double getPreSynapticWeight() {
        return this.presynaptic_w;
    }

    public Boolean fromExternal() {
        return this.fromExternalNode != false || this.fromExternalInput != false;
    }

    public Double getLastBurningTime() {
        return this.lastBurningTime;
    }

    public void setLastBurningTime(Double lastBurningTime) {
        this.lastBurningTime = lastBurningTime;
    }

    public void resetLastBurningTime() {
        this.lastBurningTime = null;
    }

    public String toString() {
        return "[firing:" + this.firingNodeId + "-" + this.firingNeuronId + ", burning:" + this.burningNodeId + "-" + this.burningNeuronId + " from external:" + this.fromExternalNode + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        Synapse rhs = (Synapse)obj;
        return new EqualsBuilder().append(this.firingNodeId, rhs.firingNodeId).append(this.firingNeuronId, rhs.firingNeuronId).append(this.burningNodeId, rhs.burningNodeId).append(this.burningNeuronId, rhs.burningNeuronId).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(7L * this.firingNeuronId + 9L + (long)this.firingNodeId.intValue()).append(this.burningNeuronId * (long)this.burningNodeId.intValue() + 3L * this.firingNeuronId + 17L).toHashCode();
    }

    @Override
    public int compareTo(Synapse o) {
        if (this == o) {
            return 0;
        }
        int retval = this.firingNeuronId.compareTo(o.getAxonNeuronId());
        if (retval != 0) {
            return retval;
        }
        retval = this.burningNeuronId.compareTo(o.getBurningNeuronId());
        if (retval != 0) {
            return retval;
        }
        retval = this.firingNodeId.compareTo(o.getAxonNodeId());
        if (retval != 0) {
            return retval;
        }
        retval = this.burningNodeId.compareTo(o.getBurningNodeId());
        return retval;
    }

    public Boolean fromExternalInput() {
        return this.fromExternalInput;
    }

    public Integer fromExternalInputInteger() {
        return this.fromExternalInput != false ? 1 : 0;
    }

    public void setFromExternalInput(Boolean fromExternalInput) {
        this.fromExternalInput = fromExternalInput;
    }

    private void println(String s) {
        if (verbose.booleanValue()) {
            System.out.println(TAG + s);
        }
    }
}

